/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.xml;

import fr.jayasoft.ivy.ArtifactId;
import fr.jayasoft.ivy.Configuration;
import fr.jayasoft.ivy.ConflictManager;
import fr.jayasoft.ivy.DefaultDependencyArtifactDescriptor;
import fr.jayasoft.ivy.DefaultDependencyDescriptor;
import fr.jayasoft.ivy.DefaultModuleDescriptor;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.License;
import fr.jayasoft.ivy.MDArtifact;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.conflict.FixedConflictManager;
import fr.jayasoft.ivy.matcher.PatternMatcher;
import fr.jayasoft.ivy.namespace.Namespace;
import fr.jayasoft.ivy.parser.AbstractModuleDescriptorParser;
import fr.jayasoft.ivy.repository.Resource;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.XMLHelper;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorUpdater;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XmlModuleDescriptorParser
extends AbstractModuleDescriptorParser {
    private static XmlModuleDescriptorParser INSTANCE = new XmlModuleDescriptorParser();

    public static XmlModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    private XmlModuleDescriptorParser() {
    }

    public ModuleDescriptor parseDescriptor(Ivy ivy, URL xmlURL, Resource res, boolean validate) throws ParseException, IOException {
        Parser parser = new Parser(ivy, validate);
        parser.parse(xmlURL, res, validate);
        return parser.getModuleDescriptor();
    }

    public boolean accept(Resource res) {
        return true;
    }

    public void toIvyFile(URL srcURL, Resource res, File destFile, ModuleDescriptor md) throws IOException, ParseException {
        try {
            Namespace ns = null;
            if (md instanceof DefaultModuleDescriptor) {
                DefaultModuleDescriptor dmd = (DefaultModuleDescriptor)md;
                ns = dmd.getNamespace();
            }
            XmlModuleDescriptorUpdater.update(null, srcURL, destFile, Collections.EMPTY_MAP, md.getStatus(), md.getResolvedModuleRevisionId().getRevision(), md.getResolvedPublicationDate(), ns, false);
        }
        catch (SAXException e) {
            ParseException ex = new ParseException("exception occured while parsing " + srcURL, 0);
            ex.initCause(e);
            throw ex;
        }
    }

    public String toString() {
        return "ivy parser";
    }

    public static void main(String[] args) throws Exception {
        System.out.println(XmlModuleDescriptorParser.getInstance().parseDescriptor(new Ivy(), new File("test/xml/module1/module1.ivy.xml").toURL(), true));
    }

    private static class Parser
    extends AbstractModuleDescriptorParser.AbstractParser {
        private static final List ALLOWED_VERSIONS = Arrays.asList("1.0", "1.1", "1.2", "1.3");
        private DefaultDependencyDescriptor _dd;
        private DefaultDependencyArtifactDescriptor _dad;
        private MDArtifact _artifact;
        private String _conf;
        private boolean _validate = true;
        private Ivy _ivy;
        private boolean _artifactsDeclared = false;
        private PatternMatcher _defaultMatcher;
        private static final int NONE = 0;
        private static final int INFO = 1;
        private static final int CONF = 2;
        private static final int PUB = 3;
        private static final int DEP = 4;
        private static final int ARTIFACT_INCLUDE = 5;
        private static final int ARTIFACT_EXCLUDE = 6;
        private static final int CONFLICT = 7;
        private int _state = 0;

        public Parser(Ivy ivy, boolean validate) {
            this._ivy = ivy;
            this._validate = validate;
        }

        private void parse(URL xmlURL, Resource res, boolean validate) throws ParseException, IOException {
            try {
                this.setResource(res);
                URL schemaURL = validate ? this.getClass().getResource("ivy.xsd") : null;
                XMLHelper.parse(xmlURL, schemaURL, this);
                this.checkConfigurations();
                if (!this._artifactsDeclared) {
                    String[] confs = this._md.getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this._md.addArtifact(confs[i], new MDArtifact(this._md, this._md.getModuleRevisionId().getName(), "jar", "jar"));
                    }
                }
                this._md.check();
            }
            catch (ParserConfigurationException ex) {
                IllegalStateException ise = new IllegalStateException(ex.getMessage() + " in " + xmlURL);
                ise.initCause(ex);
                throw ise;
            }
            catch (Exception ex) {
                this.checkErrors();
                ParseException pe = new ParseException(ex.getMessage() + " in " + xmlURL, 0);
                pe.initCause(ex);
                throw pe;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                if ("ivy-module".equals(qName)) {
                    String version = attributes.getValue("version");
                    int versionIndex = ALLOWED_VERSIONS.indexOf(version);
                    if (versionIndex == -1) {
                        this.addError("invalid version " + version);
                        throw new SAXException("invalid version " + version);
                    }
                    if (versionIndex >= ALLOWED_VERSIONS.indexOf("1.3")) {
                        Message.debug("post 1.3 ivy file: using exact as default matcher");
                        this._defaultMatcher = this._ivy.getMatcher("exact");
                        return;
                    } else {
                        Message.debug("pre 1.3 ivy file: using exactOrRegexp as default matcher");
                        this._defaultMatcher = this._ivy.getMatcher("exactOrRegexp");
                    }
                    return;
                }
                if ("info".equals(qName)) {
                    String status;
                    this._state = 1;
                    String org = this._ivy.substitute(attributes.getValue("organisation"));
                    String module = this._ivy.substitute(attributes.getValue("module"));
                    String revision = this._ivy.substitute(attributes.getValue("revision"));
                    this._md.setModuleRevisionId(ModuleRevisionId.newInstance(org, module, revision));
                    String namespace = this._ivy.substitute(attributes.getValue("namespace"));
                    if (namespace != null) {
                        Namespace ns = this._ivy.getNamespace(namespace);
                        if (ns == null) {
                            Message.warn("namespace not found for " + this._md.getModuleRevisionId() + ": " + namespace);
                        } else {
                            this._md.setNamespace(ns);
                        }
                    }
                    this._md.setStatus((status = this._ivy.substitute(attributes.getValue("status"))) == null ? "integration" : status);
                    this._md.setDefault(Boolean.valueOf(this._ivy.substitute(attributes.getValue("default"))));
                    String pubDate = this._ivy.substitute(attributes.getValue("publication"));
                    if (pubDate != null && pubDate.length() > 0) {
                        try {
                            this._md.setPublicationDate(Ivy.DATE_FORMAT.parse(pubDate));
                            return;
                        }
                        catch (ParseException e) {
                            this.addError("invalid publication date format: " + pubDate);
                            this._md.setPublicationDate(this.getDefaultPubDate());
                        }
                        return;
                    } else {
                        this._md.setPublicationDate(this.getDefaultPubDate());
                    }
                    return;
                }
                if ("license".equals(qName)) {
                    this._md.addLicense(new License(this._ivy.substitute(attributes.getValue("name")), this._ivy.substitute(attributes.getValue("url"))));
                    return;
                }
                if ("description".equals(qName)) {
                    this._md.setHomePage(this._ivy.substitute(attributes.getValue("homepage")));
                    return;
                }
                if ("configurations".equals(qName)) {
                    this._state = 2;
                    this.setDefaultConfMapping(this._ivy.substitute(attributes.getValue("defaultconfmapping")));
                    return;
                }
                if ("publications".equals(qName)) {
                    this._state = 3;
                    this._artifactsDeclared = true;
                    this.checkConfigurations();
                    return;
                }
                if ("dependencies".equals(qName)) {
                    this._state = 4;
                    String defaultConf = this._ivy.substitute(attributes.getValue("defaultconf"));
                    if (defaultConf != null) {
                        this.setDefaultConf(defaultConf);
                    }
                    if ((defaultConf = this._ivy.substitute(attributes.getValue("defaultconfmapping"))) != null) {
                        this.setDefaultConfMapping(defaultConf);
                    }
                    this.checkConfigurations();
                    return;
                }
                if ("conflicts".equals(qName)) {
                    this._state = 7;
                    this.checkConfigurations();
                    return;
                }
                if ("artifact".equals(qName)) {
                    if (this._state == 3) {
                        String ext = this._ivy.substitute(attributes.getValue("ext"));
                        ext = ext != null ? ext : this._ivy.substitute(attributes.getValue("type"));
                        this._artifact = new MDArtifact(this._md, this._ivy.substitute(attributes.getValue("name")), this._ivy.substitute(attributes.getValue("type")), ext);
                        String confs = this._ivy.substitute(attributes.getValue("conf"));
                        if (confs == null || confs.length() <= 0) return;
                        String[] conf = "*".equals(confs) ? this._md.getConfigurationsNames() : confs.split(",");
                        for (int i = 0; i < conf.length; ++i) {
                            this._artifact.addConfiguration(conf[i].trim());
                            this._md.addArtifact(conf[i].trim(), this._artifact);
                        }
                        return;
                    } else if (this._state == 4) {
                        this.addDependencyArtifactsIncludes(attributes);
                        return;
                    } else {
                        if (!this._validate) return;
                        this.addError("artifact tag found in invalid tag: " + this._state);
                    }
                    return;
                }
                if ("include".equals(qName) && this._state == 4) {
                    this.addDependencyArtifactsIncludes(attributes);
                    return;
                }
                if ("exclude".equals(qName)) {
                    this.addDependencyArtifactsExcludes(attributes);
                    return;
                }
                if ("dependency".equals(qName)) {
                    String org = this._ivy.substitute(attributes.getValue("org"));
                    if (org == null) {
                        org = this._md.getModuleRevisionId().getOrganisation();
                    }
                    boolean force = Boolean.valueOf(this._ivy.substitute(attributes.getValue("force")));
                    boolean changing = Boolean.valueOf(this._ivy.substitute(attributes.getValue("changing")));
                    String transitiveValue = this._ivy.substitute(attributes.getValue("transitive"));
                    boolean transitive = transitiveValue == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
                    String name = this._ivy.substitute(attributes.getValue("name"));
                    String rev = this._ivy.substitute(attributes.getValue("rev"));
                    this._dd = new DefaultDependencyDescriptor(this._md, ModuleRevisionId.newInstance(org, name, rev), force, changing, transitive);
                    this._md.addDependency(this._dd);
                    String confs = this._ivy.substitute(attributes.getValue("conf"));
                    if (confs == null || confs.length() <= 0) return;
                    this.parseDepsConfs(confs, this._dd);
                    return;
                }
                if ("conf".equals(qName)) {
                    String conf = this._ivy.substitute(attributes.getValue("name"));
                    switch (this._state) {
                        case 2: {
                            String visibility = this._ivy.substitute(attributes.getValue("visibility"));
                            String ext = this._ivy.substitute(attributes.getValue("extends"));
                            this._md.addConfiguration(new Configuration(conf, Configuration.Visibility.getVisibility(visibility == null ? "public" : visibility), this._ivy.substitute(attributes.getValue("description")), ext == null ? null : ext.split(",")));
                            return;
                        }
                        case 3: {
                            if ("*".equals(conf)) {
                                String[] confs = this._md.getConfigurationsNames();
                                for (int i = 0; i < confs.length; ++i) {
                                    this._artifact.addConfiguration(confs[i]);
                                    this._md.addArtifact(confs[i], this._artifact);
                                }
                                return;
                            }
                            this._artifact.addConfiguration(conf);
                            this._md.addArtifact(conf, this._artifact);
                            return;
                        }
                        case 4: {
                            this._conf = conf;
                            String mappeds = this._ivy.substitute(attributes.getValue("mapped"));
                            if (mappeds == null) return;
                            String[] mapped = mappeds.split(",");
                            for (int i = 0; i < mapped.length; ++i) {
                                this._dd.addDependencyConfiguration(this._conf, mapped[i].trim());
                            }
                            return;
                        }
                        case 5: 
                        case 6: {
                            this._dad.addConfiguration(conf);
                            return;
                        }
                        default: {
                            if (!this._validate) return;
                            this.addError("conf tag found in invalid tag: " + this._state);
                        }
                    }
                    return;
                }
                if ("mapped".equals(qName)) {
                    this._dd.addDependencyConfiguration(this._conf, this._ivy.substitute(attributes.getValue("name")));
                    return;
                } else if ("manager".equals(qName) && this._state == 7) {
                    PatternMatcher matcher;
                    ConflictManager cm;
                    String org = this._ivy.substitute(attributes.getValue("org"));
                    org = org == null ? "*" : org;
                    String mod = this._ivy.substitute(attributes.getValue("module"));
                    mod = mod == null ? "*" : mod;
                    String name = this._ivy.substitute(attributes.getValue("name"));
                    String rev = this._ivy.substitute(attributes.getValue("rev"));
                    if (rev != null) {
                        String[] revs = rev.split(",");
                        for (int i = 0; i < revs.length; ++i) {
                            revs[i] = revs[i].trim();
                        }
                        cm = new FixedConflictManager(revs);
                    } else if (name != null) {
                        cm = this._ivy.getConflictManager(name);
                        if (cm == null) {
                            this.addError("unknown conflict manager: " + name);
                            return;
                        }
                    } else {
                        this.addError("bad conflict manager: no name nor rev");
                        return;
                    }
                    String matcherName = this._ivy.substitute(attributes.getValue("matcher"));
                    PatternMatcher patternMatcher = matcher = matcherName == null ? this._defaultMatcher : this._ivy.getMatcher(matcherName);
                    if (matcher == null) {
                        this.addError("unknown matcher: " + matcherName);
                        return;
                    }
                    this._md.addConflictManager(new ModuleId(org, mod), matcher, cm);
                    return;
                } else if ("import".equals(qName) || "include".equals(qName) && this._state == 2) {
                    URL url;
                    String fileName = this._ivy.substitute(attributes.getValue("file"));
                    if (fileName == null) {
                        String urlStr = this._ivy.substitute(attributes.getValue("url"));
                        url = new URL(urlStr);
                    } else {
                        url = new File(fileName).toURL();
                    }
                    Parser parser = new Parser(this._ivy, false);
                    parser._md = new DefaultModuleDescriptor();
                    XMLHelper.parse(url, null, parser);
                    Configuration[] configs = parser.getModuleDescriptor().getConfigurations();
                    for (int i = 0; i < configs.length; ++i) {
                        this._md.addConfiguration(configs[i]);
                    }
                    if (parser.getDefaultConfMapping() == null) return;
                    Message.debug("setting default conf from imported configurations file: " + parser.getDefaultConfMapping());
                    this.setDefaultConfMapping(parser.getDefaultConfMapping());
                    return;
                } else {
                    if (!this._validate || this._state == 1) return;
                    this.addError("unknwon tag " + qName);
                }
                return;
            }
            catch (Exception ex) {
                if (!(ex instanceof SAXException)) throw new SAXException("problem occured while parsing ivy file. message: " + ex.getMessage(), ex);
                throw (SAXException)ex;
            }
        }

        private void addDependencyArtifactsIncludes(Attributes attributes) {
            this._state = 5;
            this.addDependencyArtifact(attributes, true);
        }

        private void addDependencyArtifactsExcludes(Attributes attributes) {
            this._state = 6;
            this.addDependencyArtifact(attributes, false);
        }

        private void addDependencyArtifact(Attributes attributes, boolean includes) {
            PatternMatcher matcher;
            String name = this._ivy.substitute(attributes.getValue("name"));
            name = name == null ? "*" : name;
            String type = this._ivy.substitute(attributes.getValue("type"));
            type = type == null ? "*" : type;
            String ext = this._ivy.substitute(attributes.getValue("ext"));
            ext = ext != null ? ext : type;
            String matcherName = this._ivy.substitute(attributes.getValue("matcher"));
            PatternMatcher patternMatcher = matcher = matcherName == null ? this._defaultMatcher : this._ivy.getMatcher(matcherName);
            if (matcher == null) {
                this.addError("unknown matcher " + matcherName);
                return;
            }
            if (includes) {
                this._dad = new DefaultDependencyArtifactDescriptor(this._dd, name, type, ext, includes, matcher);
            } else {
                String org = this._ivy.substitute(attributes.getValue("org"));
                org = org == null ? "*" : org;
                String module = this._ivy.substitute(attributes.getValue("module"));
                module = module == null ? "*" : module;
                ArtifactId aid = new ArtifactId(new ModuleId(org, module), name, type, ext);
                this._dad = new DefaultDependencyArtifactDescriptor(this._dd, aid, includes, matcher);
            }
            String confs = this._ivy.substitute(attributes.getValue("conf"));
            if (confs != null && confs.length() > 0) {
                String[] conf = "*".equals(confs) ? this._md.getConfigurationsNames() : confs.split(",");
                for (int i = 0; i < conf.length; ++i) {
                    this._dad.addConfiguration(conf[i].trim());
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this._state == 3 && "artifact".equals(qName) && this._artifact.getConfigurations().length == 0) {
                String[] confs = this._md.getConfigurationsNames();
                for (int i = 0; i < confs.length; ++i) {
                    this._artifact.addConfiguration(confs[i]);
                    this._md.addArtifact(confs[i], this._artifact);
                }
            } else if ("configurations".equals(qName)) {
                this.checkConfigurations();
            } else if (this._state == 5 && ("artifact".equals(qName) || "include".equals(qName)) || this._state == 6 && "exclude".equals(qName)) {
                this._state = 4;
                if (this._dad.getConfigurations().length == 0) {
                    String[] confs = this._md.getConfigurationsNames();
                    for (int i = 0; i < confs.length; ++i) {
                        this._dad.addConfiguration(confs[i]);
                    }
                }
            } else if ("dependency".equals(qName) && this._dd.getModuleConfigurations().length == 0) {
                this.parseDepsConfs(this.getDefaultConf(), this._dd);
            }
        }

        private void checkConfigurations() {
            if (this._md.getConfigurations().length == 0) {
                this._md.addConfiguration(new Configuration("default"));
            }
        }
    }
}

