<style>
    .form-control:focus {
        border-color: #ff6f00 !important;
        box-shadow: 0 0 0 .2rem rgba(255, 111, 0, .25);
    }
    
    .pull-right a {
        color: #ff6f00 !important;
    }
    
    .custom-control-label a {
        color: #ff6f00 !important;
    }
    
    .brand-logo {
        display: none;
    }
    
    .row .col-lg-7 a {
        display: flex;
        justify-content: center;
    }
    
    @media screen and (max-width: 600px) {
        .brand-logo {
            display: block !important;
        } 
    }
</style>

<form method="POST" action="{{ route('register') }}" id="register-form">
    @csrf

    @if(getSetting('social.facebook_client_id') || getSetting('social.twitter_client_id') || getSetting('social.google_client_id'))
        <div class="my-1">
            <p class="mb-0">
                {{__('Already got an account?')}}
                @if(isset($mode) && $mode == 'ajax')
                    <a href="javascript:void(0);" onclick="LoginModal.changeActiveTab('login')" class="text-primary text-gradient font-weight-bold">{{__('Sign in')}}</a>
                @else
                    <a href="{{route('login')}}" class="text-primary text-gradient font-weight-bold">{{__('Sign in')}}</a>
                @endif
            </p>
        </div>
    @endif

    <div class="form-group ">
        <label for="name" class="col-form-label">{{ __('Name or Club Network') }}</label>
        <div class="">
            <input id="name" type="text" class="form-control @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}"  autocomplete="name" autofocus>
            @error('name')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
            @enderror
        </div>
    </div>

    <div class="form-group ">
        <label for="email" class=" col-form-label ">{{ __('Email Address or Company Email') }}</label>
        <div class="">
            <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" required autocomplete="email">
            @error('email')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
            @enderror
        </div>
    </div>

    <div class="form-group ">
        <label for="password" class=" col-form-label ">{{ __('Password') }}</label>
        <div class="">
            <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" required name="password" autocomplete="new-password">

            @error('password')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
            @enderror
        </div>
    </div>

    <div class="form-group ">
        <label for="password-confirm" class=" col-form-label ">{{ __('Confirm Password') }}</label>

        <div class="">
            <input id="password-confirm" type="password" class="form-control @error('password_confirmation') is-invalid @enderror" required name="password_confirmation" autocomplete="new-password">
            @error('password_confirmation')
            <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
            </span>
            @enderror
        </div>
    </div>

    <div class="form-group">
        <div class="custom-control custom-checkbox">
            <div class="justify-content-center">
                <input class="custom-control-input @error('terms') is-invalid @enderror" id="tosAgree" type="checkbox" name="terms" value="1" placeholder="{{ __('Terms and Conditions') }}">
                <label class="custom-control-label" for="tosAgree">
                    <span>{{ __('I agree to the') }} <a href="{{route('pages.get',['slug'=>GenericHelper::getTOSPage()->slug])}}"  style="display: inline;">{{ __('Terms of Use') }}</a> {{ __('and') }} <a href="{{route('pages.get',['slug'=>GenericHelper::getPrivacyPage()->slug])}}" style="display: inline;">{{ __('Privacy Policy') }}</a>.</span>
                </label>
            </div>
        </div>
    </div>

    @if(getSetting('security.captcha_driver') !== 'none' && !Auth::check())
        @include('elements.captcha-field')
    @endif

    <div class="form-group row mb-0">
        <div class="col">
            <button type="submit" class="btn btn-grow btn-lg btn-primary bg-gradient-primary btn-block">
                {{ __('Register') }}
            </button>
        </div>
    </div>

</form>
@if(!getSetting('social.facebook_client_id') && !getSetting('social.twitter_client_id') && !getSetting('social.google_client_id'))
    <hr>
    <div class=" text-center">
        <p class="mb-4">
            {{__('Already got an account?')}}
            @if(isset($mode) && $mode == 'ajax')
                <a href="javascript:void(0);" onclick="LoginModal.changeActiveTab('login')" class="text-primary text-gradient font-weight-bold">{{__('Sign in')}}</a>
            @else
                <a href="{{route('login')}}" class="text-primary text-gradient font-weight-bold">{{__('Sign in')}}</a>
            @endif
        </p>
    </div>
@endif
