<?php
// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Validate required fields
    $artist_name = isset($_POST["artist_name"]) ? htmlspecialchars($_POST["artist_name"]) : "";
    $genre = isset($_POST["genre"]) ? htmlspecialchars($_POST["genre"]) : "";
    $email = isset($_POST["email"]) ? htmlspecialchars($_POST["email"]) : "";
    $contact = isset($_POST["contact"]) ? htmlspecialchars($_POST["contact"]) : "";
    $social_media_handle = isset($_POST["social_media_handle"]) ? htmlspecialchars($_POST["social_media_handle"]) : "";
    $video_link = isset($_POST["video_link"]) ? htmlspecialchars($_POST["video_link"]) : "";
    $bio = isset($_POST["bio"]) ? htmlspecialchars($_POST["bio"]) : "";

    // Check if required fields are empty
    if (empty($artist_name) || empty($genre) || empty($email) || empty($contact) || empty($social_media_handle) || empty($video_link) || empty($bio)) {
        die("Error: All required fields must be filled.");
    }

    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Error: Invalid email format.");
    }

    // Set recipient email
    $to = "support@mostreams.com"; // Change to your webmail address

    // Email subject
    $subject = "New Contact Form Submission - " . $artist_name;

    // Email bio
    $body = "Artist Name: $artist_name\n";
    $body .= "Genre: $genre\n";
    $body .= "Email: $email\n";
    $body .= "Contact Number: $contact\n";
    $body .= "Social Media Handle: $social_media_handle\n";
    $body .= "Video Link: $video_link\n";
    $body .= "Bio:\n$bio\n";

    // Headers
    $headers = "From: noreply@mostreams.com\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Send the email
    $sent = mail($to, $subject, $body, $headers);

    if (mail($to, $subject, $bio, $headers)) {
        // Successful submission bio with styling and animation
        echo "
        <html>
        <head>
            <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css' rel='stylesheet'>
            <style>
                body, html {
                    background-color: #030303;
                    color: #E36220;
                    height: 100%;
                    margin: 0;
                    font-family: Arial, sans-serif;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    text-align: center;
                    position: relative;
                    overflow: hidden;
                }
                h2 {
                    margin: 0;
                }
                p {
                    margin-bottom: 30px;
                    margin-top: 10px;
                }
                a {
                    padding: 10px 20px;
                    background-color: #E36220; 
                    color: #000;
                    border-radius: 50px;
                    text-decoration: none;
                    font-weight: 700;
                }
                .animation-container {
                    position: absolute;
                    top: 20%;
                    left: 50%;
                    transform: translateX(-50%); 
                    width: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .bird {
                    font-size: 50px;
                    color: #E36220;
                    animation: fly 6s linear forwards;
                }
                @keyframes fly {
                    0% {
                        transform: translateX(-100%);
                    }
                    100% {
                        transform: translateX(100%);
                    }
                }
            </style>
        </head>
        <body>
            <div>
                <h2>Your Request has been submitted</h2>
                <p>We'll review it within 2 working days</p>
                <a href='https://mostreams.com/'>HOMEPAGE</a>
            </div>
            <div class='animation-container'>
                <div class='bird'>
                    <i class='fas fa-dove'></i> <!-- Bird icon -->
                </div>
            </div>
        </body>
        </html>
        ";
    } else {
        echo "Error in sending email.";
    }
}
?>