<?php
// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Validate required fields
    $first_name = isset($_POST["First_Name"]) ? htmlspecialchars($_POST["First_Name"]) : "";
    $last_name = isset($_POST["Last_Name"]) ? htmlspecialchars($_POST["Last_Name"]) : "";
    $email = isset($_POST["Contact_Email"]) ? htmlspecialchars($_POST["Contact_Email"]) : "";
    $reason = isset($_POST["Reason_for_Contacting"]) ? htmlspecialchars($_POST["Reason_for_Contacting"]) : "";
    $message = isset($_POST["Message"]) ? htmlspecialchars($_POST["Message"]) : "";

    // Check if required fields are empty
    if (empty($first_name) || empty($last_name) || empty($email) || empty($reason) || empty($message)) {
        die("Error: All required fields must be filled.");
    }

    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Error: Invalid email format.");
    }

    // Set recipient email
    $to = "support@mostreams.com"; // Change to your webmail address

    // Email subject
    $subject = "New Contact Form Submission - " . $reason;

    // Email message
    $body = "First Name: $first_name\n";
    $body .= "Last Name: $last_name\n";
    $body .= "Email: $email\n";
    $body .= "Reason for Contacting: $reason\n\n";
    $body .= "Message:\n$message\n";

    // Headers
    $headers = "From: noreply@mostreams.com\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Send the email
    $sent = mail($to, $subject, $body, $headers);

    if (mail($to, $subject, $message, $headers)) {
        // Successful submission message with styling and animation
        echo "
        <html>
        <head>
            <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css' rel='stylesheet'>
            <style>
                body, html {
                    background-color: #030303;
                    color: #E36220;
                    height: 100%;
                    margin: 0;
                    font-family: Arial, sans-serif;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    text-align: center;
                    position: relative;
                    overflow: hidden;
                }
                h2 {
                    margin: 0;
                }
                p {
                    margin-bottom: 30px;
                    margin-top: 10px;
                }
                a {
                    padding: 10px 20px;
                    background-color: #E36220; 
                    color: #000;
                    border-radius: 50px;
                    text-decoration: none;
                    font-weight: 700;
                }
                .animation-container {
                    position: absolute;
                    top: 20%;
                    left: 50%;
                    transform: translateX(-50%); 
                    width: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .bird {
                    font-size: 50px;
                    color: #E36220;
                    animation: fly 6s linear forwards;
                }
                @keyframes fly {
                    0% {
                        transform: translateX(-100%);
                    }
                    100% {
                        transform: translateX(100%);
                    }
                }
            </style>
        </head>
        <body>
            <div>
                <h2>Your Request has been submitted</h2>
                <p>We'll review it within 2 working days</p>
                <a href='https://mostreams.com/'>HOMEPAGE</a>
            </div>
            <div class='animation-container'>
                <div class='bird'>
                    <i class='fas fa-dove'></i> <!-- Bird icon -->
                </div>
            </div>
        </body>
        </html>
        ";
    } else {
        echo "Error in sending email.";
    }
}
?>