<?php
// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Validate required fields
    $first_name = isset($_POST["first_name"]) ? htmlspecialchars($_POST["first_name"]) : "";
    $last_name = isset($_POST["last_name"]) ? htmlspecialchars($_POST["last_name"]) : "";
    $email = isset($_POST["email"]) ? htmlspecialchars($_POST["email"]) : "";
    $contact = isset($_POST["contact"]) ? htmlspecialchars($_POST["contact"]) : "";
    $stage_name = isset($_POST["stage_name"]) ? htmlspecialchars($_POST["stage_name"]) : "";
    $bmi_publisher_ipi_1 = isset($_POST["bmi_publisher_ipi_1"]) ? htmlspecialchars($_POST["bmi_publisher_ipi_1"]) : "";
    $bmi_percentage_1 = isset($_POST["bmi_percentage_1"]) ? htmlspecialchars($_POST["bmi_percentage_1"]) : "";
    $bmi_publisher_ipi_2 = isset($_POST["bmi_publisher_ipi_2"]) ? htmlspecialchars($_POST["bmi_publisher_ipi_2"]) : "";
    $bmi_percentage_2 = isset($_POST["bmi_percentage_2"]) ? htmlspecialchars($_POST["bmi_percentage_2"]) : "";
    $bmi_publisher_ipi_3 = isset($_POST["bmi_publisher_ipi_3"]) ? htmlspecialchars($_POST["bmi_publisher_ipi_3"]) : "";
    $bmi_percentage_3 = isset($_POST["bmi_percentage_3"]) ? htmlspecialchars($_POST["bmi_percentage_3"]) : "";
    $ascap_publisher_ipi_1 = isset($_POST["ascap_publisher_ipi_1"]) ? htmlspecialchars($_POST["ascap_publisher_ipi_1"]) : "";
    $ascap_percentage_1 = isset($_POST["ascap_percentage_1"]) ? htmlspecialchars($_POST["ascap_percentage_1"]) : "";
    $ascap_publisher_ipi_2 = isset($_POST["ascap_publisher_ipi_2"]) ? htmlspecialchars($_POST["ascap_publisher_ipi_2"]) : "";
    $ascap_percentage_2 = isset($_POST["ascap_percentage_2"]) ? htmlspecialchars($_POST["ascap_percentage_2"]) : "";
    $ascap_publisher_ipi_3 = isset($_POST["ascap_publisher_ipi_3"]) ? htmlspecialchars($_POST["ascap_publisher_ipi_3"]) : "";
    $ascap_percentage_3 = isset($_POST["ascap_percentage_3"]) ? htmlspecialchars($_POST["ascap_percentage_3"]) : "";
    $message = isset($_POST["message"]) ? htmlspecialchars($_POST["message"]) : "";

    // Check if required fields are empty
    if (empty($first_name) || empty($last_name) || empty($email) || empty($contact) || empty($stage_name) || empty($message)) {
        die("Error: All required fields must be filled.");
    }

    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Error: Invalid email format.");
    }

    // Set recipient email
    $to = "support@mostreams.com"; // Change to your webmail address

    // Email subject
    $subject = "New Contact Form Submission - " . $email;

    // Email message
    $body = "First Name: $first_name\n";
    $body .= "Last name: $last_name\n";
    $body .= "Email: $email\n";
    $body .= "Contact Number: $contact\n";
    $body .= "Stage Name: $stage_name\n";
    $body .= "BMI Publisher IPI 1: $bmi_publisher_ipi_1, Percentage 1: $bmi_percentage_1\n";
    $body .= "BMI Publisher IPI 2: $bmi_publisher_ipi_2, Percentage 2: $bmi_percentage_2\n";
    $body .= "BMI Publisher IPI 3: $bmi_publisher_ipi_3, Percentage 3: $bmi_percentage_3\n";
    $body .= "ASCAP Publisher IPI 1: $ascap_publisher_ipi_1, Percentage 1: $ascap_percentage_1\n";
    $body .= "ASCAP Publisher IPI 2: $ascap_publisher_ipi_2, Percentage 2: $ascap_percentage_2\n";
    $body .= "ASCAP Publisher IPI 3: $ascap_publisher_ipi_3, Percentage 3: $ascap_percentage_3\n";
    $body .= "Message:\n$message\n";

    // Headers
    $headers = "From: noreply@mostreams.com\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Send the email
    $sent = mail($to, $subject, $body, $headers);

    if (mail($to, $subject, $message, $headers)) {
        // Successful submission message with styling and animation
        echo "
        <html>
        <head>
            <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css' rel='stylesheet'>
            <style>
                body, html {
                    background-color: #030303;
                    color: #E36220;
                    height: 100%;
                    margin: 0;
                    font-family: Arial, sans-serif;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    text-align: center;
                    position: relative;
                    overflow: hidden;
                }
                h2 {
                    margin: 0;
                }
                p {
                    margin-bottom: 30px;
                    margin-top: 10px;
                }
                a {
                    padding: 10px 20px;
                    background-color: #E36220; 
                    color: #000;
                    border-radius: 50px;
                    text-decoration: none;
                    font-weight: 700;
                }
                .animation-container {
                    position: absolute;
                    top: 20%;
                    left: 50%;
                    transform: translateX(-50%); 
                    width: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .bird {
                    font-size: 50px;
                    color: #E36220;
                    animation: fly 6s linear forwards;
                }
                @keyframes fly {
                    0% {
                        transform: translateX(-100%);
                    }
                    100% {
                        transform: translateX(100%);
                    }
                }
            </style>
        </head>
        <body>
            <div>
                <h2>Your Request has been submitted</h2>
                <p>We'll review it within 2 working days</p>
                <a href='https://mostreams.com/'>HOMEPAGE</a>
            </div>
            <div class='animation-container'>
                <div class='bird'>
                    <i class='fas fa-dove'></i> <!-- Bird icon -->
                </div>
            </div>
        </body>
        </html>
        ";
    } else {
        echo "Error in sending email.";
    }
}
?>