<?php
// Check if form is submitted
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    
    // Validate required fields
    $company_name = isset($_POST["company_name"]) ? htmlspecialchars($_POST["company_name"]) : "";
    $shareholders_name = isset($_POST["shareholders_name"]) ? htmlspecialchars($_POST["shareholders_name"]) : "";
    $email = isset($_POST["email"]) ? htmlspecialchars($_POST["email"]) : "";
    $phone = isset($_POST["phone"]) ? htmlspecialchars($_POST["phone"]) : "";
    $street = isset($_POST["street"]) ? htmlspecialchars($_POST["street"]) : "";
    $city = isset($_POST["city"]) ? htmlspecialchars($_POST["city"]) : "";
    $state = isset($_POST["state"]) ? htmlspecialchars($_POST["state"]) : "";
    $zip = isset($_POST["zip"]) ? htmlspecialchars($_POST["zip"]) : "";
    
    // Handle checkboxes (arrays)
    $sponsorship_interests = isset($_POST["sponsorship_interests"]) ? array_map('htmlspecialchars', $_POST["sponsorship_interests"]) : [];
    $target_audience = isset($_POST["target_audience"]) ? array_map('htmlspecialchars', $_POST["target_audience"]) : [];
    $advertising_goals = isset($_POST["advertising_goals"]) ? array_map('htmlspecialchars', $_POST["advertising_goals"]) : [];
    $distribution_platform = isset($_POST["distribution_platform"]) ? array_map('htmlspecialchars', $_POST["distribution_platform"]) : [];
    
    // Handle other fields
    $additional_information = isset($_POST["additional_information"]) ? htmlspecialchars($_POST["additional_information"]) : "";
    $message = isset($_POST["message"]) ? htmlspecialchars($_POST["message"]) : "";

    // Check if required fields are empty
    if (empty($company_name) || empty($shareholders_name) || empty($email) || empty($phone) || empty($street) || empty($message)) {
        die("Error: All required fields must be filled.");
    }

    // Validate email format
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        die("Error: Invalid email format.");
    }

    // Set recipient email
    $to = "support@mostreams.com"; // Change to your webmail address

    // Email subject
    $subject = "New phone Form Submission - " . $email;

    // Email message
    $body = "Company Name: $company_name\n";
    $body .= "Shareholders name: $shareholders_name\n";
    $body .= "Email: $email\n";
    $body .= "Phone: $phone\n";
    $body .= "Street: $street\n";
    $body .= "City: $city\n";
    $body .= "State: $state\n";
    $body .= "Zip: $zip\n";
    $body .= "Partnership Options: " . implode(", ", $sponsorship_interests) . "\n";
    $body .= "Benefits and Objectives: " . implode(", ", $target_audience) . "\n";
    $body .= "Marketing and Promotion: " . implode(", ", $advertising_goals) . "\n";
    $body .= "Distribution Platform: " . implode(", ", $distribution_platform) . "\n";
    $body .= "Additional Information: $additional_information\n";
    $body .= "Message:\n$message\n";

    // Headers
    $headers = "From: noreply@mostreams.com\r\n";
    $headers .= "Reply-To: $email\r\n";
    $headers .= "Content-Type: text/plain; charset=UTF-8\r\n";

    // Send the email
    $sent = mail($to, $subject, $body, $headers);

    if ($sent) {
        // Successful submission message with styling and animation
        echo "
        <html>
        <head>
            <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css' rel='stylesheet'>
            <style>
                body, html {
                    background-color: #030303;
                    color: #E36220;
                    height: 100%;
                    margin: 0;
                    font-family: Arial, sans-serif;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    text-align: center;
                    position: relative;
                    overflow: hidden;
                }
                h2 {
                    margin: 0;
                }
                p {
                    margin-bottom: 30px;
                    margin-top: 10px;
                }
                a {
                    padding: 10px 20px;
                    background-color: #E36220; 
                    color: #000;
                    border-radius: 50px;
                    text-decoration: none;
                    font-weight: 700;
                }
                .animation-container {
                    position: absolute;
                    top: 20%;
                    left: 50%;
                    transform: translateX(-50%); 
                    width: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .bird {
                    font-size: 50px;
                    color: #E36220;
                    animation: fly 6s linear forwards;
                }
                @keyframes fly {
                    0% {
                        transform: translateX(-100%);
                    }
                    100% {
                        transform: translateX(100%);
                    }
                }
            </style>
        </head>
        <body>
            <div>
                <h2>Your Request has been submitted</h2>
                <p>We'll review it within 2 working days</p>
                <a href='https://mostreams.com/'>HOMEPAGE</a>
            </div>
            <div class='animation-container'>
                <div class='bird'>
                    <i class='fas fa-dove'></i> <!-- Bird icon -->
                </div>
            </div>
        </body>
        </html>
        ";
    } else {
        echo "Error in sending email.";
    }
}
?>
