import { SequentialAuthTokenRequestExecuter } from './token-request';
import { AblyChannel } from '../ably-channel';
import { AblyConnector } from '../../connector/ably-connector';
import { AuthOptions, ChannelStateChange, ClientOptions } from '../../../typings/ably';
export declare class AblyAuth {
    authEndpoint: string;
    authHeaders: any;
    authRequestExecuter: SequentialAuthTokenRequestExecuter;
    expiredAuthChannels: Set<string>;
    setExpired: (channelName: string) => Set<string>;
    isExpired: (channelName: string) => boolean;
    removeExpired: (channelName: string) => boolean;
    options: AuthOptions & Pick<ClientOptions, 'echoMessages'>;
    requestToken: (channelName: string, existingToken: string) => Promise<any>;
    constructor(options: any);
    enableAuthorizeBeforeChannelAttach: (ablyConnector: AblyConnector) => void;
    onChannelFailed: (echoAblyChannel: AblyChannel) => (stateChange: ChannelStateChange) => void;
    handleChannelAuthError: (echoAblyChannel: AblyChannel) => void;
    setPresenceInfo: (echoAblyChannel: AblyChannel, info: any) => void;
}
