import { Component } from "react";
import { CookieConsentProps } from "./CookieConsent.props";
import { CookieConsentState } from "./CookieConsent.state";
export declare class CookieConsent extends Component<CookieConsentProps, CookieConsentState> {
    static defaultProps: CookieConsentProps;
    state: CookieConsentState;
    componentDidMount(): void;
    componentWillUnmount(): void;
    /**
     * Set a persistent accept cookie
     */
    accept(acceptedByScrolling?: boolean): void;
    /**
     * Handle a click on the overlay
     */
    overlayClick(): void;
    /**
     * Set a persistent decline cookie
     */
    decline(): void;
    /**
     * Function to set the consent cookie based on the provided variables
     * Sets two cookies to handle incompatible browsers, more details:
     * https://web.dev/samesite-cookie-recipes/#handling-incompatible-clients
     */
    setCookie(cookieName: string, cookieValue: string | object): void;
    /**
     * Returns the value of the consent cookie
     * Retrieves the regular value first and if not found the legacy one according
     * to: https://web.dev/samesite-cookie-recipes/#handling-incompatible-clients
     */
    getCookieValue(): string | undefined;
    /**
     * checks whether scroll has exceeded set amount and fire accept if so.
     */
    handleScroll: () => void;
    removeScrollListener: () => void;
    render(): JSX.Element | null;
}
export default CookieConsent;
