import { AiOutlineMenuUnfold } from "react-icons/ai";
import { RiLoginBoxLine } from "react-icons/ri";
import { BiUserPlus, BiSearchAlt } from "react-icons/bi";
import {
    MdDarkMode,
    MdGeneratingTokens,
    MdOutlineVideoLibrary,
} from "react-icons/md";
import { BsFillSunFill, BsSlashSquare } from "react-icons/bs";
import { BiUserCircle } from "react-icons/bi";
import { Link } from "@inertiajs/inertia-react";
import __ from "@/Functions/Translate";
import { usePage } from "@inertiajs/inertia-react";
import { useState, useEffect } from "react";
import Dropdown from "@/Components/Dropdown";
import Modal from "@/Components/Modal";
import { toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import debounce from "lodash.debounce";
import axios from "axios";
import TextInput from "./TextInput";
import { FaChromecast, FaPhotoVideo } from "react-icons/fa";
import { RxCaretDown } from "react-icons/rx";

export default function TopNavi({ children }) {
    const { logo, logo_day, auth, pages } = usePage().props;

    const [isDarkMode, setIsDarkMode] = useState("Yes");
    const [showSearch, setShowSearch] = useState(false);

    const [results, setResults] = useState([]);

    const { flash } = usePage().props;

    useEffect(() => {
        if (flash?.message) {
            toast(flash.message);
        }
    }, [flash]);

    useEffect(() => {
        // Check if user has stored preference
        const storedMode = localStorage.getItem("is-dark-mode");
    
        if (storedMode) {
            setIsDarkMode(storedMode);
        } else {
            // Default dark mode when no preference saved
            document.body.classList.add("dark");
            document.body.classList.add("bg-black");
            document.body.classList.remove("bg-slate-50");
            setIsDarkMode("yes");
            localStorage.setItem("is-dark-mode", "yes");
        }
    }, []);    

    useEffect(() => {
        if (isDarkMode === "yes") {
            document.body.classList.add("dark");
            document.body.classList.add("bg-black");
            document.body.classList.remove("bg-slate-50");
        } else {
            document.body.classList.remove("dark");
            document.body.classList.remove("bg-black");
            document.body.classList.add("bg-slate-50");
        }
    }, [isDarkMode]);    

    const switchDarkMode = () => {
        if (isDarkMode == "no") {
            document.body.classList.add("dark");
            localStorage.setItem("is-dark-mode", "yes");
            setIsDarkMode("yes");
        } else {
            document.body.classList.remove("dark");
            document.body.classList.remove("bg-black");
            localStorage.setItem("is-dark-mode", "no");
            setIsDarkMode("no");
        }
    };

    const updateTerm = debounce((e) => {
        console.log(`debounced term updated to: ${e.target.value}`);

        if (e.target.value.length > 2) {
            axios
                .get(route("channel.search"), {
                    params: { term: e.target.value },
                })
                .then((resp) => setResults(resp.data))
                .catch((Error) => toast(Error.response?.data?.message));
        } else {
            setResults([]);
        }
    }, 500);

    return (
        <div className="bg-violet-800 border-b-2 border-violet-800 dark:bg-zinc-900 dark:border-b-2 dark:border-zinc-800 fixed inset-x-0 z-10">
            <Modal
                show={showSearch}
                closeable={true}
                onClose={(e) => setShowSearch(false)}
            >
                <div className="p-3">
                    <TextInput
                        className={"w-full mb-5"}
                        handleChange={(e) => updateTerm(e)}
                        type="text"
                        placeholder={__("Search Channels")}
                        isFocused={true}
                    />
                    {results.length === 0 && (
                        <div className="dark:text-orange-400">
                            {__("No results")}
                        </div>
                    )}

                    {results.map((sr) => {
                        return (
                            <div
                                key={`sr-${sr.id}`}
                                className="flex items-center mt-2 space-x-2"
                            >
                                <div>
                                    <Link
                                        href={route("channel", {
                                            user: sr.username,
                                        })}
                                    >
                                        <img
                                            src={sr.profile_picture}
                                            alt=""
                                            className="border border-gray-950 h-14 rounded-full dark:border-indigo-200"
                                        />
                                    </Link>
                                </div>
                                <div className="grow">
                                    <Link
                                        className="text-gray-600 block dark:text-gray-300 font-semibold ml-1 mt-1"
                                        href={route("channel", {
                                            user: sr.username,
                                        })}
                                    >
                                        {sr.name}
                                    </Link>
                                    <Link
                                        className="text-sky-500 block font-semibold hover:text-sky-600 ml-1 mt-1"
                                        href={route("channel", {
                                            user: sr.username,
                                        })}
                                    >
                                        @{sr.username}
                                    </Link>
                                </div>
                            </div>
                        );
                    })}
                </div>
            </Modal>

            <div className="flex justify-between items-center max-w-7xl mx-auto px-2 py-4" style={{ height: "100px" }}>

                <div className="flex items-center">
                    <Link href={route("home")}>
                        <img src={logo} alt="logo" className="mr-1 mt-1" style={{ height: "4rem" }} />
                    </Link>
                </div>

                <div className="flex items-center">
                    <Link
                        href={route("home")}
                        className="text-lg text-orange-400 font-semibold hidden hover:text-orange-700 items-center md:inline-flex"
                    >
                        <BsSlashSquare className="mr-1" />
                        {__("Home")}
                    </Link>
                    <Link
                        href={route("channels.browse")}
                        className="text-lg text-orange-400 font-semibold hidden hover:text-orange-700 items-center md:inline-flex ml-5"
                    >
                        <span>
                            <FaChromecast className="mr-1" />
                        </span>
                        <span>{__("Channels")}</span>
                    </Link>
                    <Link
                        href={route("videos.browse")}
                        className="text-lg text-orange-400 font-semibold hidden hover:text-orange-700 items-center md:inline-flex ml-5"
                    >
                        <span>
                            <MdOutlineVideoLibrary className="mr-1" />
                        </span>
                        <span>{__("Videos")}</span>
                    </Link>
                    <Link
                        href={route("galleries.browse")}
                        className="text-lg text-orange-400 font-semibold hidden hover:text-orange-700 items-center md:inline-flex ml-5"
                    >
                        <span>
                            <FaPhotoVideo className="mr-1" />
                        </span>
                        <span>{__("Galleries")}</span>
                    </Link>
                    <Link
                        href={route("token.packages")}
                        className="text-lg text-orange-400 font-semibold hidden hover:text-orange-700 items-center md:inline-flex ml-5"
                    >
                        <span>
                            <MdGeneratingTokens className="h-6 w-6 mr-1" />
                        </span>
                        <span>{__("Token Packs")}</span>
                    </Link>

                    {!auth.user ? (
                        <>
                            <Link
                                className="border border-orange-400 p-1 rounded-lg text-orange-400 font-semibold hidden hover:border-orange-700 hover:text-orange-700 md:block ml-4 px-4"
                                href={route("login")}
                            >
                                {__("Login")}
                            </Link>
                            <Link
                                href={route("signup")}
                                className="bg-orange-400 border-orange-400 p-1.5 rounded-lg text-gray-950 font-semibold hidden hover:bg-orange-700 md:block ml-2 px-4"
                            >
                                {__("Signup")}
                            </Link>
                            <Link href={route("login")} className="md:hidden">
                                <RiLoginBoxLine className="h-6 text-orange-400 w-6 cursor-pointer hover:bg-indigo-900 hover:rounded hover:text-orange-400 md:hidden mr-1" />
                            </Link>
                            <Link href={route("signup")}>
                                <BiUserPlus className="h-6 text-orange-400 w-6 cursor-pointer hover:bg-orange-700 hover:rounded hover:text-orange-400 md:hidden mr-1" />
                            </Link>
                        </>
                    ) : (
                        <>
                            <Dropdown>
                                <Dropdown.Trigger>
                                    <div className="inline-flex ml-2 mt-1 relative">
                                        <BiUserCircle className="h-6 text-orange-400 w-6 cursor-pointer hover:text-indigo-400 mr-1" />
                                        <div className="bg-red-500 h-4 justify-center rounded-full text-orange-400 text-xs w-4 -left-1 -top-1 absolute font-bold inline-flex items-center">
                                            {auth.unreadNotifications}
                                        </div>
                                        <div className="text-orange-400 cursor-pointer font-semibold hidden hover:text-indigo-400 items-center md:inline-flex pt-0.5">
                                            {__(auth.user.firstName)}
                                            <RxCaretDown />
                                        </div>
                                    </div>
                                </Dropdown.Trigger>

                                <Dropdown.Content>
                                    <Dropdown.Link
                                        href={`${auth.user.is_streamer === "yes"
                                            ? route("payout.withdraw")
                                            : route("profile.myTokens")
                                            }`}
                                    >
                                        <span className="flex bg-green-100 justify-center rounded-lg text-green-700 text-xs font-bold items-center py-1">
                                            <MdGeneratingTokens className="h-5 w-5" />
                                            {auth.user.tokens}
                                        </span>
                                    </Dropdown.Link>
                                    {auth.user.is_streamer === "yes" && (
                                        <Dropdown.Link
                                            href={route("channel", {
                                                user: auth.user.username,
                                            })}
                                        >
                                            {__("My Channel")}
                                        </Dropdown.Link>
                                    )}
                                    {auth.user.is_streamer === "yes" && (
                                        <Dropdown.Link
                                            href={route("channel.settings")}
                                        >
                                            {__("Channel Settings")}
                                        </Dropdown.Link>
                                    )}

                                    <Dropdown.Link
                                        href={route("notifications.inbox")}
                                    >
                                        {__("Notifications")}
                                        <span className="bg-red-100 rounded-full text-red-500 text-xs dark:bg-red-500 dark:text-red-100 font-medium ml-2 px-1.5 py-0.5">
                                            {__(
                                                ":unreadNotificationsCount new",
                                                {
                                                    unreadNotificationsCount:
                                                        auth.unreadNotifications,
                                                }
                                            )}
                                        </span>
                                    </Dropdown.Link>
                                    {auth.user.is_streamer === "yes" && (
                                        <Dropdown.Link
                                            href={route("payout.withdraw")}
                                        >
                                            {__("Withdraw")}
                                        </Dropdown.Link>
                                    )}

                                    {auth.user.is_streamer === "yes" && (
                                        <Dropdown.Link
                                            href={route("membership.set-tiers")}
                                        >
                                            {__("Membership Tiers")}
                                        </Dropdown.Link>
                                    )}

                                    {auth.user.is_streamer === "yes" && (
                                        <Dropdown.Link
                                            href={route("videos.list")}
                                        >
                                            {__("Upload Videos")}
                                        </Dropdown.Link>
                                    )}

                                    <Dropdown.Link
                                        href={route("videos.ordered")}
                                    >
                                        {__("My Videos")}
                                    </Dropdown.Link>


                                    {auth.user.is_streamer === "yes" && (
                                        <Dropdown.Link href={route("gallery.manager")}>
                                            {__("Gallery Manager")}
                                        </Dropdown.Link>
                                    )}

                                    <Dropdown.Link href={route("gallery.ordered")}>
                                        {__("My Galleries")}
                                    </Dropdown.Link>

                                    {auth.user.is_streamer === "yes" && (
                                        <Dropdown.Link
                                            href={route("channel.followers", {
                                                user: auth.user.username,
                                            })}
                                        >
                                            {__("My Followers")}
                                        </Dropdown.Link>
                                    )}

                                    {auth.user.is_streamer === "yes" && (
                                        <Dropdown.Link
                                            href={route("mySubscribers")}
                                        >
                                            {__("My Subscribers")}
                                        </Dropdown.Link>
                                    )}

                                    <Dropdown.Link
                                        href={route("profile.followings")}
                                    >
                                        {__("My Followings")}
                                    </Dropdown.Link>
                                    <Dropdown.Link
                                        href={route("mySubscriptions")}
                                    >
                                        {__("My Subscriptions")}
                                    </Dropdown.Link>

                                    <Dropdown.Link href={route("profile.edit")}>
                                        {__("My Account")}
                                    </Dropdown.Link>

                                    <Dropdown.Link
                                        href={route("logout")}
                                        method="post"
                                        as="button"
                                    >
                                        {__("Logout")}
                                    </Dropdown.Link>
                                </Dropdown.Content>
                            </Dropdown>
                        </>
                    )}

                    <Dropdown>
                        <Dropdown.Trigger>
                            <AiOutlineMenuUnfold
                                className={`ml-2 w-6 h-6 text-orange-400 cursor-pointer hover:text-orange-700 md:hidden`}
                            />
                        </Dropdown.Trigger>
                        <Dropdown.Content>
                            <div className="flex text-gray-500 dark:text-orange-400 font-bold pl-4 pt-2">
                                {__("Menu")}
                            </div>
                            <Dropdown.Link href={route("home")}>
                                {__("Home")}
                            </Dropdown.Link>
                            <Dropdown.Link href={route("token.packages")}>
                                <div className="flex justify-between items-center">
                                    <div>{__("Get Tokens")}</div>
                                    <div>
                                        <MdGeneratingTokens className="h-6 w-6" />
                                    </div>
                                </div>
                            </Dropdown.Link>

                            <Dropdown.Link href={route("videos.browse")}>
                                {__("Browse Videos")}
                            </Dropdown.Link>
                            <Dropdown.Link href={route("channels.browse")}>
                                {__("Discover Channels")}
                            </Dropdown.Link>
                            <Dropdown.Link href={route("galleries.browse")}>
                                {__("Browse Galleries")}
                            </Dropdown.Link>
                            <div className="flex text-gray-500 dark:text-orange-400 font-bold pl-4 pt-2">
                                {__("General")}
                            </div>
                            <Dropdown.Link href={route("contact.form")}>
                                {__("Get In Touch")}
                            </Dropdown.Link>

                            {pages.map((p) => (
                                <Dropdown.Link
                                    key={`page-${p.id}`}
                                    href={route("page", { page: p.page_slug })}
                                >
                                    {p.page_title}
                                </Dropdown.Link>
                            ))}
                        </Dropdown.Content>
                    </Dropdown>
                </div>
            </div>
        </div>
    );
}
