import React, { useEffect } from "react";
import GuestLayout from "@/Layouts/GuestLayout";
import InputError from "@/Components/InputError";
import InputLabel from "@/Components/InputLabel";
import PrimaryButton from "@/Components/PrimaryButton";
import TextInput from "@/Components/TextInput";
import { Link, useForm } from "@inertiajs/inertia-react";
import __ from "@/Functions/Translate";
import Front from "@/Layouts/Front";

export default function Login({ status, canResetPassword, loginIcon }) {
    const { data, setData, post, processing, errors, reset } = useForm({
        email: "",
        password: "",
        remember: "",
    });

    useEffect(() => {
        return () => {
            reset("password");
        };
    }, []);

    const onHandleChange = (event) => {
        setData(
            event.target.name,
            event.target.type === "checkbox"
                ? event.target.checked
                : event.target.value
        );
    };

    const submit = (e) => {
        e.preventDefault();

        post(route("login"));
    };

    return (
        <Front>
            <div className="bg-white p-5 rounded-lg shadow dark:bg-zinc-900 max-w-5xl md:p-10 mx-auto">
                <div className="flex flex-col items-center md:flex-row md:space-x-10">
                    <div className="w-full">
                        <img
                            src={loginIcon}
                            alt="user signup"
                            className="border-4 border-zinc-200 rounded-full dark:border-indigo-200 max-h-96 mx-auto"
                        />
                    </div>

                    <div className="flex-grow w-full pt-10">
                        <h2 className="text-3xl text-center text-gray-600 dark:text-zinc-200 font-semibold">
                            {__("Login to your account")}
                        </h2>
                        <p className="text-center text-gray-600 text-sm dark:text-white mb-5 mt-1">
                            {__("Don't have an account?")}{" "}
                            <Link
                                className="text-orange-400 dark:text-orange-700 hover:underline"
                                href={route("signup")}
                            >
                                {__("Signup")}
                            </Link>
                        </p>
                        {status && (
                            <div className="text-green-600 text-sm font-medium mb-4">
                                {status}
                            </div>
                        )}

                        <form onSubmit={submit}>
                            <div>
                                <InputLabel forInput="email" value="Email" />

                                <TextInput
                                    type="email"
                                    name="email"
                                    value={data.email}
                                    className="w-full block mt-1"
                                    autoComplete="username"
                                    isFocused={false}
                                    handleChange={onHandleChange}
                                />

                                <InputError
                                    message={errors.email}
                                    className="mt-2"
                                />
                            </div>

                            <div className="mt-4">
                                <InputLabel
                                    forInput="password"
                                    value="Password"
                                />

                                <TextInput
                                    type="password"
                                    name="password"
                                    value={data.password}
                                    className="w-full block mt-1"
                                    autoComplete="current-password"
                                    handleChange={onHandleChange}
                                />

                                <InputError
                                    message={errors.password}
                                    className="mt-2"
                                />
                            </div>

                            <div className="flex justify-end items-center mt-4">
                                {canResetPassword && (
                                    <Link
                                        href={route("password.request")}
                                        className="rounded-md text-gray-600 text-sm dark:focus:ring-offset-gray-800 dark:hover:text-gray-100 dark:text-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:ring-offset-2 hover:text-gray-900 underline"
                                    >
                                        {__("Forgot your password?")}
                                    </Link>
                                )}

                                <PrimaryButton
                                    className="border border-orange-400 p-1 rounded-lg text-orange-400 font-semibold hidden hover:border-orange-700 hover:text-orange-700 md:block ml-4 px-4"
                                    processing={processing}
                                >
                                    {__("Log in")}
                                </PrimaryButton>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </Front>
    );
}
