import { Head, usePage, Link } from "@inertiajs/inertia-react";
import Front from "@/Layouts/Front";
import __ from "@/Functions/Translate";
import { MdOutlinePeople, MdVideoLibrary } from "react-icons/md";
import ChannelsLoop from "@/Components/ChannelsLoop";
import { RiLiveLine } from "react-icons/ri";
import VideosLoop from "./Videos/Partials/VideosLoop";
import { useEffect } from "react";
import { Inertia } from "@inertiajs/inertia";
import { BiUserPlus } from "react-icons/bi";
import GalleryLoop from "./Channel/Partials/GalleryLoop";
import { FaPhotoVideo } from "react-icons/fa";

export default function Homepage({
    channels,
    livenow,
    galleries,
    videos,
    meta_title,
    meta_keys,
    meta_description,
    hide_live_channels,
}) {
    const { flash } = usePage().props;

    const influencerIcon = "/images/streamer-icon.png";
    const userIcon = "/images/user-signup-icon.png";

    useEffect(() => {
        // listen for live streaming events
        window.Echo.channel("LiveStreamRefresh").listen(
            ".livestreams.refresh",
            (data) => {
                console.log(`refresh livestreams`);
                Inertia.reload();
            }
        );
    }, []);

    return (
        <Front containerClass="w-full" headerShow={true}>
            <Head>
                <title>{meta_title}</title>
                <meta name="description" content={meta_description} />
                <meta name="keywords" content={meta_keys} />
            </Head>

            {livenow.length > 0 && (
                <div className="mb-20">
                    <div
                        className={`flex justify-center items-center mt-20 mb-8`}
                    >
                        <RiLiveLine className="text-4xl text-orange-400 mr-1" />
                        <h2 className="text-4xl text-center text-indigo-900 dark:text-zinc-200 font-bold">
                            {__("Live Channels")}
                        </h2>
                    </div>

                    <ChannelsLoop channels={livenow} />
                </div>
            )}

            <div className={`flex justify-center items-center mt-10 mb-8`}>
                <MdOutlinePeople className="text-4xl text-orange-400 mr-1" />
                <h2 className="text-4xl text-center text-indigo-900 dark:text-zinc-200 font-semibold">
                    {__("Discover Channels")}
                </h2>
            </div>

            {channels.length < 1 && (
                <div className="text-center text-gray-700 text-xl dark:text-white font-medium">
                    {__("No channels to show")}
                </div>
            )}
            <ChannelsLoop channels={channels} />

            {channels.length > 0 && (
                <div className="text-center mt-10 mx-auto">
                    <Link
                        href={route("channels.browse")}
                        className="bg-violet-700 rounded-lg text-lg text-white dark:bg-zinc-800 dark:hover:bg-zinc-900 font-semibold hover:bg-violet-500 px-8 py-2.5"
                    >
                        {__("View All Channels")}
                    </Link>
                </div>
            )}

            <div className={`flex justify-center items-center mt-20 mb-8`}>
                <MdVideoLibrary className="text-4xl text-orange-400 mr-1" />
                <h2 className="text-4xl text-center text-indigo-900 dark:text-zinc-200 font-semibold">
                    {__("Latest Videos")}
                </h2>
            </div>

            <div className="mb-8">
                {videos.length < 1 && (
                    <div className="text-center text-gray-700 text-xl dark:text-white font-medium">
                        {__("No videos to show")}
                    </div>
                )}
                <VideosLoop videos={videos} />
            </div>

            {videos.length > 0 && (
                <div className="text-center mt-10 mx-auto">
                    <Link
                        href={route("videos.browse")}
                        className="bg-violet-700 rounded-lg text-lg text-white dark:bg-zinc-800 dark:hover:bg-zinc-900 font-semibold hover:bg-violet-500 px-8 py-2.5"
                    >
                        {__("View All Videos")}
                    </Link>
                </div>
            )}


            <div className={`flex justify-center items-center mt-20 mb-8`}>
                <FaPhotoVideo className="text-4xl text-orange-400 mr-1" />
                <h2 className="text-4xl text-center text-indigo-900 dark:text-zinc-200 font-semibold">
                    {__("Latest Galleries")}
                </h2>
            </div>
            <div className="mb-8">
                {galleries.length < 1 && (
                    <div className="text-center text-gray-700 text-xl dark:text-white font-medium">
                        {__("No galleries to show")}
                    </div>
                )}
                <GalleryLoop galleries={galleries} />
            </div>
            {galleries.length > 0 && (
                <div className="text-center mt-10 mx-auto">
                    <Link
                        href={route("galleries.browse")}
                        className="bg-violet-700 rounded-lg text-lg text-white dark:bg-zinc-800 dark:hover:bg-zinc-900 font-semibold hover:bg-violet-500 px-8 py-2.5"
                    >
                        {__("View All Galleries")}
                    </Link>
                </div>
            )}

            <div className="flex flex-col flex-wrap border-t dark:border-zinc-800 items-center lg:flex-row mt-20 px-5">
                <div
                    className={`flex flex-col justify-center items-center mb-8`}
                >
                    <BiUserPlus className="text-4xl text-orange-400 mr-1" />
                    <h2 className="text-4xl text-center text-indigo-900 dark:text-zinc-200 font-semibold">
                        {__("Join Our Platform")}
                    </h2>
                    <p className="text-gray-600 text-lg dark:text-white font-medium mt-2">
                        {__("We are welcoming both Streamers and Users")}
                    </p>
                    <p className="text-gray-600 text-lg dark:text-white font-medium">
                        {__(
                            "It's completely free to join both as an user or as a streamer"
                        )}
                    </p>
                    <img
                        src="/public/images/Gamers-live.jpg"
                        alt="Join our platform"
                        className="mt-4 w-full max-w-md rounded-lg shadow-lg"
                    />
                </div>

                <div className="max-w-lg mx-auto">
                    <div className="grid grid-cols-2 gap-5 mt-10">
                        <div className="col text-center">
                            <Link href={route("streamer.signup")}>
                                <img
                                    src={influencerIcon}
                                    alt=""
                                    className="border-4 border-zinc-200 rounded-full dark:border-indigo-200 max-h-96 mx-auto"
                                />
                            </Link>
                            <Link
                                href={route("streamer.signup")}
                                className="border border-orange-400 rounded text-orange-400 font-bold hover:border-orange-700 hover:text-orange-700 inline-block mb-4 mt-5 px-4 py-2"
                            >
                                {__("I'm a Streamer")}
                            </Link>
                        </div>
                        <div className="col text-center">
                            <Link href={route("register")}>
                                <img
                                    src={userIcon}
                                    alt=""
                                    className="border-4 border-zinc-200 rounded-full dark:border-indigo-200 max-h-96 mx-auto"
                                />
                            </Link>
                            <Link
                                href={route("register")}
                                className="bg-orange-400 rounded text-black font-bold hover:bg-orange-700 inline-block mb-4 mt-5 px-4 py-2"
                            >
                                {__("I am an User")}
                            </Link>
                        </div>
                    </div>
                </div>
            </div>
        </Front>
    );
}
