import React from "react";
import { Head, usePage } from "@inertiajs/inertia-react";
import __ from "@/Functions/Translate";
import { MdGeneratingTokens } from "react-icons/md";
import { Inertia } from "@inertiajs/inertia";
import Front from "@/Layouts/Front";

export default function Packages({ packs }) {
    const { currency_symbol, currency_code } = usePage().props;
    return (
        <Front
            extraHeader={true}
            extraHeaderTitle={__("Token Packages")}
            extraHeaderText={""}
            extraHeaderImage="/images/get-tokens-icon.png"
            extraImageHeight="h-12"
        >
            <Head title={__("Get Tokens")} />

            <div className="-mt-[80px] dark:bg-zinc-900 max-w-5xl py-5">
                <div className="flex flex-col items-center md:flex-row">
                    <div>
                        <img
                            src="/images/token-packages.png"
                            alt="token packs"
                            className="h-52 lg:ml-5"
                        />
                    </div>
                    <div className="ml-5 mt-5">
                        <h3 className="text-3xl text-indigo-800 dark:text-white font-bold mb-3">
                            {__("Token Packages")}
                        </h3>
                        <p className="text-gray-600 text-xl dark:text-white font-medium mb-3">
                            {__(
                                "Tokens can be used for tips and subscriptions to your favourite channels"
                            )}
                        </p>
                    </div>
                </div>

                <div className="grid grid-cols-2 gap-3 lg:grid-cols-4 md:grid-cols-3 mt-5 px-4">
                    {packs.map((pack) => (
                        <div
                            key={pack.id}
                            className="bg-slate-100 p-4 rounded-lg shadow w-full dark:bg-zinc-700 mr-5 mt-5 mx-auto"
                        >
                            <div className="flex items-center space-x-3">
                                <div>
                                    <MdGeneratingTokens className="h-6 w-6 dark:text-white" />{" "}
                                </div>
                                <div>
                                    <h5 className="text-lg dark:text-white font-bold">
                                        {__(":tokens Tokens", {
                                            tokens: pack.tokensFormatted,
                                        })}
                                    </h5>
                                </div>
                            </div>
                            <div className="text-center mt-2">
                                <h5 className="text-lg dark:text-white font-light">
                                    {currency_symbol}
                                    {pack.price} {currency_code}
                                </h5>

                                <button
                                    onClick={(e) =>
                                        Inertia.visit(
                                            route("token.selectGateway", {
                                                tokenPack: pack.id,
                                            })
                                        )
                                    }
                                    className="bg-black rounded-lg text-center text-white w-full dark:bg-orange-400 dark:hover:bg-indigo-800 hover:bg-zinc-800 mt-3 py-1.5"
                                >
                                    {__("Purchase")}
                                </button>
                            </div>
                        </div>
                    ))}
                </div>
            </div>
        </Front>
    );
}
