<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Collect form data
    $username = htmlspecialchars($_POST['username'] ?? '');
    $email = htmlspecialchars($_POST['email'] ?? '');
    $name = htmlspecialchars($_POST['name'] ?? '');
    $stage_name = htmlspecialchars($_POST['stage_name'] ?? '');
    $publisher_performing_organization = htmlspecialchars($_POST['publisher_performing_organization'] ?? '');
    $publisher_ipi_cae = htmlspecialchars($_POST['publisher_ipi_cae'] ?? '');
    $writer_performing_organization = htmlspecialchars($_POST['writer_performing_organization'] ?? '');
    $writer_ipi_cae = htmlspecialchars($_POST['writer_ipi_cae'] ?? '');
    $details = htmlspecialchars($_POST['details'] ?? '');
    $category_id = htmlspecialchars($_POST['category_id'] ?? '');
    $website = htmlspecialchars($_POST['website'] ?? '');

    // Email subject and recipient
    $subject = "New Artist Submission";
    $to = "support@mostreams.com";

    // Generate a unique boundary
    $boundary = uniqid('boundary_');

    // Email headers
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "From: noreply@mostreams.com\r\n";
    $headers .= "Reply-To: noreply@mostreams.com\r\n";
    $headers .= "Content-Type: multipart/mixed; boundary=\"$boundary\"\r\n";

    // Email body
    $message = "--$boundary\r\n";
    $message .= "Content-Type: text/html; charset=UTF-8\r\n";
    $message .= "Content-Transfer-Encoding: 7bit\r\n\r\n";
    $message .= "
        <html>
        <head><title>New Artist Submission</title></head>
        <body>
            <h3>New Artist Request</h3>
            <p><strong>Username:</strong> $username</p>
            <p><strong>Email:</strong> $email</p>
            <p><strong>Name:</strong> $name</p>
            <p><strong>Stage Name:</strong> $stage_name</p>
            <p><strong>Publisher Performing Organization:</strong> $publisher_performing_organization</p>
            <p><strong>Publisher IPI CAE:</strong> $publisher_ipi_cae</p>
            <p><strong>Writer Performing Organization:</strong> $writer_performing_organization</p>
            <p><strong>Writer IPI CAE:</strong> $writer_ipi_cae</p>
            <p><strong>Details:</strong> $details</p>
            <p><strong>Category ID:</strong> $category_id</p>
            <p><strong>Website:</strong> $website</p>
        </body>
        </html>
    ";

    // Handle file attachments
    $attachments = [
        'user_photo' => $_FILES['user-photo'] ?? null,
        'user_passport' => $_FILES['user-passport'] ?? null,
        'user_w9' => $_FILES['user-w9'] ?? null,
        'user_w8BEN' => $_FILES['user-w8BEN'] ?? null
    ];

    foreach ($attachments as $file_key => $file) {
        if ($file && $file['error'] === UPLOAD_ERR_OK) {
            $file_path = $file['tmp_name'];
            $file_name = basename($file['name']);
            $file_type = mime_content_type($file_path);
            $file_content = chunk_split(base64_encode(file_get_contents($file_path)));

            $message .= "\r\n--$boundary\r\n";
            $message .= "Content-Type: $file_type; name=\"$file_name\"\r\n";
            $message .= "Content-Disposition: attachment; filename=\"$file_name\"\r\n";
            $message .= "Content-Transfer-Encoding: base64\r\n\r\n";
            $message .= $file_content;
        }
    }

    // End boundary
    $message .= "\r\n--$boundary--";

    if (mail($to, $subject, $message, $headers)) {
        // Successful submission message with styling and animation
        echo "
        <html>
        <head>
            <link href='https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css' rel='stylesheet'>
            <style>
                body, html {
                    background-color: #030303;
                    color: #E36220;
                    height: 100%;
                    margin: 0;
                    font-family: Arial, sans-serif;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    text-align: center;
                    position: relative;
                    overflow: hidden;
                }
                h2 {
                    margin: 0;
                }
                p {
                    margin-bottom: 30px;
                    margin-top: 10px;
                }
                a {
                    padding: 10px 20px;
                    background-color: #E36220; 
                    color: #000;
                    border-radius: 50px;
                    text-decoration: none;
                    font-weight: 700;
                }
                .animation-container {
                    position: absolute;
                    top: 20%;
                    left: 50%;
                    transform: translateX(-50%); 
                    width: 100%;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                }
                .bird {
                    font-size: 50px;
                    color: #E36220;
                    animation: fly 6s linear forwards;
                }
                @keyframes fly {
                    0% {
                        transform: translateX(-100%);
                    }
                    100% {
                        transform: translateX(100%);
                    }
                }
            </style>
        </head>
        <body>
            <div>
                <h2>Your Request has been submitted</h2>
                <p>We'll review it within 2 working days</p>
                <a href='https://mostreams.com/'>HOMEPAGE</a>
            </div>
            <div class='animation-container'>
                <div class='bird'>
                    <i class='fas fa-dove'></i> <!-- Bird icon -->
                </div>
            </div>
        </body>
        </html>
        ";
    } else {
        echo "Error in sending email.";
    }
}
?>
