<?php
mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

if (
  ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajax'])) ||
  ($_SERVER['REQUEST_METHOD'] === 'GET' && isset($_GET['ajax']))
) {
    @ini_set('display_errors', 0);
    @error_reporting(0);
}

runPlugin("OnVotePage");

if (IS_LOGGED === false) {
    header("Location: $site_url/404");
    exit();
}

$conn = new mysqli($sql_db_host, $sql_db_user, $sql_db_pass, $sql_db_name);
if ($conn->connect_error) {
    die("DB connection failed: " . $conn->connect_error);
}

$voter_id = $music->user->id ?? null;

// 1) AJAX: submit survey
if ($_SERVER["REQUEST_METHOD"] === "POST" 
    && isset($_POST['ajax'], $_POST['artist_id'], $_POST['q1']) 
    && $voter_id
) {
    header('Content-Type: application/json');

    $artist_id = intval($_POST['artist_id']);
    $track_name = $_POST['track_name'] ?? null;
    $track_url = $_POST['track_url'] ?? null;
    $q1 = $_POST['q1'] ?? null;
    $q2 = $_POST['q2'] ?? null;
    $q3 = $_POST['q3'] ?? null;
    $q4 = $_POST['q4'] ?? null;
    $q5 = $_POST['q5'] ?? null;
    $q6 = $_POST['q6'] ?? null;
    $q7 = $_POST['q7'] ?? null;
    $q8 = $_POST['q8'] ?? null;
    $q9 = $_POST['q9'] ?? null;
    $q10 = $_POST['q10'] ?? null;
    $q11 = $_POST['q11'] ?? null;
    $q12 = $_POST['q12'] ?? null;

    // Check if user already submitted survey for this artist within the last month
    $check = $conn->prepare("
        SELECT 1 FROM artists_survey 
        WHERE voter_id = ? AND artist_id = ? AND created_at >= DATE_SUB(NOW(), INTERVAL 1 MONTH)
    ");
    $check->bind_param("ii", $voter_id, $artist_id);
    $check->execute();
    $check->store_result();
    if ($check->num_rows > 0) {
        echo json_encode([
            'success' => false,
            'message' => 'You have already submitted feedback for this artist within the last month.'
        ]);
        exit();
    }

    try {
        $stmt = $conn->prepare("
          INSERT INTO artists_survey (
            voter_id, artist_id, track_name, track_url,
            q1, q2, q3, q4, q5, q6, q7, q8, q9, q10, q11, q12
          ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        
        $q1_int = intval($q1);
        $stmt->bind_param(
          "iissssssssssssss",
          $voter_id, $artist_id,
          $track_name, $track_url,
          $q1_int,
          $q2, $q3, $q4, $q5, $q6,
          $q7, $q8, $q9, $q10,
          $q11, $q12
        );

        $stmt->execute();

        $cnt = $conn->prepare("SELECT COUNT(*) FROM artists_survey WHERE artist_id = ?");
        $cnt->bind_param("i", $artist_id);
        $cnt->execute();
        $cnt->bind_result($total);
        $cnt->fetch();

        echo json_encode([
          'success' => true,
          'message' => 'Feedback submitted.',
          'votes'   => $total
        ]);
        exit();
    } catch (Exception $e) {
        echo json_encode([
            'success' => false,
            'message' => 'Submission failed: ' . $e->getMessage(),
        ]);
        exit();
    }
}

// 2) AJAX: load feedback entries
if ($_SERVER["REQUEST_METHOD"] === "GET"
    && isset($_GET['ajax'], $_GET['artist_id'])
    && $_GET['ajax'] == 'get_feedback'
) {
    header('Content-Type: application/json');
    $artist_id = intval($_GET['artist_id']);

    $q = $conn->prepare("
      SELECT track_name,track_url,q1,q2,q3,q4,q5,q6,q7,q8,q9,q10,q11,q12
      FROM artists_survey
      WHERE artist_id = ?
      ORDER BY id DESC
      LIMIT 30
    ");
    $q->bind_param("i", $artist_id);
    $q->execute();
    $q->store_result();
    $q->bind_result($track_name, $track_url, $q1, $q2, $q3, $q4, $q5, $q6, $q7, $q8, $q9, $q10, $q11, $q12);

    $feedback = [];
    while ($q->fetch()) {
      $feedback[] = [
        'track_name' => $track_name,
        'track_url' => $track_url,
        'q1' => $q1,
        'q2' => $q2,
        'q3' => $q3,
        'q4' => $q4,
        'q5' => $q5,
        'q6' => $q6,
        'q7' => $q7,
        'q8' => $q8,
        'q9' => $q9,
        'q10' => $q10,
        'q11' => $q11,
        'q12' => $q12
      ];
    }

    echo json_encode([
      'success'  => true,
      'feedback' => $feedback
    ]);
    exit();
}

// 3) Render page: fetch all artists + votes count
if (!isset($_GET['ajax']) && !isset($_POST['ajax'])) {
    $music->site_title       = lang("Feedback");
    $music->site_description = "Submit feedback for your favorite artist.";
    $music->site_pagename    = "vote";

    $sql = "
      SELECT 
        u.id,
        u.name,
        u.avatar,
        u.username,   -- add this line
        COALESCE(s.count,0) AS votes
      FROM users u
      LEFT JOIN (
        SELECT artist_id, COUNT(*) AS count
        FROM artists_survey
        GROUP BY artist_id
      ) s ON u.id = s.artist_id
      WHERE u.artist = 1
    ";
    $rs = $conn->query($sql);
    $artists = [];
    while ($row = $rs->fetch_assoc()) {
        $artists[] = $row;
    }

    // Fetch artist tracks
    $songs = [];
    $song_rs = $conn->query("
      SELECT id, title, audio_location, user_id 
      FROM songs 
      WHERE audio_location != '' AND title != ''
      ORDER BY id DESC
    ");

    while ($song = $song_rs->fetch_assoc()) {
        $artistId = $song['user_id'];
        $songs[$artistId][] = [
            'title' => $song['title'],
            'url'   => $site_url . '/' . $song['audio_location']
        ];
    }

    $music->artist_songs = $songs;

    $music->vote_message  = "";
    $music->vote_artists  = $artists;
    $music->site_content  = loadPage("vote/content");
}
