<?php
header('Content-Type: application/json');

// Fetch from RapidAPI
$curl = curl_init();
curl_setopt_array($curl, [
    CURLOPT_URL => "https://radio-world-75-000-worldwide-fm-radio-stations.p.rapidapi.com/all_radios.php?limit=1000&order=ASC&page=1&random=false",
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => "",
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 30,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => "GET",
    CURLOPT_HTTPHEADER => [
        "x-rapidapi-host: radio-world-75-000-worldwide-fm-radio-stations.p.rapidapi.com",
        "x-rapidapi-key: 249920c6d4msh4ff7967414a8bedp129ad2jsn6aa3d499a333"
    ],
]);

$response = curl_exec($curl);
$err = curl_error($curl);
curl_close($curl);

if ($err) {
    echo json_encode(['status' => 500, 'error' => "cURL Error: $err"]);
    exit();
}

$decoded = json_decode($response, true);

// Safety check
if (!is_array($decoded['stations'] ?? null)) {
    echo json_encode(['status' => 500, 'error' => 'Invalid response structure']);
    exit();
}

// Generate HTML dynamically
$html = '<div class="row">';
foreach ($decoded['stations'] as $st) {
    $radio_id   = htmlspecialchars($st['id'] ?? '');
    $title      = htmlspecialchars($st['radio_name'] ?? 'Unknown Station');
    $description= htmlspecialchars($st['country_name'] ?? '');
    $tags       = htmlspecialchars($st['genre'] ?? '');
    $audio_url  = htmlspecialchars($st['radio_url'] ?? '');
    $thumbnail  = htmlspecialchars($st['radio_image'] ?? '');

    $html .= '
      <div class="col-lg-6 col-md-6 ds_radio_stat_list" data-id="' . $radio_id . '">
        <div class="content">
          <div class="cover_art">
            <a href="' . $audio_url . '" target="_blank">
              <img src="' . $thumbnail . '" alt="' . $title . '"/>
            </a>
          </div>
          <div class="track_info">
            <h3>' . $title . '</h3>
            <p>' . $description . ' &bull; ' . $tags . '</p>
          </div>
        </div>
      </div>';
}
$html .= '</div>';

// Return response
echo json_encode([
    'status' => 200,
    'html' => $html
]);
