<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class Galleries extends Model
{
    use HasFactory;


    public $appends = ['previewPhotoUrl', 'slug', 'canBeViewed'];

    protected function getPreviewPhotoUrlAttribute()
    {
        return Storage::disk($this->disk)->url($this->preview_photo);
    }

    // slug attribute
    public function getSlugAttribute()
    {
        return Str::slug($this->gallery_name);
    }

    // has many photos
    public function photos()
    {
        return $this->hasMany(GalleryPhotos::class, 'gallery_id');
    }

    // has many sales
    public function sales()
    {
        return $this->hasMany(GallerySales::class, 'gallery_id');
    }

    // user
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getCanBeViewedAttribute()
    {
        // if gallery is free, allow anyone to view
        if ($this->price === 0) {
            return true;
        }

        // if gallery owner, allow to view his own vid
        if (auth()->id() == $this->user_id) {
            return true;
        }

        // if it's free for subscribers and current user is one of them
        if (auth()->check() && $this->free_for_subs == "yes" && auth()->user()->hasSubscriptionTo($this->user)) {
            return true;
        }

        // if there's an order for this gallery
        if (auth()->check()) {
            return $this->sales()
                ->where('gallery_id', $this->id)
                ->where('user_id', auth()->id())
                ->exists();
        }

        return false;
    }
}
