'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

function _regeneratorRuntime() {
  _regeneratorRuntime = function () {
    return exports;
  };
  var exports = {},
    Op = Object.prototype,
    hasOwn = Op.hasOwnProperty,
    $Symbol = "function" == typeof Symbol ? Symbol : {},
    iteratorSymbol = $Symbol.iterator || "@@iterator",
    asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator",
    toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag";
  function define(obj, key, value) {
    return Object.defineProperty(obj, key, {
      value: value,
      enumerable: !0,
      configurable: !0,
      writable: !0
    }), obj[key];
  }
  try {
    define({}, "");
  } catch (err) {
    define = function (obj, key, value) {
      return obj[key] = value;
    };
  }
  function wrap(innerFn, outerFn, self, tryLocsList) {
    var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator,
      generator = Object.create(protoGenerator.prototype),
      context = new Context(tryLocsList || []);
    return generator._invoke = function (innerFn, self, context) {
      var state = "suspendedStart";
      return function (method, arg) {
        if ("executing" === state) throw new Error("Generator is already running");
        if ("completed" === state) {
          if ("throw" === method) throw arg;
          return doneResult();
        }
        for (context.method = method, context.arg = arg;;) {
          var delegate = context.delegate;
          if (delegate) {
            var delegateResult = maybeInvokeDelegate(delegate, context);
            if (delegateResult) {
              if (delegateResult === ContinueSentinel) continue;
              return delegateResult;
            }
          }
          if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) {
            if ("suspendedStart" === state) throw state = "completed", context.arg;
            context.dispatchException(context.arg);
          } else "return" === context.method && context.abrupt("return", context.arg);
          state = "executing";
          var record = tryCatch(innerFn, self, context);
          if ("normal" === record.type) {
            if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue;
            return {
              value: record.arg,
              done: context.done
            };
          }
          "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg);
        }
      };
    }(innerFn, self, context), generator;
  }
  function tryCatch(fn, obj, arg) {
    try {
      return {
        type: "normal",
        arg: fn.call(obj, arg)
      };
    } catch (err) {
      return {
        type: "throw",
        arg: err
      };
    }
  }
  exports.wrap = wrap;
  var ContinueSentinel = {};
  function Generator() {}
  function GeneratorFunction() {}
  function GeneratorFunctionPrototype() {}
  var IteratorPrototype = {};
  define(IteratorPrototype, iteratorSymbol, function () {
    return this;
  });
  var getProto = Object.getPrototypeOf,
    NativeIteratorPrototype = getProto && getProto(getProto(values([])));
  NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype);
  var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype);
  function defineIteratorMethods(prototype) {
    ["next", "throw", "return"].forEach(function (method) {
      define(prototype, method, function (arg) {
        return this._invoke(method, arg);
      });
    });
  }
  function AsyncIterator(generator, PromiseImpl) {
    function invoke(method, arg, resolve, reject) {
      var record = tryCatch(generator[method], generator, arg);
      if ("throw" !== record.type) {
        var result = record.arg,
          value = result.value;
        return value && "object" == typeof value && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) {
          invoke("next", value, resolve, reject);
        }, function (err) {
          invoke("throw", err, resolve, reject);
        }) : PromiseImpl.resolve(value).then(function (unwrapped) {
          result.value = unwrapped, resolve(result);
        }, function (error) {
          return invoke("throw", error, resolve, reject);
        });
      }
      reject(record.arg);
    }
    var previousPromise;
    this._invoke = function (method, arg) {
      function callInvokeWithMethodAndArg() {
        return new PromiseImpl(function (resolve, reject) {
          invoke(method, arg, resolve, reject);
        });
      }
      return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg();
    };
  }
  function maybeInvokeDelegate(delegate, context) {
    var method = delegate.iterator[context.method];
    if (undefined === method) {
      if (context.delegate = null, "throw" === context.method) {
        if (delegate.iterator.return && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel;
        context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method");
      }
      return ContinueSentinel;
    }
    var record = tryCatch(method, delegate.iterator, context.arg);
    if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel;
    var info = record.arg;
    return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel);
  }
  function pushTryEntry(locs) {
    var entry = {
      tryLoc: locs[0]
    };
    1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry);
  }
  function resetTryEntry(entry) {
    var record = entry.completion || {};
    record.type = "normal", delete record.arg, entry.completion = record;
  }
  function Context(tryLocsList) {
    this.tryEntries = [{
      tryLoc: "root"
    }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0);
  }
  function values(iterable) {
    if (iterable) {
      var iteratorMethod = iterable[iteratorSymbol];
      if (iteratorMethod) return iteratorMethod.call(iterable);
      if ("function" == typeof iterable.next) return iterable;
      if (!isNaN(iterable.length)) {
        var i = -1,
          next = function next() {
            for (; ++i < iterable.length;) if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next;
            return next.value = undefined, next.done = !0, next;
          };
        return next.next = next;
      }
    }
    return {
      next: doneResult
    };
  }
  function doneResult() {
    return {
      value: undefined,
      done: !0
    };
  }
  return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) {
    var ctor = "function" == typeof genFun && genFun.constructor;
    return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name));
  }, exports.mark = function (genFun) {
    return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun;
  }, exports.awrap = function (arg) {
    return {
      __await: arg
    };
  }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () {
    return this;
  }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) {
    void 0 === PromiseImpl && (PromiseImpl = Promise);
    var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl);
    return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) {
      return result.done ? result.value : iter.next();
    });
  }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () {
    return this;
  }), define(Gp, "toString", function () {
    return "[object Generator]";
  }), exports.keys = function (object) {
    var keys = [];
    for (var key in object) keys.push(key);
    return keys.reverse(), function next() {
      for (; keys.length;) {
        var key = keys.pop();
        if (key in object) return next.value = key, next.done = !1, next;
      }
      return next.done = !0, next;
    };
  }, exports.values = values, Context.prototype = {
    constructor: Context,
    reset: function (skipTempReset) {
      if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined);
    },
    stop: function () {
      this.done = !0;
      var rootRecord = this.tryEntries[0].completion;
      if ("throw" === rootRecord.type) throw rootRecord.arg;
      return this.rval;
    },
    dispatchException: function (exception) {
      if (this.done) throw exception;
      var context = this;
      function handle(loc, caught) {
        return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught;
      }
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i],
          record = entry.completion;
        if ("root" === entry.tryLoc) return handle("end");
        if (entry.tryLoc <= this.prev) {
          var hasCatch = hasOwn.call(entry, "catchLoc"),
            hasFinally = hasOwn.call(entry, "finallyLoc");
          if (hasCatch && hasFinally) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          } else if (hasCatch) {
            if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0);
          } else {
            if (!hasFinally) throw new Error("try statement without catch or finally");
            if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc);
          }
        }
      }
    },
    abrupt: function (type, arg) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) {
          var finallyEntry = entry;
          break;
        }
      }
      finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null);
      var record = finallyEntry ? finallyEntry.completion : {};
      return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record);
    },
    complete: function (record, afterLoc) {
      if ("throw" === record.type) throw record.arg;
      return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel;
    },
    finish: function (finallyLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel;
      }
    },
    catch: function (tryLoc) {
      for (var i = this.tryEntries.length - 1; i >= 0; --i) {
        var entry = this.tryEntries[i];
        if (entry.tryLoc === tryLoc) {
          var record = entry.completion;
          if ("throw" === record.type) {
            var thrown = record.arg;
            resetTryEntry(entry);
          }
          return thrown;
        }
      }
      throw new Error("illegal catch attempt");
    },
    delegateYield: function (iterable, resultName, nextLoc) {
      return this.delegate = {
        iterator: values(iterable),
        resultName: resultName,
        nextLoc: nextLoc
      }, "next" === this.method && (this.arg = undefined), ContinueSentinel;
    }
  }, exports;
}
function _typeof(obj) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, _typeof(obj);
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, descriptor.key, descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _extends() {
  _extends = Object.assign ? Object.assign.bind() : function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];
      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }
    return target;
  };
  return _extends.apply(this, arguments);
}
function _inherits(subClass, superClass) {
  if (typeof superClass !== "function" && superClass !== null) {
    throw new TypeError("Super expression must either be null or a function");
  }
  subClass.prototype = Object.create(superClass && superClass.prototype, {
    constructor: {
      value: subClass,
      writable: true,
      configurable: true
    }
  });
  Object.defineProperty(subClass, "prototype", {
    writable: false
  });
  if (superClass) _setPrototypeOf(subClass, superClass);
}
function _getPrototypeOf(o) {
  _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) {
    return o.__proto__ || Object.getPrototypeOf(o);
  };
  return _getPrototypeOf(o);
}
function _setPrototypeOf(o, p) {
  _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) {
    o.__proto__ = p;
    return o;
  };
  return _setPrototypeOf(o, p);
}
function _isNativeReflectConstruct() {
  if (typeof Reflect === "undefined" || !Reflect.construct) return false;
  if (Reflect.construct.sham) return false;
  if (typeof Proxy === "function") return true;
  try {
    Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {}));
    return true;
  } catch (e) {
    return false;
  }
}
function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }
  return self;
}
function _possibleConstructorReturn(self, call) {
  if (call && (typeof call === "object" || typeof call === "function")) {
    return call;
  } else if (call !== void 0) {
    throw new TypeError("Derived constructors may only return object or undefined");
  }
  return _assertThisInitialized(self);
}
function _createSuper(Derived) {
  var hasNativeReflectConstruct = _isNativeReflectConstruct();
  return function _createSuperInternal() {
    var Super = _getPrototypeOf(Derived),
      result;
    if (hasNativeReflectConstruct) {
      var NewTarget = _getPrototypeOf(this).constructor;
      result = Reflect.construct(Super, arguments, NewTarget);
    } else {
      result = Super.apply(this, arguments);
    }
    return _possibleConstructorReturn(this, result);
  };
}
function _superPropBase(object, property) {
  while (!Object.prototype.hasOwnProperty.call(object, property)) {
    object = _getPrototypeOf(object);
    if (object === null) break;
  }
  return object;
}
function _get() {
  if (typeof Reflect !== "undefined" && Reflect.get) {
    _get = Reflect.get.bind();
  } else {
    _get = function _get(target, property, receiver) {
      var base = _superPropBase(target, property);
      if (!base) return;
      var desc = Object.getOwnPropertyDescriptor(base, property);
      if (desc.get) {
        return desc.get.call(arguments.length < 3 ? target : receiver);
      }
      return desc.value;
    };
  }
  return _get.apply(this, arguments);
}

/**
 * This class represents a basic channel.
 */
var Channel = /*#__PURE__*/function () {
  function Channel() {
    _classCallCheck(this, Channel);
  }
  _createClass(Channel, [{
    key: "listenForWhisper",
    value:
    /**
     * Listen for a whisper event on the channel instance.
     */
    function listenForWhisper(event, callback) {
      return this.listen('.client-' + event, callback);
    }
    /**
     * Listen for an event on the channel instance.
     */
  }, {
    key: "notification",
    value: function notification(callback) {
      return this.listen('.Illuminate\\Notifications\\Events\\BroadcastNotificationCreated', callback);
    }
    /**
     * Stop listening for a whisper event on the channel instance.
     */
  }, {
    key: "stopListeningForWhisper",
    value: function stopListeningForWhisper(event, callback) {
      return this.stopListening('.client-' + event, callback);
    }
  }]);
  return Channel;
}();

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

/**
 * Event name formatter
 */
var EventFormatter = /*#__PURE__*/function () {
  /**
   * Create a new class instance.
   */
  function EventFormatter(namespace) {
    _classCallCheck(this, EventFormatter);
    this.setNamespace(namespace);
  }
  /**
   * Format the given event name.
   */
  _createClass(EventFormatter, [{
    key: "format",
    value: function format(event) {
      if (event.charAt(0) === '.' || event.charAt(0) === '\\') {
        return event.substr(1);
      } else if (this.namespace) {
        event = this.namespace + '.' + event;
      }
      return event.replace(/\./g, '\\');
    }
    /**
     * Set the event namespace.
     */
  }, {
    key: "setNamespace",
    value: function setNamespace(value) {
      this.namespace = value;
    }
  }]);
  return EventFormatter;
}();

/**
 * This class represents an Ably channel.
 */
var AblyChannel = /*#__PURE__*/function (_Channel) {
  _inherits(AblyChannel, _Channel);
  var _super = _createSuper(AblyChannel);
  /**
   * Create a new class instance.
   */
  function AblyChannel(ably, name, options) {
    var _this;
    var autoSubscribe = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
    _classCallCheck(this, AblyChannel);
    _this = _super.call(this);
    _this._alertErrorListeners = function (err) {
      if (err) {
        _this.errorListeners.forEach(function (listener) {
          return listener(err);
        });
      }
    };
    _this.name = name;
    _this.ably = ably;
    _this.options = options;
    _this.eventFormatter = new EventFormatter(_this.options.namespace);
    _this.subscribedListeners = [];
    _this.errorListeners = [];
    _this.channel = ably.channels.get(name);
    _this.callbacks = new Map();
    if (autoSubscribe) {
      _this.subscribe();
    }
    return _this;
  }
  /**
   * Subscribe to an Ably channel.
   */
  _createClass(AblyChannel, [{
    key: "subscribe",
    value: function subscribe() {
      var _this2 = this;
      this.channel.on(function (stateChange) {
        var previous = stateChange.previous,
          current = stateChange.current,
          reason = stateChange.reason;
        if (previous !== 'attached' && current == 'attached') {
          _this2.subscribedListeners.forEach(function (listener) {
            return listener();
          });
        } else if (reason) {
          _this2._alertErrorListeners(stateChange);
        }
      });
      this.channel.attach(this._alertErrorListeners);
    }
    /**
     * Unsubscribe from an Ably channel, unregister all callbacks and finally detach the channel
     */
  }, {
    key: "unsubscribe",
    value: function unsubscribe() {
      this.channel.unsubscribe();
      this.callbacks.clear();
      this.unregisterError();
      this.unregisterSubscribed();
      this.channel.off();
      this.channel.detach();
    }
    /**
     * Listen for an event on the channel instance.
     */
  }, {
    key: "listen",
    value: function listen(event, callback) {
      this.callbacks.set(callback, function (_a) {
        var data = _a.data,
          metaData = __rest(_a, ["data"]);
        return callback(data, metaData);
      });
      this.channel.subscribe(this.eventFormatter.format(event), this.callbacks.get(callback));
      return this;
    }
    /**
     * Listen for all events on the channel instance.
     */
  }, {
    key: "listenToAll",
    value: function listenToAll(callback) {
      var _this3 = this;
      this.callbacks.set(callback, function (_a) {
        var name = _a.name,
          data = _a.data,
          metaData = __rest(_a, ["name", "data"]);
        var namespace = _this3.options.namespace.replace(/\./g, '\\');
        var formattedEvent = name.startsWith(namespace) ? name.substring(namespace.length + 1) : '.' + name;
        callback(formattedEvent, data, metaData);
      });
      this.channel.subscribe(this.callbacks.get(callback));
      return this;
    }
    /**
     * Stop listening for an event on the channel instance.
     */
  }, {
    key: "stopListening",
    value: function stopListening(event, callback) {
      if (callback) {
        this.channel.unsubscribe(this.eventFormatter.format(event), this.callbacks.get(callback));
        this.callbacks["delete"](callback);
      } else {
        this.channel.unsubscribe(this.eventFormatter.format(event));
      }
      return this;
    }
    /**
     * Stop listening for all events on the channel instance.
     */
  }, {
    key: "stopListeningToAll",
    value: function stopListeningToAll(callback) {
      if (callback) {
        this.channel.unsubscribe(this.callbacks.get(callback));
        this.callbacks["delete"](callback);
      } else {
        this.channel.unsubscribe();
      }
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription succeeds.
     */
  }, {
    key: "subscribed",
    value: function subscribed(callback) {
      this.subscribedListeners.push(callback);
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription error occurs.
     */
  }, {
    key: "error",
    value: function error(callback) {
      this.errorListeners.push(callback);
      return this;
    }
    /**
     * Unregisters given error callback from the listeners.
     * @param callback
     * @returns AblyChannel
     */
  }, {
    key: "unregisterSubscribed",
    value: function unregisterSubscribed(callback) {
      if (callback) {
        this.subscribedListeners = this.subscribedListeners.filter(function (s) {
          return s != callback;
        });
      } else {
        this.subscribedListeners = [];
      }
      return this;
    }
    /**
     * Unregisters given error callback from the listeners.
     * @param callback
     * @returns AblyChannel
     */
  }, {
    key: "unregisterError",
    value: function unregisterError(callback) {
      if (callback) {
        this.errorListeners = this.errorListeners.filter(function (e) {
          return e != callback;
        });
      } else {
        this.errorListeners = [];
      }
      return this;
    }
  }]);
  return AblyChannel;
}(Channel);

var AblyPrivateChannel = /*#__PURE__*/function (_AblyChannel) {
  _inherits(AblyPrivateChannel, _AblyChannel);
  var _super = _createSuper(AblyPrivateChannel);
  function AblyPrivateChannel(ably, name, options, auth) {
    var _this;
    _classCallCheck(this, AblyPrivateChannel);
    _this = _super.call(this, ably, name, options, false);
    _this.channel.on('failed', auth.onChannelFailed(_assertThisInitialized(_this)));
    _this.subscribe();
    return _this;
  }
  /**
   * Trigger client event on the channel.
   */
  _createClass(AblyPrivateChannel, [{
    key: "whisper",
    value: function whisper(eventName, data, callback) {
      if (callback) {
        this.channel.publish("client-".concat(eventName), data, callback);
      } else {
        this.channel.publish("client-".concat(eventName), data);
      }
      return this;
    }
  }]);
  return AblyPrivateChannel;
}(AblyChannel);

/**
 * This class represents an Ably presence channel.
 */
var AblyPresenceChannel = /*#__PURE__*/function (_AblyChannel) {
  _inherits(AblyPresenceChannel, _AblyChannel);
  var _super = _createSuper(AblyPresenceChannel);
  function AblyPresenceChannel(ably, name, options, auth) {
    var _this;
    _classCallCheck(this, AblyPresenceChannel);
    _this = _super.call(this, ably, name, options, false);
    _this.channel.on('failed', auth.onChannelFailed(_assertThisInitialized(_this)));
    _this.channel.on('attached', function () {
      return _this.enter(_this.presenceData, _this._alertErrorListeners);
    });
    _this.subscribe();
    return _this;
  }
  _createClass(AblyPresenceChannel, [{
    key: "unsubscribe",
    value: function unsubscribe() {
      this.leave(this.presenceData, this._alertErrorListeners);
      this.channel.presence.unsubscribe();
      _get(_getPrototypeOf(AblyPresenceChannel.prototype), "unsubscribe", this).call(this);
    }
    /**
     * Register a callback to be called anytime the member list changes.
     */
  }, {
    key: "here",
    value: function here(callback) {
      var _this2 = this;
      this.channel.presence.subscribe(['enter', 'update', 'leave'], function () {
        return _this2.channel.presence.get(function (err, members) {
          return callback(members.map(function (_ref) {
            var data = _ref.data;
            return data;
          }), err);
        });
      });
      return this;
    }
    /**
     * Listen for someone joining the channel.
     */
  }, {
    key: "joining",
    value: function joining(callback) {
      this.channel.presence.subscribe(['enter', 'update'], function (_a) {
        var data = _a.data,
          metaData = __rest(_a, ["data"]);
        callback(data, metaData);
      });
      return this;
    }
    /**
     * Listen for someone leaving the channel.
     */
  }, {
    key: "leaving",
    value: function leaving(callback) {
      this.channel.presence.subscribe('leave', function (_a) {
        var data = _a.data,
          metaData = __rest(_a, ["data"]);
        callback(data, metaData);
      });
      return this;
    }
    /**
     * Enter presence
     * @param data - Data to be published while entering the channel
     * @param callback - success/error callback (err) => {}
     * @returns AblyPresenceChannel
     */
  }, {
    key: "enter",
    value: function enter(data, callback) {
      this.channel.presence.enter(data, callback);
      return this;
    }
    /**
     * Leave presence
     * @param data - Data to be published while leaving the channel
     * @param callback - success/error callback (err) => {}
     * @returns AblyPresenceChannel
     */
  }, {
    key: "leave",
    value: function leave(data, callback) {
      this.channel.presence.leave(data, callback);
      return this;
    }
    /**
     * Update presence
     * @param data - Update presence with data
     * @param callback - success/error callback (err) => {}
     * @returns AblyPresenceChannel
     */
  }, {
    key: "update",
    value: function update(data, callback) {
      this.channel.presence.update(data, callback);
      return this;
    }
    /**
     * Trigger client event on the channel.
     */
  }, {
    key: "whisper",
    value: function whisper(eventName, data, callback) {
      if (callback) {
        this.channel.publish("client-".concat(eventName), data, callback);
      } else {
        this.channel.publish("client-".concat(eventName), data);
      }
      return this;
    }
  }]);
  return AblyPresenceChannel;
}(AblyChannel);

var isNullOrUndefined = function isNullOrUndefined(obj) {
  return obj == null || obj === undefined;
};
/**
 * @throws Exception if parsing error
 */
var parseJwt = function parseJwt(jwtToken) {
  // Get Token Header
  var base64HeaderUrl = jwtToken.split('.')[0];
  var base64Header = base64HeaderUrl.replace('-', '+').replace('_', '/');
  var header = JSON.parse(toText(base64Header));
  // Get Token payload
  var base64Url = jwtToken.split('.')[1];
  var base64 = base64Url.replace('-', '+').replace('_', '/');
  var payload = JSON.parse(toText(base64));
  return {
    header: header,
    payload: payload
  };
};
// RSA4f - omitted `capability` property
var toTokenDetails = function toTokenDetails(jwtToken) {
  var _parseJwt = parseJwt(jwtToken),
    payload = _parseJwt.payload;
  return {
    clientId: payload['x-ably-clientId'],
    expires: payload.exp * 1000,
    issued: payload.iat * 1000,
    token: jwtToken
  };
};
var isBrowser = (typeof window === "undefined" ? "undefined" : _typeof(window)) === 'object';
var toText = function toText(base64) {
  if (isBrowser) {
    return atob(base64);
  }
  return Buffer.from(base64, 'base64').toString('binary');
};
var isAbsoluteUrl = function isAbsoluteUrl(url) {
  return url && url.indexOf('http://') === 0 || url.indexOf('https://') === 0;
};
var fullUrl = function fullUrl(url) {
  var _a, _b, _c;
  if (!isAbsoluteUrl(url) && typeof window != 'undefined') {
    var host = (_a = window === null || window === void 0 ? void 0 : window.location) === null || _a === void 0 ? void 0 : _a.hostname;
    var port = (_b = window === null || window === void 0 ? void 0 : window.location) === null || _b === void 0 ? void 0 : _b.port;
    var protocol = (_c = window === null || window === void 0 ? void 0 : window.location) === null || _c === void 0 ? void 0 : _c.protocol.replace(':', '');
    if (host && port && protocol) {
      return protocol + '://' + host + ':' + port + url;
    }
  }
  return url;
};
var httpClient;
function httpRequest(options, callback) {
  if (!httpClient) {
    httpClient = new Ably.Rest.Platform.Http();
  }
  // Automatically set by browser
  if (isBrowser) {
    delete options.headers['Content-Length']; // XHR warning - Refused to set unsafe header "Content-Length"
  } else {
    options.method = options.method.toLowerCase();
  }
  httpClient.doUri(options.method, null, options.uri, options.headers, options.body, options.paramsIfNoHeaders || {}, callback);
}
var httpRequestAsync = function httpRequestAsync(options) {
  return new Promise(function (resolve, reject) {
    httpRequest(options, function (err, res) {
      if (err) {
        reject(err);
      } else {
        if (typeof res === 'string') {
          resolve(JSON.parse(res));
        } else if (!isBrowser && Buffer.isBuffer(res)) {
          try {
            resolve(JSON.parse(res.toString()));
          } catch (e) {
            resolve(res);
          }
        } else {
          resolve(res);
        }
      }
    });
  });
};

var channelAttachAuthorized = false;
/**
 * Modifies existing channel attach with custom authz implementation
 */
var beforeChannelAttach = function beforeChannelAttach(ablyClient, authorize) {
  var dummyRealtimeChannel = ablyClient.channels.get('dummy');
  if (channelAttachAuthorized) {
    return;
  }
  var internalAttach = dummyRealtimeChannel.__proto__._attach;
  if (isNullOrUndefined(internalAttach)) {
    console.warn('Failed to enable authorize for pre-attach, please check for right library version');
    return;
  }
  function customInternalAttach(forceReattach, attachReason, errCallback) {
    var _this = this;
    if (this.authorizing) {
      return;
    }
    this.authorizing = true;
    var bindedInternalAttach = internalAttach.bind(this);
    authorize(this, function (error) {
      _this.authorizing = false;
      if (error) {
        errCallback(error);
        return;
      } else {
        bindedInternalAttach(forceReattach, attachReason, errCallback);
      }
    });
  }
  dummyRealtimeChannel.__proto__._attach = customInternalAttach;
  channelAttachAuthorized = true;
};

var SequentialAuthTokenRequestExecuter = /*#__PURE__*/_createClass(function SequentialAuthTokenRequestExecuter() {
  var _this = this;
  var token = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
  var requestTokenFn = arguments.length > 1 ? arguments[1] : undefined;
  _classCallCheck(this, SequentialAuthTokenRequestExecuter);
  this.execute = function (tokenRequestFn) {
    return new Promise(function (resolve, reject) {
      _this.queue.run(function () {
        return __awaiter(_this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
          var _yield$tokenRequestFn, _token, info;
          return _regeneratorRuntime().wrap(function _callee$(_context) {
            while (1) {
              switch (_context.prev = _context.next) {
                case 0:
                  _context.prev = 0;
                  _context.next = 3;
                  return tokenRequestFn(this.cachedToken);
                case 3:
                  _yield$tokenRequestFn = _context.sent;
                  _token = _yield$tokenRequestFn.token;
                  info = _yield$tokenRequestFn.info;
                  this.cachedToken = _token;
                  resolve({
                    token: _token,
                    info: info
                  });
                  _context.next = 13;
                  break;
                case 10:
                  _context.prev = 10;
                  _context.t0 = _context["catch"](0);
                  reject(_context.t0);
                case 13:
                case "end":
                  return _context.stop();
              }
            }
          }, _callee, this, [[0, 10]]);
        }));
      });
    });
  };
  this.request = function (channelName) {
    return _this.execute(function (token) {
      return _this.requestTokenFn(channelName, token);
    });
  };
  this.cachedToken = token;
  this.requestTokenFn = requestTokenFn;
  this.queue = new TaskQueue();
});
var TaskQueue = /*#__PURE__*/_createClass(function TaskQueue() {
  var _this2 = this;
  var tasks = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var concurrentCount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
  _classCallCheck(this, TaskQueue);
  this.canRunNext = function () {
    return _this2.running.length < _this2.count && _this2.todo.length;
  };
  this.run = function (task) {
    return __awaiter(_this2, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
      var currentTask;
      return _regeneratorRuntime().wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              if (task) {
                this.todo.push(task);
              }
            case 1:
              if (!this.canRunNext()) {
                _context2.next = 9;
                break;
              }
              currentTask = this.todo.shift();
              this.running.push(currentTask);
              _context2.next = 6;
              return currentTask();
            case 6:
              this.running.shift();
              _context2.next = 1;
              break;
            case 9:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));
  };
  this.total = tasks.length;
  this.todo = tasks;
  this.running = [];
  this.count = concurrentCount;
});

var AblyAuth = /*#__PURE__*/_createClass(function AblyAuth(options) {
  var _this = this;
  _classCallCheck(this, AblyAuth);
  this.expiredAuthChannels = new Set();
  this.setExpired = function (channelName) {
    return _this.expiredAuthChannels.add(channelName);
  };
  this.isExpired = function (channelName) {
    return _this.expiredAuthChannels.has(channelName);
  };
  this.removeExpired = function (channelName) {
    return _this.expiredAuthChannels["delete"](channelName);
  };
  this.options = {
    queryTime: true,
    useTokenAuth: true,
    authCallback: function authCallback(_, callback) {
      return __awaiter(_this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        var _yield$this$authReque, _token, tokenDetails;
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.prev = 0;
                _context.next = 3;
                return this.authRequestExecuter.request(null);
              case 3:
                _yield$this$authReque = _context.sent;
                _token = _yield$this$authReque.token;
                tokenDetails = toTokenDetails(_token);
                callback(null, tokenDetails);
                _context.next = 12;
                break;
              case 9:
                _context.prev = 9;
                _context.t0 = _context["catch"](0);
                callback(_context.t0, null);
              case 12:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[0, 9]]);
      }));
    },
    echoMessages: false // https://docs.ably.io/client-lib-development-guide/features/#TO3h
  };

  this.requestToken = function (channelName, existingToken) {
    return __awaiter(_this, void 0, void 0, /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
      var postData, postOptions;
      return _regeneratorRuntime().wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              postData = JSON.stringify({
                channel_name: channelName,
                token: existingToken
              });
              postOptions = {
                uri: this.authEndpoint,
                method: 'POST',
                headers: _extends({
                  Accept: 'application/json',
                  'Content-Type': 'application/json',
                  'Content-Length': postData.length
                }, this.authHeaders),
                body: postData
              };
              _context2.next = 4;
              return httpRequestAsync(postOptions);
            case 4:
              return _context2.abrupt("return", _context2.sent);
            case 5:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2, this);
    }));
  };
  this.enableAuthorizeBeforeChannelAttach = function (ablyConnector) {
    var ablyClient = ablyConnector.ably;
    ablyClient.auth.getTimestamp(_this.options.queryTime, function () {
      return void 0;
    }); // generates serverTimeOffset in the background
    beforeChannelAttach(ablyClient, function (realtimeChannel, errorCallback) {
      var channelName = realtimeChannel.name;
      if (channelName.startsWith('public:')) {
        errorCallback(null);
        return;
      }
      // Use cached token if has channel capability and is not expired
      var tokenDetails = ablyClient.auth.tokenDetails;
      if (tokenDetails && !_this.isExpired(channelName)) {
        var capability = parseJwt(tokenDetails.token).payload['x-ably-capability'];
        var tokenHasChannelCapability = capability.includes("".concat(channelName, "\""));
        // checks with server time using offset, otherwise local time
        if (tokenHasChannelCapability && tokenDetails.expires > ablyClient.auth.getTimestampUsingOffset()) {
          errorCallback(null);
          return;
        }
      }
      // explicitly request token for given channel name
      _this.authRequestExecuter.request(channelName).then(function (_ref) {
        var jwtToken = _ref.token,
          info = _ref.info;
        // get upgraded token with channel access
        var echoChannel = ablyConnector.channels[channelName];
        _this.setPresenceInfo(echoChannel, info);
        ablyClient.auth.authorize(null, _extends(_extends({}, _this.options), {
          token: toTokenDetails(jwtToken)
        }), function (err, _tokenDetails) {
          if (err) {
            errorCallback(err);
          } else {
            _this.removeExpired(channelName);
            errorCallback(null);
          }
        });
      })["catch"](function (err) {
        return errorCallback(err);
      });
    });
  };
  this.onChannelFailed = function (echoAblyChannel) {
    return function (stateChange) {
      var _a;
      // channel capability rejected https://help.ably.io/error/40160
      if (((_a = stateChange.reason) === null || _a === void 0 ? void 0 : _a.code) == 40160) {
        _this.handleChannelAuthError(echoAblyChannel);
      }
    };
  };
  this.handleChannelAuthError = function (echoAblyChannel) {
    if (echoAblyChannel.skipAuth) {
      return;
    }
    var channelName = echoAblyChannel.name;
    // get upgraded token with channel access
    _this.authRequestExecuter.request(channelName).then(function (_ref2) {
      var jwtToken = _ref2.token,
        info = _ref2.info;
      _this.setPresenceInfo(echoAblyChannel, info);
      echoAblyChannel.ably.auth.authorize(null, _extends(_extends({}, _this.options), {
        token: toTokenDetails(jwtToken)
      }), function (err, _tokenDetails) {
        if (err) {
          echoAblyChannel._alertErrorListeners(err);
        } else {
          echoAblyChannel.skipAuth = true;
          echoAblyChannel.channel.once('attached', function () {
            echoAblyChannel.skipAuth = false;
          });
          echoAblyChannel.channel.attach(echoAblyChannel._alertErrorListeners);
        }
      });
    })["catch"](function (err) {
      return echoAblyChannel._alertErrorListeners(err);
    });
  };
  this.setPresenceInfo = function (echoAblyChannel, info) {
    if (echoAblyChannel instanceof AblyPresenceChannel) {
      echoAblyChannel.presenceData = info;
    }
  };
  var authEndpoint = options.authEndpoint,
    headers = options.auth.headers,
    token = options.token,
    requestTokenFn = options.requestTokenFn;
  this.authEndpoint = fullUrl(authEndpoint);
  this.authHeaders = headers;
  this.authRequestExecuter = new SequentialAuthTokenRequestExecuter(token, requestTokenFn !== null && requestTokenFn !== void 0 ? requestTokenFn : this.requestToken);
});

/**
 * This class represents a Pusher channel.
 */
var PusherChannel = /*#__PURE__*/function (_Channel) {
  _inherits(PusherChannel, _Channel);
  var _super = _createSuper(PusherChannel);
  /**
   * Create a new class instance.
   */
  function PusherChannel(pusher, name, options) {
    var _this;
    _classCallCheck(this, PusherChannel);
    _this = _super.call(this);
    _this.name = name;
    _this.pusher = pusher;
    _this.options = options;
    _this.eventFormatter = new EventFormatter(_this.options.namespace);
    _this.subscribe();
    return _this;
  }
  /**
   * Subscribe to a Pusher channel.
   */
  _createClass(PusherChannel, [{
    key: "subscribe",
    value: function subscribe() {
      this.subscription = this.pusher.subscribe(this.name);
    }
    /**
     * Unsubscribe from a Pusher channel.
     */
  }, {
    key: "unsubscribe",
    value: function unsubscribe() {
      this.pusher.unsubscribe(this.name);
    }
    /**
     * Listen for an event on the channel instance.
     */
  }, {
    key: "listen",
    value: function listen(event, callback) {
      this.on(this.eventFormatter.format(event), callback);
      return this;
    }
    /**
     * Listen for all events on the channel instance.
     */
  }, {
    key: "listenToAll",
    value: function listenToAll(callback) {
      var _this2 = this;
      this.subscription.bind_global(function (event, data) {
        if (event.startsWith('pusher:')) {
          return;
        }
        var namespace = _this2.options.namespace.replace(/\./g, '\\');
        var formattedEvent = event.startsWith(namespace) ? event.substring(namespace.length + 1) : '.' + event;
        callback(formattedEvent, data);
      });
      return this;
    }
    /**
     * Stop listening for an event on the channel instance.
     */
  }, {
    key: "stopListening",
    value: function stopListening(event, callback) {
      if (callback) {
        this.subscription.unbind(this.eventFormatter.format(event), callback);
      } else {
        this.subscription.unbind(this.eventFormatter.format(event));
      }
      return this;
    }
    /**
     * Stop listening for all events on the channel instance.
     */
  }, {
    key: "stopListeningToAll",
    value: function stopListeningToAll(callback) {
      if (callback) {
        this.subscription.unbind_global(callback);
      } else {
        this.subscription.unbind_global();
      }
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription succeeds.
     */
  }, {
    key: "subscribed",
    value: function subscribed(callback) {
      this.on('pusher:subscription_succeeded', function () {
        callback();
      });
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription error occurs.
     */
  }, {
    key: "error",
    value: function error(callback) {
      this.on('pusher:subscription_error', function (status) {
        callback(status);
      });
      return this;
    }
    /**
     * Bind a channel to an event.
     */
  }, {
    key: "on",
    value: function on(event, callback) {
      this.subscription.bind(event, callback);
      return this;
    }
  }]);
  return PusherChannel;
}(Channel);

/**
 * This class represents a Pusher private channel.
 */
var PusherPrivateChannel = /*#__PURE__*/function (_PusherChannel) {
  _inherits(PusherPrivateChannel, _PusherChannel);
  var _super = _createSuper(PusherPrivateChannel);
  function PusherPrivateChannel() {
    _classCallCheck(this, PusherPrivateChannel);
    return _super.apply(this, arguments);
  }
  _createClass(PusherPrivateChannel, [{
    key: "whisper",
    value:
    /**
     * Trigger client event on the channel.
     */
    function whisper(eventName, data) {
      this.pusher.channels.channels[this.name].trigger("client-".concat(eventName), data);
      return this;
    }
  }]);
  return PusherPrivateChannel;
}(PusherChannel);

/**
 * This class represents a Pusher private channel.
 */
var PusherEncryptedPrivateChannel = /*#__PURE__*/function (_PusherChannel) {
  _inherits(PusherEncryptedPrivateChannel, _PusherChannel);
  var _super = _createSuper(PusherEncryptedPrivateChannel);
  function PusherEncryptedPrivateChannel() {
    _classCallCheck(this, PusherEncryptedPrivateChannel);
    return _super.apply(this, arguments);
  }
  _createClass(PusherEncryptedPrivateChannel, [{
    key: "whisper",
    value:
    /**
     * Trigger client event on the channel.
     */
    function whisper(eventName, data) {
      this.pusher.channels.channels[this.name].trigger("client-".concat(eventName), data);
      return this;
    }
  }]);
  return PusherEncryptedPrivateChannel;
}(PusherChannel);

/**
 * This class represents a Pusher presence channel.
 */
var PusherPresenceChannel = /*#__PURE__*/function (_PusherChannel) {
  _inherits(PusherPresenceChannel, _PusherChannel);
  var _super = _createSuper(PusherPresenceChannel);
  function PusherPresenceChannel() {
    _classCallCheck(this, PusherPresenceChannel);
    return _super.apply(this, arguments);
  }
  _createClass(PusherPresenceChannel, [{
    key: "here",
    value:
    /**
     * Register a callback to be called anytime the member list changes.
     */
    function here(callback) {
      this.on('pusher:subscription_succeeded', function (data) {
        callback(Object.keys(data.members).map(function (k) {
          return data.members[k];
        }));
      });
      return this;
    }
    /**
     * Listen for someone joining the channel.
     */
  }, {
    key: "joining",
    value: function joining(callback) {
      this.on('pusher:member_added', function (member) {
        callback(member.info);
      });
      return this;
    }
    /**
     * Listen for someone leaving the channel.
     */
  }, {
    key: "leaving",
    value: function leaving(callback) {
      this.on('pusher:member_removed', function (member) {
        callback(member.info);
      });
      return this;
    }
    /**
     * Trigger client event on the channel.
     */
  }, {
    key: "whisper",
    value: function whisper(eventName, data) {
      this.pusher.channels.channels[this.name].trigger("client-".concat(eventName), data);
      return this;
    }
  }]);
  return PusherPresenceChannel;
}(PusherChannel);

/**
 * This class represents a Socket.io channel.
 */
var SocketIoChannel = /*#__PURE__*/function (_Channel) {
  _inherits(SocketIoChannel, _Channel);
  var _super = _createSuper(SocketIoChannel);
  /**
   * Create a new class instance.
   */
  function SocketIoChannel(socket, name, options) {
    var _this;
    _classCallCheck(this, SocketIoChannel);
    _this = _super.call(this);
    /**
     * The event callbacks applied to the socket.
     */
    _this.events = {};
    /**
     * User supplied callbacks for events on this channel.
     */
    _this.listeners = {};
    _this.name = name;
    _this.socket = socket;
    _this.options = options;
    _this.eventFormatter = new EventFormatter(_this.options.namespace);
    _this.subscribe();
    return _this;
  }
  /**
   * Subscribe to a Socket.io channel.
   */
  _createClass(SocketIoChannel, [{
    key: "subscribe",
    value: function subscribe() {
      this.socket.emit('subscribe', {
        channel: this.name,
        auth: this.options.auth || {}
      });
    }
    /**
     * Unsubscribe from channel and ubind event callbacks.
     */
  }, {
    key: "unsubscribe",
    value: function unsubscribe() {
      this.unbind();
      this.socket.emit('unsubscribe', {
        channel: this.name,
        auth: this.options.auth || {}
      });
    }
    /**
     * Listen for an event on the channel instance.
     */
  }, {
    key: "listen",
    value: function listen(event, callback) {
      this.on(this.eventFormatter.format(event), callback);
      return this;
    }
    /**
     * Stop listening for an event on the channel instance.
     */
  }, {
    key: "stopListening",
    value: function stopListening(event, callback) {
      this.unbindEvent(this.eventFormatter.format(event), callback);
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription succeeds.
     */
  }, {
    key: "subscribed",
    value: function subscribed(callback) {
      this.on('connect', function (socket) {
        callback(socket);
      });
      return this;
    }
    /**
     * Register a callback to be called anytime an error occurs.
     */
  }, {
    key: "error",
    value: function error(callback) {
      return this;
    }
    /**
     * Bind the channel's socket to an event and store the callback.
     */
  }, {
    key: "on",
    value: function on(event, callback) {
      var _this2 = this;
      this.listeners[event] = this.listeners[event] || [];
      if (!this.events[event]) {
        this.events[event] = function (channel, data) {
          if (_this2.name === channel && _this2.listeners[event]) {
            _this2.listeners[event].forEach(function (cb) {
              return cb(data);
            });
          }
        };
        this.socket.on(event, this.events[event]);
      }
      this.listeners[event].push(callback);
      return this;
    }
    /**
     * Unbind the channel's socket from all stored event callbacks.
     */
  }, {
    key: "unbind",
    value: function unbind() {
      var _this3 = this;
      Object.keys(this.events).forEach(function (event) {
        _this3.unbindEvent(event);
      });
    }
    /**
     * Unbind the listeners for the given event.
     */
  }, {
    key: "unbindEvent",
    value: function unbindEvent(event, callback) {
      this.listeners[event] = this.listeners[event] || [];
      if (callback) {
        this.listeners[event] = this.listeners[event].filter(function (cb) {
          return cb !== callback;
        });
      }
      if (!callback || this.listeners[event].length === 0) {
        if (this.events[event]) {
          this.socket.removeListener(event, this.events[event]);
          delete this.events[event];
        }
        delete this.listeners[event];
      }
    }
  }]);
  return SocketIoChannel;
}(Channel);

/**
 * This class represents a Socket.io private channel.
 */
var SocketIoPrivateChannel = /*#__PURE__*/function (_SocketIoChannel) {
  _inherits(SocketIoPrivateChannel, _SocketIoChannel);
  var _super = _createSuper(SocketIoPrivateChannel);
  function SocketIoPrivateChannel() {
    _classCallCheck(this, SocketIoPrivateChannel);
    return _super.apply(this, arguments);
  }
  _createClass(SocketIoPrivateChannel, [{
    key: "whisper",
    value:
    /**
     * Trigger client event on the channel.
     */
    function whisper(eventName, data) {
      this.socket.emit('client event', {
        channel: this.name,
        event: "client-".concat(eventName),
        data: data
      });
      return this;
    }
  }]);
  return SocketIoPrivateChannel;
}(SocketIoChannel);

/**
 * This class represents a Socket.io presence channel.
 */
var SocketIoPresenceChannel = /*#__PURE__*/function (_SocketIoPrivateChann) {
  _inherits(SocketIoPresenceChannel, _SocketIoPrivateChann);
  var _super = _createSuper(SocketIoPresenceChannel);
  function SocketIoPresenceChannel() {
    _classCallCheck(this, SocketIoPresenceChannel);
    return _super.apply(this, arguments);
  }
  _createClass(SocketIoPresenceChannel, [{
    key: "here",
    value:
    /**
     * Register a callback to be called anytime the member list changes.
     */
    function here(callback) {
      this.on('presence:subscribed', function (members) {
        callback(members.map(function (m) {
          return m.user_info;
        }));
      });
      return this;
    }
    /**
     * Listen for someone joining the channel.
     */
  }, {
    key: "joining",
    value: function joining(callback) {
      this.on('presence:joining', function (member) {
        return callback(member.user_info);
      });
      return this;
    }
    /**
     * Listen for someone leaving the channel.
     */
  }, {
    key: "leaving",
    value: function leaving(callback) {
      this.on('presence:leaving', function (member) {
        return callback(member.user_info);
      });
      return this;
    }
  }]);
  return SocketIoPresenceChannel;
}(SocketIoPrivateChannel);

/**
 * This class represents a null channel.
 */
var NullChannel = /*#__PURE__*/function (_Channel) {
  _inherits(NullChannel, _Channel);
  var _super = _createSuper(NullChannel);
  function NullChannel() {
    _classCallCheck(this, NullChannel);
    return _super.apply(this, arguments);
  }
  _createClass(NullChannel, [{
    key: "subscribe",
    value:
    /**
     * Subscribe to a channel.
     */
    function subscribe() {
      //
    }
    /**
     * Unsubscribe from a channel.
     */
  }, {
    key: "unsubscribe",
    value: function unsubscribe() {
      //
    }
    /**
     * Listen for an event on the channel instance.
     */
  }, {
    key: "listen",
    value: function listen(event, callback) {
      return this;
    }
    /**
     * Stop listening for an event on the channel instance.
     */
  }, {
    key: "stopListening",
    value: function stopListening(event, callback) {
      return this;
    }
    /**
     * Register a callback to be called anytime a subscription succeeds.
     */
  }, {
    key: "subscribed",
    value: function subscribed(callback) {
      return this;
    }
    /**
     * Register a callback to be called anytime an error occurs.
     */
  }, {
    key: "error",
    value: function error(callback) {
      return this;
    }
    /**
     * Bind a channel to an event.
     */
  }, {
    key: "on",
    value: function on(event, callback) {
      return this;
    }
  }]);
  return NullChannel;
}(Channel);

/**
 * This class represents a null private channel.
 */
var NullPrivateChannel = /*#__PURE__*/function (_NullChannel) {
  _inherits(NullPrivateChannel, _NullChannel);
  var _super = _createSuper(NullPrivateChannel);
  function NullPrivateChannel() {
    _classCallCheck(this, NullPrivateChannel);
    return _super.apply(this, arguments);
  }
  _createClass(NullPrivateChannel, [{
    key: "whisper",
    value:
    /**
     * Trigger client event on the channel.
     */
    function whisper(eventName, data) {
      return this;
    }
  }]);
  return NullPrivateChannel;
}(NullChannel);

/**
 * This class represents a null presence channel.
 */
var NullPresenceChannel = /*#__PURE__*/function (_NullChannel) {
  _inherits(NullPresenceChannel, _NullChannel);
  var _super = _createSuper(NullPresenceChannel);
  function NullPresenceChannel() {
    _classCallCheck(this, NullPresenceChannel);
    return _super.apply(this, arguments);
  }
  _createClass(NullPresenceChannel, [{
    key: "here",
    value:
    /**
     * Register a callback to be called anytime the member list changes.
     */
    function here(callback) {
      return this;
    }
    /**
     * Listen for someone joining the channel.
     */
  }, {
    key: "joining",
    value: function joining(callback) {
      return this;
    }
    /**
     * Listen for someone leaving the channel.
     */
  }, {
    key: "leaving",
    value: function leaving(callback) {
      return this;
    }
    /**
     * Trigger client event on the channel.
     */
  }, {
    key: "whisper",
    value: function whisper(eventName, data) {
      return this;
    }
  }]);
  return NullPresenceChannel;
}(NullChannel);

var Connector = /*#__PURE__*/function () {
  /**
   * Create a new class instance.
   */
  function Connector(options) {
    _classCallCheck(this, Connector);
    /**
     * Default connector options.
     */
    this._defaultOptions = {
      auth: {
        headers: {}
      },
      authEndpoint: '/broadcasting/auth',
      userAuthentication: {
        endpoint: '/broadcasting/user-auth',
        headers: {}
      },
      broadcaster: 'pusher',
      csrfToken: null,
      bearerToken: null,
      host: null,
      key: null,
      namespace: 'App.Events'
    };
    this.setOptions(options);
    this.connect();
  }
  /**
   * Merge the custom options with the defaults.
   */
  _createClass(Connector, [{
    key: "setOptions",
    value: function setOptions(options) {
      this.options = _extends(this._defaultOptions, options);
      var token = this.csrfToken();
      if (token) {
        this.options.auth.headers['X-CSRF-TOKEN'] = token;
        this.options.userAuthentication.headers['X-CSRF-TOKEN'] = token;
      }
      token = this.options.bearerToken;
      if (token) {
        this.options.auth.headers['Authorization'] = 'Bearer ' + token;
        this.options.userAuthentication.headers['Authorization'] = 'Bearer ' + token;
      }
      return options;
    }
    /**
     * Extract the CSRF token from the page.
     */
  }, {
    key: "csrfToken",
    value: function csrfToken() {
      var selector;
      if (typeof window !== 'undefined' && window['Laravel'] && window['Laravel'].csrfToken) {
        return window['Laravel'].csrfToken;
      } else if (this.options.csrfToken) {
        return this.options.csrfToken;
      } else if (typeof document !== 'undefined' && typeof document.querySelector === 'function' && (selector = document.querySelector('meta[name="csrf-token"]'))) {
        return selector.getAttribute('content');
      }
      return null;
    }
  }]);
  return Connector;
}();

/**
 * This class creates a connector to Pusher.
 */
var PusherConnector = /*#__PURE__*/function (_Connector) {
  _inherits(PusherConnector, _Connector);
  var _super = _createSuper(PusherConnector);
  function PusherConnector() {
    var _this;
    _classCallCheck(this, PusherConnector);
    _this = _super.apply(this, arguments);
    /**
     * All of the subscribed channel names.
     */
    _this.channels = {};
    return _this;
  }
  /**
   * Create a fresh Pusher connection.
   */
  _createClass(PusherConnector, [{
    key: "connect",
    value: function connect() {
      if (typeof this.options.client !== 'undefined') {
        this.pusher = this.options.client;
      } else if (this.options.Pusher) {
        this.pusher = new this.options.Pusher(this.options.key, this.options);
      } else {
        this.pusher = new Pusher(this.options.key, this.options);
      }
    }
    /**
     * Sign in the user via Pusher user authentication (https://pusher.com/docs/channels/using_channels/user-authentication/).
     */
  }, {
    key: "signin",
    value: function signin() {
      this.pusher.signin();
    }
    /**
     * Listen for an event on a channel instance.
     */
  }, {
    key: "listen",
    value: function listen(name, event, callback) {
      return this.channel(name).listen(event, callback);
    }
    /**
     * Get a channel instance by name.
     */
  }, {
    key: "channel",
    value: function channel(name) {
      if (!this.channels[name]) {
        this.channels[name] = new PusherChannel(this.pusher, name, this.options);
      }
      return this.channels[name];
    }
    /**
     * Get a private channel instance by name.
     */
  }, {
    key: "privateChannel",
    value: function privateChannel(name) {
      if (!this.channels['private-' + name]) {
        this.channels['private-' + name] = new PusherPrivateChannel(this.pusher, 'private-' + name, this.options);
      }
      return this.channels['private-' + name];
    }
    /**
     * Get a private encrypted channel instance by name.
     */
  }, {
    key: "encryptedPrivateChannel",
    value: function encryptedPrivateChannel(name) {
      if (!this.channels['private-encrypted-' + name]) {
        this.channels['private-encrypted-' + name] = new PusherEncryptedPrivateChannel(this.pusher, 'private-encrypted-' + name, this.options);
      }
      return this.channels['private-encrypted-' + name];
    }
    /**
     * Get a presence channel instance by name.
     */
  }, {
    key: "presenceChannel",
    value: function presenceChannel(name) {
      if (!this.channels['presence-' + name]) {
        this.channels['presence-' + name] = new PusherPresenceChannel(this.pusher, 'presence-' + name, this.options);
      }
      return this.channels['presence-' + name];
    }
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
  }, {
    key: "leave",
    value: function leave(name) {
      var _this2 = this;
      var channels = [name, 'private-' + name, 'private-encrypted-' + name, 'presence-' + name];
      channels.forEach(function (name, index) {
        _this2.leaveChannel(name);
      });
    }
    /**
     * Leave the given channel.
     */
  }, {
    key: "leaveChannel",
    value: function leaveChannel(name) {
      if (this.channels[name]) {
        this.channels[name].unsubscribe();
        delete this.channels[name];
      }
    }
    /**
     * Get the socket ID for the connection.
     */
  }, {
    key: "socketId",
    value: function socketId() {
      return this.pusher.connection.socket_id;
    }
    /**
     * Disconnect Pusher connection.
     */
  }, {
    key: "disconnect",
    value: function disconnect() {
      this.pusher.disconnect();
    }
  }]);
  return PusherConnector;
}(Connector);

/**
 * This class creates a connnector to a Socket.io server.
 */
var SocketIoConnector = /*#__PURE__*/function (_Connector) {
  _inherits(SocketIoConnector, _Connector);
  var _super = _createSuper(SocketIoConnector);
  function SocketIoConnector() {
    var _this;
    _classCallCheck(this, SocketIoConnector);
    _this = _super.apply(this, arguments);
    /**
     * All of the subscribed channel names.
     */
    _this.channels = {};
    return _this;
  }
  /**
   * Create a fresh Socket.io connection.
   */
  _createClass(SocketIoConnector, [{
    key: "connect",
    value: function connect() {
      var _this2 = this;
      var io = this.getSocketIO();
      this.socket = io(this.options.host, this.options);
      this.socket.on('reconnect', function () {
        Object.values(_this2.channels).forEach(function (channel) {
          channel.subscribe();
        });
      });
      return this.socket;
    }
    /**
     * Get socket.io module from global scope or options.
     */
  }, {
    key: "getSocketIO",
    value: function getSocketIO() {
      if (typeof this.options.client !== 'undefined') {
        return this.options.client;
      }
      if (typeof io !== 'undefined') {
        return io;
      }
      throw new Error('Socket.io client not found. Should be globally available or passed via options.client');
    }
    /**
     * Listen for an event on a channel instance.
     */
  }, {
    key: "listen",
    value: function listen(name, event, callback) {
      return this.channel(name).listen(event, callback);
    }
    /**
     * Get a channel instance by name.
     */
  }, {
    key: "channel",
    value: function channel(name) {
      if (!this.channels[name]) {
        this.channels[name] = new SocketIoChannel(this.socket, name, this.options);
      }
      return this.channels[name];
    }
    /**
     * Get a private channel instance by name.
     */
  }, {
    key: "privateChannel",
    value: function privateChannel(name) {
      if (!this.channels['private-' + name]) {
        this.channels['private-' + name] = new SocketIoPrivateChannel(this.socket, 'private-' + name, this.options);
      }
      return this.channels['private-' + name];
    }
    /**
     * Get a presence channel instance by name.
     */
  }, {
    key: "presenceChannel",
    value: function presenceChannel(name) {
      if (!this.channels['presence-' + name]) {
        this.channels['presence-' + name] = new SocketIoPresenceChannel(this.socket, 'presence-' + name, this.options);
      }
      return this.channels['presence-' + name];
    }
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
  }, {
    key: "leave",
    value: function leave(name) {
      var _this3 = this;
      var channels = [name, 'private-' + name, 'presence-' + name];
      channels.forEach(function (name) {
        _this3.leaveChannel(name);
      });
    }
    /**
     * Leave the given channel.
     */
  }, {
    key: "leaveChannel",
    value: function leaveChannel(name) {
      if (this.channels[name]) {
        this.channels[name].unsubscribe();
        delete this.channels[name];
      }
    }
    /**
     * Get the socket ID for the connection.
     */
  }, {
    key: "socketId",
    value: function socketId() {
      return this.socket.id;
    }
    /**
     * Disconnect Socketio connection.
     */
  }, {
    key: "disconnect",
    value: function disconnect() {
      this.socket.disconnect();
    }
  }]);
  return SocketIoConnector;
}(Connector);

/**
 * This class creates a null connector.
 */
var NullConnector = /*#__PURE__*/function (_Connector) {
  _inherits(NullConnector, _Connector);
  var _super = _createSuper(NullConnector);
  function NullConnector() {
    var _this;
    _classCallCheck(this, NullConnector);
    _this = _super.apply(this, arguments);
    /**
     * All of the subscribed channel names.
     */
    _this.channels = {};
    return _this;
  }
  /**
   * Create a fresh connection.
   */
  _createClass(NullConnector, [{
    key: "connect",
    value: function connect() {
      //
    }
    /**
     * Listen for an event on a channel instance.
     */
  }, {
    key: "listen",
    value: function listen(name, event, callback) {
      return new NullChannel();
    }
    /**
     * Get a channel instance by name.
     */
  }, {
    key: "channel",
    value: function channel(name) {
      return new NullChannel();
    }
    /**
     * Get a private channel instance by name.
     */
  }, {
    key: "privateChannel",
    value: function privateChannel(name) {
      return new NullPrivateChannel();
    }
    /**
     * Get a presence channel instance by name.
     */
  }, {
    key: "presenceChannel",
    value: function presenceChannel(name) {
      return new NullPresenceChannel();
    }
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
  }, {
    key: "leave",
    value: function leave(name) {
      //
    }
    /**
     * Leave the given channel.
     */
  }, {
    key: "leaveChannel",
    value: function leaveChannel(name) {
      //
    }
    /**
     * Get the socket ID for the connection.
     */
  }, {
    key: "socketId",
    value: function socketId() {
      return 'fake-socket-id';
    }
    /**
     * Disconnect the connection.
     */
  }, {
    key: "disconnect",
    value: function disconnect() {
      //
    }
  }]);
  return NullConnector;
}(Connector);

/**
 * This class creates a connector to Ably.
 */
var AblyConnector = /*#__PURE__*/function (_Connector) {
  _inherits(AblyConnector, _Connector);
  var _super = _createSuper(AblyConnector);
  function AblyConnector() {
    var _this;
    _classCallCheck(this, AblyConnector);
    _this = _super.apply(this, arguments);
    /**
     * All of the subscribed channel names.
     */
    _this.channels = {};
    return _this;
  }
  /**
   * Create a fresh Ably connection.
   */
  _createClass(AblyConnector, [{
    key: "connect",
    value: function connect() {
      if (typeof this.options.client !== 'undefined') {
        this.ably = this.options.client;
      } else {
        this.ablyAuth = new AblyAuth(this.options);
        if (!this.options.agents) {
          this.options.agents = {};
        }
        this.options.agents['laravel-echo'] = AblyConnector.LIB_VERSION;
        this.ably = new Ably.Realtime(_extends(_extends({}, this.ablyAuth.options), this.options));
        this.ablyAuth.enableAuthorizeBeforeChannelAttach(this);
      }
    }
    /**
     * Listen for an event on a channel instance.
     */
  }, {
    key: "listen",
    value: function listen(name, event, callback) {
      return this.channel(name).listen(event, callback);
    }
    /**
     * Get a channel instance by name.
     */
  }, {
    key: "channel",
    value: function channel(name) {
      var prefixedName = "public:".concat(name); // adding public as a ably namespace prefix
      if (!this.channels[prefixedName]) {
        this.channels[prefixedName] = new AblyChannel(this.ably, prefixedName, this.options);
      }
      return this.channels[prefixedName];
    }
    /**
     * Get a private channel instance by name.
     */
  }, {
    key: "privateChannel",
    value: function privateChannel(name) {
      var prefixedName = "private:".concat(name); // adding private as a ably namespace prefix
      if (!this.channels[prefixedName]) {
        this.channels[prefixedName] = new AblyPrivateChannel(this.ably, prefixedName, this.options, this.ablyAuth);
      }
      return this.channels[prefixedName];
    }
    /**
     * Get a presence channel instance by name.
     */
  }, {
    key: "presenceChannel",
    value: function presenceChannel(name) {
      var prefixedName = "presence:".concat(name); // adding presence as a ably namespace prefix
      if (!this.channels[prefixedName]) {
        this.channels[prefixedName] = new AblyPresenceChannel(this.ably, prefixedName, this.options, this.ablyAuth);
      }
      return this.channels[prefixedName];
    }
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
  }, {
    key: "leave",
    value: function leave(name) {
      var _this2 = this;
      var channels = ["public:".concat(name), "private:".concat(name), "presence:".concat(name)];
      channels.forEach(function (name, index) {
        _this2.leaveChannel(name);
      });
    }
    /**
     * Leave the given channel.
     */
  }, {
    key: "leaveChannel",
    value: function leaveChannel(name) {
      if (name.indexOf('public:') !== 0 && name.indexOf('private:') !== 0 && name.indexOf('presence:') !== 0) {
        throw new Error("Error leaving ".concat(name, ", name should be prefixed with either \"public:\", \"private:\" or \"presence:\""));
      }
      if (this.channels[name]) {
        this.channels[name].unsubscribe();
        this.ablyAuth.setExpired(name);
        delete this.channels[name];
      }
    }
    /**
     * Get the socket ID for the connection.
     */
  }, {
    key: "socketId",
    value: function socketId() {
      return this.ably.connection.key;
    }
    /**
     * Disconnect Ably connection.
     */
  }, {
    key: "disconnect",
    value: function disconnect() {
      this.ably.close();
    }
  }]);
  return AblyConnector;
}(Connector);
/**
 * The laravel-echo library version.
 */
AblyConnector.LIB_VERSION = '1.0.2';

/**
 * This class is the primary API for interacting with broadcasting.
 */
var Echo = /*#__PURE__*/function () {
  /**
   * Create a new class instance.
   */
  function Echo(options) {
    _classCallCheck(this, Echo);
    this.options = options;
    this.connect();
    if (!this.options.withoutInterceptors) {
      this.registerInterceptors();
    }
  }
  /**
   * Get a channel instance by name.
   */
  _createClass(Echo, [{
    key: "channel",
    value: function channel(_channel) {
      return this.connector.channel(_channel);
    }
    /**
     * Create a new connection.
     */
  }, {
    key: "connect",
    value: function connect() {
      if (this.options.broadcaster == 'ably') {
        this.connector = new AblyConnector(this.options);
      } else if (this.options.broadcaster == 'pusher') {
        this.connector = new PusherConnector(this.options);
      } else if (this.options.broadcaster == 'socket.io') {
        this.connector = new SocketIoConnector(this.options);
      } else if (this.options.broadcaster == 'null') {
        this.connector = new NullConnector(this.options);
      } else if (typeof this.options.broadcaster == 'function') {
        this.connector = new this.options.broadcaster(this.options);
      }
    }
    /**
     * Disconnect from the Echo server.
     */
  }, {
    key: "disconnect",
    value: function disconnect() {
      this.connector.disconnect();
    }
    /**
     * Get a presence channel instance by name.
     */
  }, {
    key: "join",
    value: function join(channel) {
      return this.connector.presenceChannel(channel);
    }
    /**
     * Leave the given channel, as well as its private and presence variants.
     */
  }, {
    key: "leave",
    value: function leave(channel) {
      this.connector.leave(channel);
    }
    /**
     * Leave the given channel.
     */
  }, {
    key: "leaveChannel",
    value: function leaveChannel(channel) {
      this.connector.leaveChannel(channel);
    }
    /**
     * Listen for an event on a channel instance.
     */
  }, {
    key: "listen",
    value: function listen(channel, event, callback) {
      return this.connector.listen(channel, event, callback);
    }
    /**
     * Get a private channel instance by name.
     */
  }, {
    key: "private",
    value: function _private(channel) {
      return this.connector.privateChannel(channel);
    }
    /**
     * Get a private encrypted channel instance by name.
     */
  }, {
    key: "encryptedPrivate",
    value: function encryptedPrivate(channel) {
      return this.connector.encryptedPrivateChannel(channel);
    }
    /**
     * Get the Socket ID for the connection.
     */
  }, {
    key: "socketId",
    value: function socketId() {
      return this.connector.socketId();
    }
    /**
     * Register 3rd party request interceptiors. These are used to automatically
     * send a connections socket id to a Laravel app with a X-Socket-Id header.
     */
  }, {
    key: "registerInterceptors",
    value: function registerInterceptors() {
      if (typeof Vue === 'function' && Vue.http) {
        this.registerVueRequestInterceptor();
      }
      if (typeof axios === 'function') {
        this.registerAxiosRequestInterceptor();
      }
      if (typeof jQuery === 'function') {
        this.registerjQueryAjaxSetup();
      }
      if ((typeof Turbo === "undefined" ? "undefined" : _typeof(Turbo)) === 'object') {
        this.registerTurboRequestInterceptor();
      }
    }
    /**
     * Register a Vue HTTP interceptor to add the X-Socket-ID header.
     */
  }, {
    key: "registerVueRequestInterceptor",
    value: function registerVueRequestInterceptor() {
      var _this = this;
      Vue.http.interceptors.push(function (request, next) {
        if (_this.socketId()) {
          request.headers.set('X-Socket-ID', _this.socketId());
        }
        next();
      });
    }
    /**
     * Register an Axios HTTP interceptor to add the X-Socket-ID header.
     */
  }, {
    key: "registerAxiosRequestInterceptor",
    value: function registerAxiosRequestInterceptor() {
      var _this2 = this;
      axios.interceptors.request.use(function (config) {
        if (_this2.socketId()) {
          config.headers['X-Socket-Id'] = _this2.socketId();
        }
        return config;
      });
    }
    /**
     * Register jQuery AjaxPrefilter to add the X-Socket-ID header.
     */
  }, {
    key: "registerjQueryAjaxSetup",
    value: function registerjQueryAjaxSetup() {
      var _this3 = this;
      if (typeof jQuery.ajax != 'undefined') {
        jQuery.ajaxPrefilter(function (options, originalOptions, xhr) {
          if (_this3.socketId()) {
            xhr.setRequestHeader('X-Socket-Id', _this3.socketId());
          }
        });
      }
    }
    /**
     * Register the Turbo Request interceptor to add the X-Socket-ID header.
     */
  }, {
    key: "registerTurboRequestInterceptor",
    value: function registerTurboRequestInterceptor() {
      var _this4 = this;
      document.addEventListener('turbo:before-fetch-request', function (event) {
        event.detail.fetchOptions.headers['X-Socket-Id'] = _this4.socketId();
      });
    }
  }]);
  return Echo;
}();

exports.Channel = Channel;
exports["default"] = Echo;
