function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var AgoraRTM = require('agora-rtm-sdk');
var AgoraRTM__default = _interopDefault(AgoraRTM);

var createClient = function createClient(appId, config, areaCodes) {
  var client;
  function createClosure() {
    if (!client) {
      client = AgoraRTM__default.createInstance(appId, config, areaCodes);
    }
    return client;
  }
  return function () {
    return createClosure();
  };
};
var createChannel = function createChannel(channelId) {
  var channel;
  function createClosure(client) {
    if (!channel) {
      channel = client.createChannel(channelId);
    }
    return channel;
  }
  return function (client) {
    return createClosure(client);
  };
};
var createLazyClient = function createLazyClient() {
  var client;
  function createClosure(appId, config, areaCodes) {
    if (!client) {
      client = AgoraRTM__default.createInstance(appId, config, areaCodes);
    }
    return client;
  }
  return function (appId, config, areaCodes) {
    return createClosure(appId, config, areaCodes);
  };
};
var createLazyChannel = function createLazyChannel() {
  var channel;
  function createClosure(client, channelId) {
    if (!channel) {
      channel = client.createChannel(channelId);
    }
    return channel;
  }
  return function (client, channelId) {
    return createClosure(client, channelId);
  };
};
var AreaCode;
(function (AreaCode) {
  AreaCode["GLOBAL"] = "GLOBAL";
  AreaCode["INDIA"] = "INDIA";
  AreaCode["JAPAN"] = "JAPAN";
  AreaCode["ASIA"] = "ASIA";
  AreaCode["EUROPE"] = "EUROPE";
  AreaCode["CHINA"] = "CHINA";
  AreaCode["NORTH_AMERICA"] = "NORTH_AMERICA";
})(AreaCode || (AreaCode = {}));

Object.keys(AgoraRTM).forEach(function (k) {
  if (k !== 'default') Object.defineProperty(exports, k, {
    enumerable: true,
    get: function () {
      return AgoraRTM[k];
    }
  });
});
exports.createChannel = createChannel;
exports.createClient = createClient;
exports.createLazyChannel = createLazyChannel;
exports.createLazyClient = createLazyClient;
exports.default = AgoraRTM__default;
//# sourceMappingURL=index.js.map
