"use strict";
(() => {
  var __create = Object.create;
  var __defProp = Object.defineProperty;
  var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
  var __getOwnPropNames = Object.getOwnPropertyNames;
  var __getProtoOf = Object.getPrototypeOf;
  var __hasOwnProp = Object.prototype.hasOwnProperty;
  var __require = /* @__PURE__ */ ((x3) => typeof require !== "undefined" ? require : typeof Proxy !== "undefined" ? new Proxy(x3, {
    get: (a3, b3) => (typeof require !== "undefined" ? require : a3)[b3]
  }) : x3)(function(x3) {
    if (typeof require !== "undefined")
      return require.apply(this, arguments);
    throw new Error('Dynamic require of "' + x3 + '" is not supported');
  });
  var __commonJS = (cb, mod) => function __require2() {
    return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
  };
  var __copyProps = (to, from, except, desc) => {
    if (from && typeof from === "object" || typeof from === "function") {
      for (let key of __getOwnPropNames(from))
        if (!__hasOwnProp.call(to, key) && key !== except)
          __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
    }
    return to;
  };
  var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
    // If the importer is in node compatibility mode or this is not an ESM
    // file that has been converted to a CommonJS file using a Babel-
    // compatible transform (i.e. "__esModule" has not been set), then set
    // "default" to the CommonJS "module.exports" for node compatibility.
    isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
    mod
  ));

  // node_modules/classnames/index.js
  var require_classnames = __commonJS({
    "node_modules/classnames/index.js"(exports, module) {
      (function() {
        "use strict";
        var hasOwn = {}.hasOwnProperty;
        var nativeCodeString = "[native code]";
        function classNames3() {
          var classes = [];
          for (var i3 = 0; i3 < arguments.length; i3++) {
            var arg = arguments[i3];
            if (!arg)
              continue;
            var argType = typeof arg;
            if (argType === "string" || argType === "number") {
              classes.push(arg);
            } else if (Array.isArray(arg)) {
              if (arg.length) {
                var inner = classNames3.apply(null, arg);
                if (inner) {
                  classes.push(inner);
                }
              }
            } else if (argType === "object") {
              if (arg.toString !== Object.prototype.toString && !arg.toString.toString().includes("[native code]")) {
                classes.push(arg.toString());
                continue;
              }
              for (var key in arg) {
                if (hasOwn.call(arg, key) && arg[key]) {
                  classes.push(key);
                }
              }
            }
          }
          return classes.join(" ");
        }
        if (typeof module !== "undefined" && module.exports) {
          classNames3.default = classNames3;
          module.exports = classNames3;
        } else if (typeof define === "function" && typeof define.amd === "object" && define.amd) {
          define("classnames", [], function() {
            return classNames3;
          });
        } else {
          window.classNames = classNames3;
        }
      })();
    }
  });

  // src/components/TooltipController/TooltipController.tsx
  var import_react5 = __require("react");

  // src/components/Tooltip/Tooltip.tsx
  var import_react4 = __require("react");
  var import_classnames2 = __toESM(require_classnames());

  // src/utils/debounce.ts
  var debounce = (func, wait, immediate) => {
    let timeout = null;
    return function debounced(...args) {
      const later = () => {
        timeout = null;
        if (!immediate) {
          func.apply(this, args);
        }
      };
      if (timeout) {
        clearTimeout(timeout);
      }
      timeout = setTimeout(later, wait);
    };
  };
  var debounce_default = debounce;

  // src/components/TooltipContent/TooltipContent.tsx
  var import_jsx_runtime = __require("react/jsx-runtime");
  var TooltipContent = ({ content }) => {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { dangerouslySetInnerHTML: { __html: content } });
  };
  var TooltipContent_default = TooltipContent;

  // src/components/TooltipProvider/TooltipProvider.tsx
  var import_react = __require("react");
  var import_jsx_runtime2 = __require("react/jsx-runtime");
  var DEFAULT_TOOLTIP_ID = "DEFAULT_TOOLTIP_ID";
  var DEFAULT_CONTEXT_DATA = {
    anchorRefs: /* @__PURE__ */ new Set(),
    activeAnchor: { current: null },
    attach: () => {
    },
    detach: () => {
    },
    setActiveAnchor: () => {
    }
  };
  var DEFAULT_CONTEXT_DATA_WRAPPER = {
    getTooltipData: () => DEFAULT_CONTEXT_DATA
  };
  var TooltipContext = (0, import_react.createContext)(DEFAULT_CONTEXT_DATA_WRAPPER);
  var TooltipProvider = ({ children }) => {
    const [anchorRefMap, setAnchorRefMap] = (0, import_react.useState)({
      [DEFAULT_TOOLTIP_ID]: /* @__PURE__ */ new Set()
    });
    const [activeAnchorMap, setActiveAnchorMap] = (0, import_react.useState)({
      [DEFAULT_TOOLTIP_ID]: { current: null }
    });
    const attach = (tooltipId, ...refs) => {
      setAnchorRefMap((oldMap) => {
        var _a;
        const tooltipRefs = (_a = oldMap[tooltipId]) != null ? _a : /* @__PURE__ */ new Set();
        refs.forEach((ref) => tooltipRefs.add(ref));
        return { ...oldMap, [tooltipId]: new Set(tooltipRefs) };
      });
    };
    const detach = (tooltipId, ...refs) => {
      setAnchorRefMap((oldMap) => {
        const tooltipRefs = oldMap[tooltipId];
        if (!tooltipRefs) {
          return oldMap;
        }
        refs.forEach((ref) => tooltipRefs.delete(ref));
        return { ...oldMap };
      });
    };
    const setActiveAnchor = (tooltipId, ref) => {
      setActiveAnchorMap((oldMap) => {
        var _a;
        if (((_a = oldMap[tooltipId]) == null ? void 0 : _a.current) === ref.current) {
          return oldMap;
        }
        return { ...oldMap, [tooltipId]: ref };
      });
    };
    const getTooltipData = (0, import_react.useCallback)(
      (tooltipId = DEFAULT_TOOLTIP_ID) => {
        var _a, _b;
        return {
          anchorRefs: (_a = anchorRefMap[tooltipId]) != null ? _a : /* @__PURE__ */ new Set(),
          activeAnchor: (_b = activeAnchorMap[tooltipId]) != null ? _b : { current: null },
          attach: (...refs) => attach(tooltipId, ...refs),
          detach: (...refs) => detach(tooltipId, ...refs),
          setActiveAnchor: (ref) => setActiveAnchor(tooltipId, ref)
        };
      },
      [anchorRefMap, activeAnchorMap, attach, detach]
    );
    const context = (0, import_react.useMemo)(() => {
      return {
        getTooltipData
      };
    }, [getTooltipData]);
    return /* @__PURE__ */ (0, import_jsx_runtime2.jsx)(TooltipContext.Provider, { value: context, children });
  };
  function useTooltip(tooltipId = DEFAULT_TOOLTIP_ID) {
    return (0, import_react.useContext)(TooltipContext).getTooltipData(tooltipId);
  }
  var TooltipProvider_default = TooltipProvider;

  // src/components/TooltipProvider/TooltipWrapper.tsx
  var import_react2 = __require("react");
  var import_classnames = __toESM(require_classnames());
  var import_jsx_runtime3 = __require("react/jsx-runtime");
  var TooltipWrapper = ({
    tooltipId,
    children,
    className,
    place,
    content,
    html,
    variant,
    offset,
    wrapper,
    events,
    positionStrategy,
    delayShow,
    delayHide
  }) => {
    const { attach, detach } = useTooltip(tooltipId);
    const anchorRef = (0, import_react2.useRef)(null);
    (0, import_react2.useEffect)(() => {
      attach(anchorRef);
      return () => {
        detach(anchorRef);
      };
    }, []);
    return /* @__PURE__ */ (0, import_jsx_runtime3.jsx)(
      "span",
      {
        ref: anchorRef,
        className: (0, import_classnames.default)("react-tooltip-wrapper", className),
        "data-tooltip-place": place,
        "data-tooltip-content": content,
        "data-tooltip-html": html,
        "data-tooltip-variant": variant,
        "data-tooltip-offset": offset,
        "data-tooltip-wrapper": wrapper,
        "data-tooltip-events": events,
        "data-tooltip-position-strategy": positionStrategy,
        "data-tooltip-delay-show": delayShow,
        "data-tooltip-delay-hide": delayHide,
        children
      }
    );
  };
  var TooltipWrapper_default = TooltipWrapper;

  // src/utils/use-isomorphic-layout-effect.ts
  var import_react3 = __require("react");
  var useIsomorphicLayoutEffect = typeof window !== "undefined" ? import_react3.useLayoutEffect : import_react3.useEffect;
  var use_isomorphic_layout_effect_default = useIsomorphicLayoutEffect;

  // node_modules/@floating-ui/core/dist/floating-ui.core.browser.min.mjs
  function t(t2) {
    return t2.split("-")[1];
  }
  function e(t2) {
    return "y" === t2 ? "height" : "width";
  }
  function n(t2) {
    return t2.split("-")[0];
  }
  function o(t2) {
    return ["top", "bottom"].includes(n(t2)) ? "x" : "y";
  }
  function i(i3, r3, a3) {
    let { reference: l3, floating: s3 } = i3;
    const c3 = l3.x + l3.width / 2 - s3.width / 2, f3 = l3.y + l3.height / 2 - s3.height / 2, m3 = o(r3), u3 = e(m3), g3 = l3[u3] / 2 - s3[u3] / 2, d3 = "x" === m3;
    let p3;
    switch (n(r3)) {
      case "top":
        p3 = { x: c3, y: l3.y - s3.height };
        break;
      case "bottom":
        p3 = { x: c3, y: l3.y + l3.height };
        break;
      case "right":
        p3 = { x: l3.x + l3.width, y: f3 };
        break;
      case "left":
        p3 = { x: l3.x - s3.width, y: f3 };
        break;
      default:
        p3 = { x: l3.x, y: l3.y };
    }
    switch (t(r3)) {
      case "start":
        p3[m3] -= g3 * (a3 && d3 ? -1 : 1);
        break;
      case "end":
        p3[m3] += g3 * (a3 && d3 ? -1 : 1);
    }
    return p3;
  }
  var r = async (t2, e2, n3) => {
    const { placement: o3 = "bottom", strategy: r3 = "absolute", middleware: a3 = [], platform: l3 } = n3, s3 = a3.filter(Boolean), c3 = await (null == l3.isRTL ? void 0 : l3.isRTL(e2));
    let f3 = await l3.getElementRects({ reference: t2, floating: e2, strategy: r3 }), { x: m3, y: u3 } = i(f3, o3, c3), g3 = o3, d3 = {}, p3 = 0;
    for (let n4 = 0; n4 < s3.length; n4++) {
      const { name: a4, fn: h3 } = s3[n4], { x: y3, y: x3, data: w3, reset: v3 } = await h3({ x: m3, y: u3, initialPlacement: o3, placement: g3, strategy: r3, middlewareData: d3, rects: f3, platform: l3, elements: { reference: t2, floating: e2 } });
      m3 = null != y3 ? y3 : m3, u3 = null != x3 ? x3 : u3, d3 = { ...d3, [a4]: { ...d3[a4], ...w3 } }, v3 && p3 <= 50 && (p3++, "object" == typeof v3 && (v3.placement && (g3 = v3.placement), v3.rects && (f3 = true === v3.rects ? await l3.getElementRects({ reference: t2, floating: e2, strategy: r3 }) : v3.rects), { x: m3, y: u3 } = i(f3, g3, c3)), n4 = -1);
    }
    return { x: m3, y: u3, placement: g3, strategy: r3, middlewareData: d3 };
  };
  function a(t2) {
    return "number" != typeof t2 ? function(t3) {
      return { top: 0, right: 0, bottom: 0, left: 0, ...t3 };
    }(t2) : { top: t2, right: t2, bottom: t2, left: t2 };
  }
  function l(t2) {
    return { ...t2, top: t2.y, left: t2.x, right: t2.x + t2.width, bottom: t2.y + t2.height };
  }
  async function s(t2, e2) {
    var n3;
    void 0 === e2 && (e2 = {});
    const { x: o3, y: i3, platform: r3, rects: s3, elements: c3, strategy: f3 } = t2, { boundary: m3 = "clippingAncestors", rootBoundary: u3 = "viewport", elementContext: g3 = "floating", altBoundary: d3 = false, padding: p3 = 0 } = e2, h3 = a(p3), y3 = c3[d3 ? "floating" === g3 ? "reference" : "floating" : g3], x3 = l(await r3.getClippingRect({ element: null == (n3 = await (null == r3.isElement ? void 0 : r3.isElement(y3))) || n3 ? y3 : y3.contextElement || await (null == r3.getDocumentElement ? void 0 : r3.getDocumentElement(c3.floating)), boundary: m3, rootBoundary: u3, strategy: f3 })), w3 = "floating" === g3 ? { ...s3.floating, x: o3, y: i3 } : s3.reference, v3 = await (null == r3.getOffsetParent ? void 0 : r3.getOffsetParent(c3.floating)), b3 = await (null == r3.isElement ? void 0 : r3.isElement(v3)) && await (null == r3.getScale ? void 0 : r3.getScale(v3)) || { x: 1, y: 1 }, R2 = l(r3.convertOffsetParentRelativeRectToViewportRelativeRect ? await r3.convertOffsetParentRelativeRectToViewportRelativeRect({ rect: w3, offsetParent: v3, strategy: f3 }) : w3);
    return { top: (x3.top - R2.top + h3.top) / b3.y, bottom: (R2.bottom - x3.bottom + h3.bottom) / b3.y, left: (x3.left - R2.left + h3.left) / b3.x, right: (R2.right - x3.right + h3.right) / b3.x };
  }
  var c = Math.min;
  var f = Math.max;
  function m(t2, e2, n3) {
    return f(t2, c(e2, n3));
  }
  var u = (n3) => ({ name: "arrow", options: n3, async fn(i3) {
    const { element: r3, padding: l3 = 0 } = n3 || {}, { x: s3, y: c3, placement: f3, rects: u3, platform: g3, elements: d3 } = i3;
    if (null == r3)
      return {};
    const p3 = a(l3), h3 = { x: s3, y: c3 }, y3 = o(f3), x3 = e(y3), w3 = await g3.getDimensions(r3), v3 = "y" === y3, b3 = v3 ? "top" : "left", R2 = v3 ? "bottom" : "right", A2 = v3 ? "clientHeight" : "clientWidth", P2 = u3.reference[x3] + u3.reference[y3] - h3[y3] - u3.floating[x3], T3 = h3[y3] - u3.reference[y3], O3 = await (null == g3.getOffsetParent ? void 0 : g3.getOffsetParent(r3));
    let E3 = O3 ? O3[A2] : 0;
    E3 && await (null == g3.isElement ? void 0 : g3.isElement(O3)) || (E3 = d3.floating[A2] || u3.floating[x3]);
    const D3 = P2 / 2 - T3 / 2, L3 = p3[b3], k2 = E3 - w3[x3] - p3[R2], B = E3 / 2 - w3[x3] / 2 + D3, C2 = m(L3, B, k2), H2 = null != t(f3) && B != C2 && u3.reference[x3] / 2 - (B < L3 ? p3[b3] : p3[R2]) - w3[x3] / 2 < 0;
    return { [y3]: h3[y3] - (H2 ? B < L3 ? L3 - B : k2 - B : 0), data: { [y3]: C2, centerOffset: B - C2 } };
  } });
  var g = ["top", "right", "bottom", "left"];
  var d = g.reduce((t2, e2) => t2.concat(e2, e2 + "-start", e2 + "-end"), []);
  var p = { left: "right", right: "left", bottom: "top", top: "bottom" };
  function h(t2) {
    return t2.replace(/left|right|bottom|top/g, (t3) => p[t3]);
  }
  function y(n3, i3, r3) {
    void 0 === r3 && (r3 = false);
    const a3 = t(n3), l3 = o(n3), s3 = e(l3);
    let c3 = "x" === l3 ? a3 === (r3 ? "end" : "start") ? "right" : "left" : "start" === a3 ? "bottom" : "top";
    return i3.reference[s3] > i3.floating[s3] && (c3 = h(c3)), { main: c3, cross: h(c3) };
  }
  var x = { start: "end", end: "start" };
  function w(t2) {
    return t2.replace(/start|end/g, (t3) => x[t3]);
  }
  var b = function(e2) {
    return void 0 === e2 && (e2 = {}), { name: "flip", options: e2, async fn(o3) {
      var i3;
      const { placement: r3, middlewareData: a3, rects: l3, initialPlacement: c3, platform: f3, elements: m3 } = o3, { mainAxis: u3 = true, crossAxis: g3 = true, fallbackPlacements: d3, fallbackStrategy: p3 = "bestFit", fallbackAxisSideDirection: x3 = "none", flipAlignment: v3 = true, ...b3 } = e2, R2 = n(r3), A2 = n(c3) === c3, P2 = await (null == f3.isRTL ? void 0 : f3.isRTL(m3.floating)), T3 = d3 || (A2 || !v3 ? [h(c3)] : function(t2) {
        const e3 = h(t2);
        return [w(t2), e3, w(e3)];
      }(c3));
      d3 || "none" === x3 || T3.push(...function(e3, o4, i4, r4) {
        const a4 = t(e3);
        let l4 = function(t2, e4, n3) {
          const o5 = ["left", "right"], i5 = ["right", "left"], r5 = ["top", "bottom"], a5 = ["bottom", "top"];
          switch (t2) {
            case "top":
            case "bottom":
              return n3 ? e4 ? i5 : o5 : e4 ? o5 : i5;
            case "left":
            case "right":
              return e4 ? r5 : a5;
            default:
              return [];
          }
        }(n(e3), "start" === i4, r4);
        return a4 && (l4 = l4.map((t2) => t2 + "-" + a4), o4 && (l4 = l4.concat(l4.map(w)))), l4;
      }(c3, v3, x3, P2));
      const O3 = [c3, ...T3], E3 = await s(o3, b3), D3 = [];
      let L3 = (null == (i3 = a3.flip) ? void 0 : i3.overflows) || [];
      if (u3 && D3.push(E3[R2]), g3) {
        const { main: t2, cross: e3 } = y(r3, l3, P2);
        D3.push(E3[t2], E3[e3]);
      }
      if (L3 = [...L3, { placement: r3, overflows: D3 }], !D3.every((t2) => t2 <= 0)) {
        var k2, B;
        const t2 = ((null == (k2 = a3.flip) ? void 0 : k2.index) || 0) + 1, e3 = O3[t2];
        if (e3)
          return { data: { index: t2, overflows: L3 }, reset: { placement: e3 } };
        let n3 = null == (B = L3.filter((t3) => t3.overflows[0] <= 0).sort((t3, e4) => t3.overflows[1] - e4.overflows[1])[0]) ? void 0 : B.placement;
        if (!n3)
          switch (p3) {
            case "bestFit": {
              var C2;
              const t3 = null == (C2 = L3.map((t4) => [t4.placement, t4.overflows.filter((t5) => t5 > 0).reduce((t5, e4) => t5 + e4, 0)]).sort((t4, e4) => t4[1] - e4[1])[0]) ? void 0 : C2[0];
              t3 && (n3 = t3);
              break;
            }
            case "initialPlacement":
              n3 = c3;
          }
        if (r3 !== n3)
          return { reset: { placement: n3 } };
      }
      return {};
    } };
  };
  var O = function(e2) {
    return void 0 === e2 && (e2 = 0), { name: "offset", options: e2, async fn(i3) {
      const { x: r3, y: a3 } = i3, l3 = await async function(e3, i4) {
        const { placement: r4, platform: a4, elements: l4 } = e3, s3 = await (null == a4.isRTL ? void 0 : a4.isRTL(l4.floating)), c3 = n(r4), f3 = t(r4), m3 = "x" === o(r4), u3 = ["left", "top"].includes(c3) ? -1 : 1, g3 = s3 && m3 ? -1 : 1, d3 = "function" == typeof i4 ? i4(e3) : i4;
        let { mainAxis: p3, crossAxis: h3, alignmentAxis: y3 } = "number" == typeof d3 ? { mainAxis: d3, crossAxis: 0, alignmentAxis: null } : { mainAxis: 0, crossAxis: 0, alignmentAxis: null, ...d3 };
        return f3 && "number" == typeof y3 && (h3 = "end" === f3 ? -1 * y3 : y3), m3 ? { x: h3 * g3, y: p3 * u3 } : { x: p3 * u3, y: h3 * g3 };
      }(i3, e2);
      return { x: r3 + l3.x, y: a3 + l3.y, data: l3 };
    } };
  };
  function E(t2) {
    return "x" === t2 ? "y" : "x";
  }
  var D = function(t2) {
    return void 0 === t2 && (t2 = {}), { name: "shift", options: t2, async fn(e2) {
      const { x: i3, y: r3, placement: a3 } = e2, { mainAxis: l3 = true, crossAxis: c3 = false, limiter: f3 = { fn: (t3) => {
        let { x: e3, y: n3 } = t3;
        return { x: e3, y: n3 };
      } }, ...u3 } = t2, g3 = { x: i3, y: r3 }, d3 = await s(e2, u3), p3 = o(n(a3)), h3 = E(p3);
      let y3 = g3[p3], x3 = g3[h3];
      if (l3) {
        const t3 = "y" === p3 ? "bottom" : "right";
        y3 = m(y3 + d3["y" === p3 ? "top" : "left"], y3, y3 - d3[t3]);
      }
      if (c3) {
        const t3 = "y" === h3 ? "bottom" : "right";
        x3 = m(x3 + d3["y" === h3 ? "top" : "left"], x3, x3 - d3[t3]);
      }
      const w3 = f3.fn({ ...e2, [p3]: y3, [h3]: x3 });
      return { ...w3, data: { x: w3.x - i3, y: w3.y - r3 } };
    } };
  };

  // node_modules/@floating-ui/dom/dist/floating-ui.dom.browser.min.mjs
  function n2(t2) {
    var e2;
    return (null == (e2 = t2.ownerDocument) ? void 0 : e2.defaultView) || window;
  }
  function o2(t2) {
    return n2(t2).getComputedStyle(t2);
  }
  var i2 = Math.min;
  var r2 = Math.max;
  var l2 = Math.round;
  function c2(t2) {
    const e2 = o2(t2);
    let n3 = parseFloat(e2.width), i3 = parseFloat(e2.height);
    const r3 = t2.offsetWidth, c3 = t2.offsetHeight, s3 = l2(n3) !== r3 || l2(i3) !== c3;
    return s3 && (n3 = r3, i3 = c3), { width: n3, height: i3, fallback: s3 };
  }
  function s2(t2) {
    return h2(t2) ? (t2.nodeName || "").toLowerCase() : "";
  }
  var f2;
  function u2() {
    if (f2)
      return f2;
    const t2 = navigator.userAgentData;
    return t2 && Array.isArray(t2.brands) ? (f2 = t2.brands.map((t3) => t3.brand + "/" + t3.version).join(" "), f2) : navigator.userAgent;
  }
  function a2(t2) {
    return t2 instanceof n2(t2).HTMLElement;
  }
  function d2(t2) {
    return t2 instanceof n2(t2).Element;
  }
  function h2(t2) {
    return t2 instanceof n2(t2).Node;
  }
  function p2(t2) {
    if ("undefined" == typeof ShadowRoot)
      return false;
    return t2 instanceof n2(t2).ShadowRoot || t2 instanceof ShadowRoot;
  }
  function g2(t2) {
    const { overflow: e2, overflowX: n3, overflowY: i3, display: r3 } = o2(t2);
    return /auto|scroll|overlay|hidden|clip/.test(e2 + i3 + n3) && !["inline", "contents"].includes(r3);
  }
  function m2(t2) {
    return ["table", "td", "th"].includes(s2(t2));
  }
  function y2(t2) {
    const e2 = /firefox/i.test(u2()), n3 = o2(t2), i3 = n3.backdropFilter || n3.WebkitBackdropFilter;
    return "none" !== n3.transform || "none" !== n3.perspective || !!i3 && "none" !== i3 || e2 && "filter" === n3.willChange || e2 && !!n3.filter && "none" !== n3.filter || ["transform", "perspective"].some((t3) => n3.willChange.includes(t3)) || ["paint", "layout", "strict", "content"].some((t3) => {
      const e3 = n3.contain;
      return null != e3 && e3.includes(t3);
    });
  }
  function x2() {
    return /^((?!chrome|android).)*safari/i.test(u2());
  }
  function w2(t2) {
    return ["html", "body", "#document"].includes(s2(t2));
  }
  function v2(t2) {
    return d2(t2) ? t2 : t2.contextElement;
  }
  var b2 = { x: 1, y: 1 };
  function L2(t2) {
    const e2 = v2(t2);
    if (!a2(e2))
      return b2;
    const n3 = e2.getBoundingClientRect(), { width: o3, height: i3, fallback: r3 } = c2(e2);
    let s3 = (r3 ? l2(n3.width) : n3.width) / o3, f3 = (r3 ? l2(n3.height) : n3.height) / i3;
    return s3 && Number.isFinite(s3) || (s3 = 1), f3 && Number.isFinite(f3) || (f3 = 1), { x: s3, y: f3 };
  }
  function E2(e2, o3, i3, r3) {
    var l3, c3;
    void 0 === o3 && (o3 = false), void 0 === i3 && (i3 = false);
    const s3 = e2.getBoundingClientRect(), f3 = v2(e2);
    let u3 = b2;
    o3 && (r3 ? d2(r3) && (u3 = L2(r3)) : u3 = L2(e2));
    const a3 = f3 ? n2(f3) : window, h3 = x2() && i3;
    let p3 = (s3.left + (h3 && (null == (l3 = a3.visualViewport) ? void 0 : l3.offsetLeft) || 0)) / u3.x, g3 = (s3.top + (h3 && (null == (c3 = a3.visualViewport) ? void 0 : c3.offsetTop) || 0)) / u3.y, m3 = s3.width / u3.x, y3 = s3.height / u3.y;
    if (f3) {
      const t2 = n2(f3), e3 = r3 && d2(r3) ? n2(r3) : r3;
      let o4 = t2.frameElement;
      for (; o4 && r3 && e3 !== t2; ) {
        const t3 = L2(o4), e4 = o4.getBoundingClientRect(), i4 = getComputedStyle(o4);
        e4.x += (o4.clientLeft + parseFloat(i4.paddingLeft)) * t3.x, e4.y += (o4.clientTop + parseFloat(i4.paddingTop)) * t3.y, p3 *= t3.x, g3 *= t3.y, m3 *= t3.x, y3 *= t3.y, p3 += e4.x, g3 += e4.y, o4 = n2(o4).frameElement;
      }
    }
    return l({ width: m3, height: y3, x: p3, y: g3 });
  }
  function R(t2) {
    return ((h2(t2) ? t2.ownerDocument : t2.document) || window.document).documentElement;
  }
  function T2(t2) {
    return d2(t2) ? { scrollLeft: t2.scrollLeft, scrollTop: t2.scrollTop } : { scrollLeft: t2.pageXOffset, scrollTop: t2.pageYOffset };
  }
  function C(t2) {
    return E2(R(t2)).left + T2(t2).scrollLeft;
  }
  function F(t2) {
    if ("html" === s2(t2))
      return t2;
    const e2 = t2.assignedSlot || t2.parentNode || p2(t2) && t2.host || R(t2);
    return p2(e2) ? e2.host : e2;
  }
  function W(t2) {
    const e2 = F(t2);
    return w2(e2) ? e2.ownerDocument.body : a2(e2) && g2(e2) ? e2 : W(e2);
  }
  function D2(t2, e2) {
    var o3;
    void 0 === e2 && (e2 = []);
    const i3 = W(t2), r3 = i3 === (null == (o3 = t2.ownerDocument) ? void 0 : o3.body), l3 = n2(i3);
    return r3 ? e2.concat(l3, l3.visualViewport || [], g2(i3) ? i3 : []) : e2.concat(i3, D2(i3));
  }
  function S(e2, i3, l3) {
    let c3;
    if ("viewport" === i3)
      c3 = function(t2, e3) {
        const o3 = n2(t2), i4 = R(t2), r3 = o3.visualViewport;
        let l4 = i4.clientWidth, c4 = i4.clientHeight, s4 = 0, f4 = 0;
        if (r3) {
          l4 = r3.width, c4 = r3.height;
          const t3 = x2();
          (!t3 || t3 && "fixed" === e3) && (s4 = r3.offsetLeft, f4 = r3.offsetTop);
        }
        return { width: l4, height: c4, x: s4, y: f4 };
      }(e2, l3);
    else if ("document" === i3)
      c3 = function(t2) {
        const e3 = R(t2), n3 = T2(t2), i4 = t2.ownerDocument.body, l4 = r2(e3.scrollWidth, e3.clientWidth, i4.scrollWidth, i4.clientWidth), c4 = r2(e3.scrollHeight, e3.clientHeight, i4.scrollHeight, i4.clientHeight);
        let s4 = -n3.scrollLeft + C(t2);
        const f4 = -n3.scrollTop;
        return "rtl" === o2(i4).direction && (s4 += r2(e3.clientWidth, i4.clientWidth) - l4), { width: l4, height: c4, x: s4, y: f4 };
      }(R(e2));
    else if (d2(i3))
      c3 = function(t2, e3) {
        const n3 = E2(t2, true, "fixed" === e3), o3 = n3.top + t2.clientTop, i4 = n3.left + t2.clientLeft, r3 = a2(t2) ? L2(t2) : { x: 1, y: 1 };
        return { width: t2.clientWidth * r3.x, height: t2.clientHeight * r3.y, x: i4 * r3.x, y: o3 * r3.y };
      }(i3, l3);
    else {
      const t2 = { ...i3 };
      if (x2()) {
        var s3, f3;
        const o3 = n2(e2);
        t2.x -= (null == (s3 = o3.visualViewport) ? void 0 : s3.offsetLeft) || 0, t2.y -= (null == (f3 = o3.visualViewport) ? void 0 : f3.offsetTop) || 0;
      }
      c3 = t2;
    }
    return l(c3);
  }
  function A(t2, e2) {
    return a2(t2) && "fixed" !== o2(t2).position ? e2 ? e2(t2) : t2.offsetParent : null;
  }
  function H(t2, e2) {
    const i3 = n2(t2);
    if (!a2(t2))
      return i3;
    let r3 = A(t2, e2);
    for (; r3 && m2(r3) && "static" === o2(r3).position; )
      r3 = A(r3, e2);
    return r3 && ("html" === s2(r3) || "body" === s2(r3) && "static" === o2(r3).position && !y2(r3)) ? i3 : r3 || function(t3) {
      let e3 = F(t3);
      for (; a2(e3) && !w2(e3); ) {
        if (y2(e3))
          return e3;
        e3 = F(e3);
      }
      return null;
    }(t2) || i3;
  }
  function V(t2, e2, n3) {
    const o3 = a2(e2), i3 = R(e2), r3 = E2(t2, true, "fixed" === n3, e2);
    let l3 = { scrollLeft: 0, scrollTop: 0 };
    const c3 = { x: 0, y: 0 };
    if (o3 || !o3 && "fixed" !== n3)
      if (("body" !== s2(e2) || g2(i3)) && (l3 = T2(e2)), a2(e2)) {
        const t3 = E2(e2, true);
        c3.x = t3.x + e2.clientLeft, c3.y = t3.y + e2.clientTop;
      } else
        i3 && (c3.x = C(i3));
    return { x: r3.left + l3.scrollLeft - c3.x, y: r3.top + l3.scrollTop - c3.y, width: r3.width, height: r3.height };
  }
  var O2 = { getClippingRect: function(t2) {
    let { element: e2, boundary: n3, rootBoundary: l3, strategy: c3 } = t2;
    const f3 = "clippingAncestors" === n3 ? function(t3, e3) {
      const n4 = e3.get(t3);
      if (n4)
        return n4;
      let i3 = D2(t3).filter((t4) => d2(t4) && "body" !== s2(t4)), r3 = null;
      const l4 = "fixed" === o2(t3).position;
      let c4 = l4 ? F(t3) : t3;
      for (; d2(c4) && !w2(c4); ) {
        const t4 = o2(c4), e4 = y2(c4);
        "fixed" === t4.position ? r3 = null : (l4 ? e4 || r3 : e4 || "static" !== t4.position || !r3 || !["absolute", "fixed"].includes(r3.position)) ? r3 = t4 : i3 = i3.filter((t5) => t5 !== c4), c4 = F(c4);
      }
      return e3.set(t3, i3), i3;
    }(e2, this._c) : [].concat(n3), u3 = [...f3, l3], a3 = u3[0], h3 = u3.reduce((t3, n4) => {
      const o3 = S(e2, n4, c3);
      return t3.top = r2(o3.top, t3.top), t3.right = i2(o3.right, t3.right), t3.bottom = i2(o3.bottom, t3.bottom), t3.left = r2(o3.left, t3.left), t3;
    }, S(e2, a3, c3));
    return { width: h3.right - h3.left, height: h3.bottom - h3.top, x: h3.left, y: h3.top };
  }, convertOffsetParentRelativeRectToViewportRelativeRect: function(t2) {
    let { rect: e2, offsetParent: n3, strategy: o3 } = t2;
    const i3 = a2(n3), r3 = R(n3);
    if (n3 === r3)
      return e2;
    let l3 = { scrollLeft: 0, scrollTop: 0 }, c3 = { x: 1, y: 1 };
    const f3 = { x: 0, y: 0 };
    if ((i3 || !i3 && "fixed" !== o3) && (("body" !== s2(n3) || g2(r3)) && (l3 = T2(n3)), a2(n3))) {
      const t3 = E2(n3);
      c3 = L2(n3), f3.x = t3.x + n3.clientLeft, f3.y = t3.y + n3.clientTop;
    }
    return { width: e2.width * c3.x, height: e2.height * c3.y, x: e2.x * c3.x - l3.scrollLeft * c3.x + f3.x, y: e2.y * c3.y - l3.scrollTop * c3.y + f3.y };
  }, isElement: d2, getDimensions: function(t2) {
    return a2(t2) ? c2(t2) : t2.getBoundingClientRect();
  }, getOffsetParent: H, getDocumentElement: R, getScale: L2, async getElementRects(t2) {
    let { reference: e2, floating: n3, strategy: o3 } = t2;
    const i3 = this.getOffsetParent || H, r3 = this.getDimensions;
    return { reference: V(e2, await i3(n3), o3), floating: { x: 0, y: 0, ...await r3(n3) } };
  }, getClientRects: (t2) => Array.from(t2.getClientRects()), isRTL: (t2) => "rtl" === o2(t2).direction };
  var z = (t2, n3, o3) => {
    const i3 = /* @__PURE__ */ new Map(), r3 = { platform: O2, ...o3 }, l3 = { ...r3.platform, _c: i3 };
    return r(t2, n3, { ...r3, platform: l3 });
  };

  // src/utils/compute-positions.ts
  var computeTooltipPosition = async ({
    elementReference = null,
    tooltipReference = null,
    tooltipArrowReference = null,
    place = "top",
    offset: offsetValue = 10,
    strategy = "absolute",
    middlewares = [O(Number(offsetValue)), b(), D({ padding: 5 })]
  }) => {
    if (!elementReference) {
      return { tooltipStyles: {}, tooltipArrowStyles: {}, place };
    }
    if (tooltipReference === null) {
      return { tooltipStyles: {}, tooltipArrowStyles: {}, place };
    }
    const middleware = middlewares;
    if (tooltipArrowReference) {
      middleware.push(u({ element: tooltipArrowReference, padding: 5 }));
      return z(elementReference, tooltipReference, {
        placement: place,
        strategy,
        middleware
      }).then(({ x: x3, y: y3, placement, middlewareData }) => {
        var _a, _b;
        const styles = { left: `${x3}px`, top: `${y3}px` };
        const { x: arrowX, y: arrowY } = (_a = middlewareData.arrow) != null ? _a : { x: 0, y: 0 };
        const staticSide = (_b = {
          top: "bottom",
          right: "left",
          bottom: "top",
          left: "right"
        }[placement.split("-")[0]]) != null ? _b : "bottom";
        const arrowStyle = {
          left: arrowX != null ? `${arrowX}px` : "",
          top: arrowY != null ? `${arrowY}px` : "",
          right: "",
          bottom: "",
          [staticSide]: "-4px"
        };
        return { tooltipStyles: styles, tooltipArrowStyles: arrowStyle, place: placement };
      });
    }
    return z(elementReference, tooltipReference, {
      placement: "bottom",
      strategy,
      middleware
    }).then(({ x: x3, y: y3, placement }) => {
      const styles = { left: `${x3}px`, top: `${y3}px` };
      return { tooltipStyles: styles, tooltipArrowStyles: {}, place: placement };
    });
  };

  // esbuild-css-modules-plugin-namespace:./src/components/Tooltip/styles.module.css?esbuild-css-modules-plugin-building
  var styles_module_default = { "arrow": "react-tooltip__arrow_KtSkBq", "clickable": "react-tooltip__clickable_KtSkBq", "dark": "react-tooltip__dark_KtSkBq", "error": "react-tooltip__error_KtSkBq", "fixed": "react-tooltip__fixed_KtSkBq", "info": "react-tooltip__info_KtSkBq", "light": "react-tooltip__light_KtSkBq", "noArrow": "react-tooltip__no-arrow_KtSkBq", "show": "react-tooltip__show_KtSkBq", "success": "react-tooltip__success_KtSkBq", "tooltip": "react-tooltip__tooltip_KtSkBq", "warning": "react-tooltip__warning_KtSkBq" };

  // src/components/Tooltip/Tooltip.tsx
  var import_jsx_runtime4 = __require("react/jsx-runtime");
  var Tooltip = ({
    // props
    id,
    className,
    classNameArrow,
    variant = "dark",
    anchorId,
    anchorSelect,
    place = "top",
    offset = 10,
    events = ["hover"],
    positionStrategy = "absolute",
    middlewares,
    wrapper: WrapperElement,
    children = null,
    delayShow = 0,
    delayHide = 0,
    float = false,
    noArrow = false,
    clickable = false,
    closeOnEsc = false,
    style: externalStyles,
    position,
    afterShow,
    afterHide,
    // props handled by controller
    content,
    html,
    isOpen,
    setIsOpen,
    activeAnchor,
    setActiveAnchor
  }) => {
    const tooltipRef = (0, import_react4.useRef)(null);
    const tooltipArrowRef = (0, import_react4.useRef)(null);
    const tooltipShowDelayTimerRef = (0, import_react4.useRef)(null);
    const tooltipHideDelayTimerRef = (0, import_react4.useRef)(null);
    const [actualPlacement, setActualPlacement] = (0, import_react4.useState)(place);
    const [inlineStyles, setInlineStyles] = (0, import_react4.useState)({});
    const [inlineArrowStyles, setInlineArrowStyles] = (0, import_react4.useState)({});
    const [show, setShow] = (0, import_react4.useState)(false);
    const [rendered, setRendered] = (0, import_react4.useState)(false);
    const wasShowing = (0, import_react4.useRef)(false);
    const lastFloatPosition = (0, import_react4.useRef)(null);
    const { anchorRefs, setActiveAnchor: setProviderActiveAnchor } = useTooltip(id);
    const hoveringTooltip = (0, import_react4.useRef)(false);
    const [anchorsBySelect, setAnchorsBySelect] = (0, import_react4.useState)([]);
    const mounted = (0, import_react4.useRef)(false);
    use_isomorphic_layout_effect_default(() => {
      mounted.current = true;
      return () => {
        mounted.current = false;
      };
    }, []);
    (0, import_react4.useEffect)(() => {
      if (!show) {
        const timeout = setTimeout(() => {
          setRendered(false);
        }, 150);
        return () => {
          clearTimeout(timeout);
        };
      }
      return () => null;
    }, [show]);
    const handleShow = (value) => {
      if (!mounted.current) {
        return;
      }
      if (value) {
        setRendered(true);
      }
      setTimeout(() => {
        if (!mounted.current) {
          return;
        }
        setIsOpen == null ? void 0 : setIsOpen(value);
        if (isOpen === void 0) {
          setShow(value);
        }
      }, 10);
    };
    (0, import_react4.useEffect)(() => {
      if (isOpen === void 0) {
        return () => null;
      }
      if (isOpen) {
        setRendered(true);
      }
      const timeout = setTimeout(() => {
        setShow(isOpen);
      }, 10);
      return () => {
        clearTimeout(timeout);
      };
    }, [isOpen]);
    (0, import_react4.useEffect)(() => {
      if (show === wasShowing.current) {
        return;
      }
      wasShowing.current = show;
      if (show) {
        afterShow == null ? void 0 : afterShow();
      } else {
        afterHide == null ? void 0 : afterHide();
      }
    }, [show]);
    const handleShowTooltipDelayed = () => {
      if (tooltipShowDelayTimerRef.current) {
        clearTimeout(tooltipShowDelayTimerRef.current);
      }
      tooltipShowDelayTimerRef.current = setTimeout(() => {
        handleShow(true);
      }, delayShow);
    };
    const handleHideTooltipDelayed = (delay = delayHide) => {
      if (tooltipHideDelayTimerRef.current) {
        clearTimeout(tooltipHideDelayTimerRef.current);
      }
      tooltipHideDelayTimerRef.current = setTimeout(() => {
        if (hoveringTooltip.current) {
          return;
        }
        handleShow(false);
      }, delay);
    };
    const handleShowTooltip = (event) => {
      var _a;
      if (!event) {
        return;
      }
      if (delayShow) {
        handleShowTooltipDelayed();
      } else {
        handleShow(true);
      }
      const target = (_a = event.currentTarget) != null ? _a : event.target;
      setActiveAnchor(target);
      setProviderActiveAnchor({ current: target });
      if (tooltipHideDelayTimerRef.current) {
        clearTimeout(tooltipHideDelayTimerRef.current);
      }
    };
    const handleHideTooltip = () => {
      if (clickable) {
        handleHideTooltipDelayed(delayHide || 100);
      } else if (delayHide) {
        handleHideTooltipDelayed();
      } else {
        handleShow(false);
      }
      if (tooltipShowDelayTimerRef.current) {
        clearTimeout(tooltipShowDelayTimerRef.current);
      }
    };
    const handleTooltipPosition = ({ x: x3, y: y3 }) => {
      const virtualElement = {
        getBoundingClientRect() {
          return {
            x: x3,
            y: y3,
            width: 0,
            height: 0,
            top: y3,
            left: x3,
            right: x3,
            bottom: y3
          };
        }
      };
      computeTooltipPosition({
        place,
        offset,
        elementReference: virtualElement,
        tooltipReference: tooltipRef.current,
        tooltipArrowReference: tooltipArrowRef.current,
        strategy: positionStrategy,
        middlewares
      }).then((computedStylesData) => {
        if (Object.keys(computedStylesData.tooltipStyles).length) {
          setInlineStyles(computedStylesData.tooltipStyles);
        }
        if (Object.keys(computedStylesData.tooltipArrowStyles).length) {
          setInlineArrowStyles(computedStylesData.tooltipArrowStyles);
        }
        setActualPlacement(computedStylesData.place);
      });
    };
    const handleMouseMove = (event) => {
      if (!event) {
        return;
      }
      const mouseEvent = event;
      const mousePosition = {
        x: mouseEvent.clientX,
        y: mouseEvent.clientY
      };
      handleTooltipPosition(mousePosition);
      lastFloatPosition.current = mousePosition;
    };
    const handleClickTooltipAnchor = (event) => {
      handleShowTooltip(event);
      if (delayHide) {
        handleHideTooltipDelayed();
      }
    };
    const handleClickOutsideAnchors = (event) => {
      const anchorById = document.querySelector(`[id='${anchorId}']`);
      if (anchorById == null ? void 0 : anchorById.contains(event.target)) {
        return;
      }
      if (anchorsBySelect.some((anchor) => anchor.contains(event.target))) {
        return;
      }
      handleShow(false);
    };
    const handleEsc = (event) => {
      if (event.key !== "Escape") {
        return;
      }
      handleShow(false);
    };
    const debouncedHandleShowTooltip = debounce_default(handleShowTooltip, 50);
    const debouncedHandleHideTooltip = debounce_default(handleHideTooltip, 50);
    (0, import_react4.useEffect)(() => {
      var _a, _b;
      const elementRefs = new Set(anchorRefs);
      anchorsBySelect.forEach((anchor) => {
        elementRefs.add({ current: anchor });
      });
      const anchorById = document.querySelector(`[id='${anchorId}']`);
      if (anchorById) {
        elementRefs.add({ current: anchorById });
      }
      if (closeOnEsc) {
        window.addEventListener("keydown", handleEsc);
      }
      const enabledEvents = [];
      if (events.find((event) => event === "click")) {
        window.addEventListener("click", handleClickOutsideAnchors);
        enabledEvents.push({ event: "click", listener: handleClickTooltipAnchor });
      }
      if (events.find((event) => event === "hover")) {
        enabledEvents.push(
          { event: "mouseenter", listener: debouncedHandleShowTooltip },
          { event: "mouseleave", listener: debouncedHandleHideTooltip },
          { event: "focus", listener: debouncedHandleShowTooltip },
          { event: "blur", listener: debouncedHandleHideTooltip }
        );
        if (float) {
          enabledEvents.push({
            event: "mousemove",
            listener: handleMouseMove
          });
        }
      }
      const handleMouseEnterTooltip = () => {
        hoveringTooltip.current = true;
      };
      const handleMouseLeaveTooltip = () => {
        hoveringTooltip.current = false;
        handleHideTooltip();
      };
      if (clickable) {
        (_a = tooltipRef.current) == null ? void 0 : _a.addEventListener("mouseenter", handleMouseEnterTooltip);
        (_b = tooltipRef.current) == null ? void 0 : _b.addEventListener("mouseleave", handleMouseLeaveTooltip);
      }
      enabledEvents.forEach(({ event, listener }) => {
        elementRefs.forEach((ref) => {
          var _a2;
          (_a2 = ref.current) == null ? void 0 : _a2.addEventListener(event, listener);
        });
      });
      return () => {
        var _a2, _b2;
        if (events.find((event) => event === "click")) {
          window.removeEventListener("click", handleClickOutsideAnchors);
        }
        if (closeOnEsc) {
          window.removeEventListener("keydown", handleEsc);
        }
        if (clickable) {
          (_a2 = tooltipRef.current) == null ? void 0 : _a2.removeEventListener("mouseenter", handleMouseEnterTooltip);
          (_b2 = tooltipRef.current) == null ? void 0 : _b2.removeEventListener("mouseleave", handleMouseLeaveTooltip);
        }
        enabledEvents.forEach(({ event, listener }) => {
          elementRefs.forEach((ref) => {
            var _a3;
            (_a3 = ref.current) == null ? void 0 : _a3.removeEventListener(event, listener);
          });
        });
      };
    }, [rendered, anchorRefs, anchorsBySelect, closeOnEsc, events]);
    (0, import_react4.useEffect)(() => {
      let selector = anchorSelect != null ? anchorSelect : "";
      if (!selector && id) {
        selector = `[data-tooltip-id='${id}']`;
      }
      const documentObserverCallback = (mutationList) => {
        const newAnchors = [];
        mutationList.forEach((mutation) => {
          if (mutation.type === "attributes" && mutation.attributeName === "data-tooltip-id") {
            const newId = mutation.target.getAttribute("data-tooltip-id");
            if (newId === id) {
              newAnchors.push(mutation.target);
            }
          }
          if (mutation.type !== "childList") {
            return;
          }
          if (activeAnchor) {
            ;
            [...mutation.removedNodes].some((node) => {
              if (node.contains(activeAnchor)) {
                setRendered(false);
                handleShow(false);
                setActiveAnchor(null);
                return true;
              }
              return false;
            });
          }
          if (!selector) {
            return;
          }
          try {
            const elements = [...mutation.addedNodes].filter((node) => node.nodeType === 1);
            newAnchors.push(
              ...elements.filter(
                (element) => element.matches(selector)
              )
            );
            newAnchors.push(
              ...elements.flatMap(
                (element) => [...element.querySelectorAll(selector)]
              )
            );
          } catch (e2) {
          }
        });
        if (newAnchors.length) {
          setAnchorsBySelect((anchors) => [...anchors, ...newAnchors]);
        }
      };
      const documentObserver = new MutationObserver(documentObserverCallback);
      documentObserver.observe(document.body, {
        childList: true,
        subtree: true,
        attributes: true,
        attributeFilter: ["data-tooltip-id"]
      });
      return () => {
        documentObserver.disconnect();
      };
    }, [id, anchorSelect, activeAnchor]);
    (0, import_react4.useEffect)(() => {
      if (position) {
        handleTooltipPosition(position);
        return;
      }
      if (float) {
        if (lastFloatPosition.current) {
          handleTooltipPosition(lastFloatPosition.current);
        }
        return;
      }
      computeTooltipPosition({
        place,
        offset,
        elementReference: activeAnchor,
        tooltipReference: tooltipRef.current,
        tooltipArrowReference: tooltipArrowRef.current,
        strategy: positionStrategy,
        middlewares
      }).then((computedStylesData) => {
        if (!mounted.current) {
          return;
        }
        if (Object.keys(computedStylesData.tooltipStyles).length) {
          setInlineStyles(computedStylesData.tooltipStyles);
        }
        if (Object.keys(computedStylesData.tooltipArrowStyles).length) {
          setInlineArrowStyles(computedStylesData.tooltipArrowStyles);
        }
        setActualPlacement(computedStylesData.place);
      });
    }, [show, activeAnchor, content, html, place, offset, positionStrategy, position]);
    (0, import_react4.useEffect)(() => {
      var _a;
      const anchorById = document.querySelector(`[id='${anchorId}']`);
      const anchors = [...anchorsBySelect, anchorById];
      if (!activeAnchor || !anchors.includes(activeAnchor)) {
        setActiveAnchor((_a = anchorsBySelect[0]) != null ? _a : anchorById);
      }
    }, [anchorId, anchorsBySelect, activeAnchor]);
    (0, import_react4.useEffect)(() => {
      return () => {
        if (tooltipShowDelayTimerRef.current) {
          clearTimeout(tooltipShowDelayTimerRef.current);
        }
        if (tooltipHideDelayTimerRef.current) {
          clearTimeout(tooltipHideDelayTimerRef.current);
        }
      };
    }, []);
    (0, import_react4.useEffect)(() => {
      let selector = anchorSelect;
      if (!selector && id) {
        selector = `[data-tooltip-id='${id}']`;
      }
      if (!selector) {
        return;
      }
      try {
        const anchors = Array.from(document.querySelectorAll(selector));
        setAnchorsBySelect(anchors);
      } catch (e2) {
        setAnchorsBySelect([]);
      }
    }, [id, anchorSelect]);
    const hasContentOrChildren = Boolean(html || content || children);
    const canShow = hasContentOrChildren && show && Object.keys(inlineStyles).length > 0;
    return rendered ? /* @__PURE__ */ (0, import_jsx_runtime4.jsxs)(
      WrapperElement,
      {
        id,
        role: "tooltip",
        className: (0, import_classnames2.default)(
          "react-tooltip",
          styles_module_default["tooltip"],
          styles_module_default[variant],
          className,
          `react-tooltip__place-${actualPlacement}`,
          {
            [styles_module_default["show"]]: canShow,
            [styles_module_default["fixed"]]: positionStrategy === "fixed",
            [styles_module_default["clickable"]]: clickable
          }
        ),
        style: { ...externalStyles, ...inlineStyles },
        ref: tooltipRef,
        children: [
          html && /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(TooltipContent_default, { content: html }) || content || children,
          /* @__PURE__ */ (0, import_jsx_runtime4.jsx)(
            WrapperElement,
            {
              className: (0, import_classnames2.default)("react-tooltip-arrow", styles_module_default["arrow"], classNameArrow, {
                /**
                 * changed from dash `no-arrow` to camelcase because of:
                 * https://github.com/indooorsman/esbuild-css-modules-plugin/issues/42
                 */
                [styles_module_default["noArrow"]]: noArrow
              }),
              style: inlineArrowStyles,
              ref: tooltipArrowRef
            }
          )
        ]
      }
    ) : null;
  };
  var Tooltip_default = Tooltip;

  // src/components/TooltipController/TooltipController.tsx
  var import_jsx_runtime5 = __require("react/jsx-runtime");
  var TooltipController = ({
    id,
    anchorId,
    anchorSelect,
    content,
    html,
    className,
    classNameArrow,
    variant = "dark",
    place = "top",
    offset = 10,
    wrapper = "div",
    children = null,
    events = ["hover"],
    positionStrategy = "absolute",
    middlewares,
    delayShow = 0,
    delayHide = 0,
    float = false,
    noArrow = false,
    clickable = false,
    closeOnEsc = false,
    style,
    position,
    isOpen,
    setIsOpen,
    afterShow,
    afterHide
  }) => {
    const [tooltipContent, setTooltipContent] = (0, import_react5.useState)(content);
    const [tooltipHtml, setTooltipHtml] = (0, import_react5.useState)(html);
    const [tooltipPlace, setTooltipPlace] = (0, import_react5.useState)(place);
    const [tooltipVariant, setTooltipVariant] = (0, import_react5.useState)(variant);
    const [tooltipOffset, setTooltipOffset] = (0, import_react5.useState)(offset);
    const [tooltipDelayShow, setTooltipDelayShow] = (0, import_react5.useState)(delayShow);
    const [tooltipDelayHide, setTooltipDelayHide] = (0, import_react5.useState)(delayHide);
    const [tooltipFloat, setTooltipFloat] = (0, import_react5.useState)(float);
    const [tooltipWrapper, setTooltipWrapper] = (0, import_react5.useState)(wrapper);
    const [tooltipEvents, setTooltipEvents] = (0, import_react5.useState)(events);
    const [tooltipPositionStrategy, setTooltipPositionStrategy] = (0, import_react5.useState)(positionStrategy);
    const [activeAnchor, setActiveAnchor] = (0, import_react5.useState)(null);
    const { anchorRefs, activeAnchor: providerActiveAnchor } = useTooltip(id);
    const getDataAttributesFromAnchorElement = (elementReference) => {
      const dataAttributes = elementReference == null ? void 0 : elementReference.getAttributeNames().reduce((acc, name) => {
        var _a;
        if (name.startsWith("data-tooltip-")) {
          const parsedAttribute = name.replace(/^data-tooltip-/, "");
          acc[parsedAttribute] = (_a = elementReference == null ? void 0 : elementReference.getAttribute(name)) != null ? _a : null;
        }
        return acc;
      }, {});
      return dataAttributes;
    };
    const applyAllDataAttributesFromAnchorElement = (dataAttributes) => {
      const handleDataAttributes = {
        place: (value) => {
          setTooltipPlace(value != null ? value : place);
        },
        content: (value) => {
          setTooltipContent(value != null ? value : content);
        },
        html: (value) => {
          setTooltipHtml(value != null ? value : html);
        },
        variant: (value) => {
          setTooltipVariant(value != null ? value : variant);
        },
        offset: (value) => {
          setTooltipOffset(value === null ? offset : Number(value));
        },
        wrapper: (value) => {
          setTooltipWrapper(value != null ? value : wrapper);
        },
        events: (value) => {
          const parsed = value == null ? void 0 : value.split(" ");
          setTooltipEvents(parsed != null ? parsed : events);
        },
        "position-strategy": (value) => {
          setTooltipPositionStrategy(value != null ? value : positionStrategy);
        },
        "delay-show": (value) => {
          setTooltipDelayShow(value === null ? delayShow : Number(value));
        },
        "delay-hide": (value) => {
          setTooltipDelayHide(value === null ? delayHide : Number(value));
        },
        float: (value) => {
          setTooltipFloat(value === null ? float : value === "true");
        }
      };
      Object.values(handleDataAttributes).forEach((handler) => handler(null));
      Object.entries(dataAttributes).forEach(([key, value]) => {
        var _a;
        (_a = handleDataAttributes[key]) == null ? void 0 : _a.call(handleDataAttributes, value);
      });
    };
    (0, import_react5.useEffect)(() => {
      setTooltipContent(content);
    }, [content]);
    (0, import_react5.useEffect)(() => {
      setTooltipHtml(html);
    }, [html]);
    (0, import_react5.useEffect)(() => {
      setTooltipPlace(place);
    }, [place]);
    (0, import_react5.useEffect)(() => {
      var _a;
      const elementRefs = new Set(anchorRefs);
      let selector = anchorSelect;
      if (!selector && id) {
        selector = `[data-tooltip-id='${id}']`;
      }
      if (selector) {
        try {
          const anchorsBySelect = document.querySelectorAll(selector);
          anchorsBySelect.forEach((anchor) => {
            elementRefs.add({ current: anchor });
          });
        } catch (e2) {
          if (true) {
            console.warn(`[react-tooltip] "${anchorSelect}" is not a valid CSS selector`);
          }
        }
      }
      const anchorById = document.querySelector(`[id='${anchorId}']`);
      if (anchorById) {
        elementRefs.add({ current: anchorById });
      }
      if (!elementRefs.size) {
        return () => null;
      }
      const anchorElement = (_a = activeAnchor != null ? activeAnchor : anchorById) != null ? _a : providerActiveAnchor.current;
      const observerCallback = (mutationList) => {
        mutationList.forEach((mutation) => {
          var _a2;
          if (!anchorElement || mutation.type !== "attributes" || !((_a2 = mutation.attributeName) == null ? void 0 : _a2.startsWith("data-tooltip-"))) {
            return;
          }
          const dataAttributes = getDataAttributesFromAnchorElement(anchorElement);
          applyAllDataAttributesFromAnchorElement(dataAttributes);
        });
      };
      const observer = new MutationObserver(observerCallback);
      const observerConfig = { attributes: true, childList: false, subtree: false };
      if (anchorElement) {
        const dataAttributes = getDataAttributesFromAnchorElement(anchorElement);
        applyAllDataAttributesFromAnchorElement(dataAttributes);
        observer.observe(anchorElement, observerConfig);
      }
      return () => {
        observer.disconnect();
      };
    }, [anchorRefs, providerActiveAnchor, activeAnchor, anchorId, anchorSelect]);
    const props = {
      id,
      anchorId,
      anchorSelect,
      className,
      classNameArrow,
      content: tooltipContent,
      html: tooltipHtml,
      place: tooltipPlace,
      variant: tooltipVariant,
      offset: tooltipOffset,
      wrapper: tooltipWrapper,
      events: tooltipEvents,
      positionStrategy: tooltipPositionStrategy,
      middlewares,
      delayShow: tooltipDelayShow,
      delayHide: tooltipDelayHide,
      float: tooltipFloat,
      noArrow,
      clickable,
      closeOnEsc,
      style,
      position,
      isOpen,
      setIsOpen,
      afterShow,
      afterHide,
      activeAnchor,
      setActiveAnchor: (anchor) => setActiveAnchor(anchor)
    };
    return children ? /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(Tooltip_default, { ...props, children }) : /* @__PURE__ */ (0, import_jsx_runtime5.jsx)(Tooltip_default, { ...props });
  };
  var TooltipController_default = TooltipController;
})();
/*! Bundled license information:

classnames/index.js:
  (*!
  	Copyright (c) 2018 Jed Watson.
  	Licensed under the MIT License (MIT), see
  	http://jedwatson.github.io/classnames
  *)
*/
//# sourceMappingURL=react-tooltip.iife.js.map
