import TopNavi from "@/Components/TopNavi";
import { ToastContainer } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import CookieConsent from "react-cookie-consent";
import __ from "@/Functions/Translate";
import HomepageHeader from "@/Components/HomepageHeader";
import { usePage, Link } from "@inertiajs/inertia-react";

export default function Front({
    children,
    containerClass = "",
    headerShow = false,
    extraHeader = false,
    extraHeaderTitle = "",
    extraHeaderText = "",
    extraHeaderImage = "",
    extraImageHeight = "",
}) {
    const { seo_title, pages } = usePage().props;

    return (
        <div className="flex flex-col min-h-screen">
            <ToastContainer theme="dark" />
            <TopNavi />

            {headerShow && <HomepageHeader />}

            {extraHeader && (
                <div className="bg-light-violet border-2 w-full dark:bg-black dark:border-zinc-900 lg:pl-5 mt-[100px] pl-3">
                    <div className="bg-light-violet dark:bg-black pt-2">
                        <div className="flex flex-wrap items-center max-w-7xl mx-auto">
                            <div>
                                <img
                                    src={extraHeaderImage}
                                    alt=""
                                    className={extraImageHeight}
                                />
                            </div>
                            <div className="ml-3">
                                <h3 className="text-2xl text-orange-400 dark:text-white font-bold">
                                    {extraHeaderTitle}
                                </h3>

                                <div className="hidden lg:flex lg:items-center lg:space-x-3">
                                    {extraHeaderText}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            )}

            <div className="flex-grow w-full max-w-7xl min-h-full mx-auto px-3">
                <div className={"mt-[100px]"}>{children}</div>
            </div>

            <CookieConsent>
                {__(
                    "This website uses cookies to enhance the user experience."
                )}
            </CookieConsent>

            <div className="bg-slate-100 border-t w-full dark:bg-zinc-900 dark:border-zinc-800 mt-10 py-3">
                <div className="flex flex-col justify-between items-center lg:flex-row max-w-7xl mx-auto">
                    <div>
                        <Link
                            className="text-sm dark:text-zinc-300 font-semibold"
                            href={route("home")}
                        >
                            &copy; {seo_title}
                        </Link>
                    </div>
                    <div className="text-right">
                        <div className="flex flex-col md:flex-row">
                            {pages.map((p) => (
                                <Link
                                    className="text-gray-600 text-sm dark:text-zinc-300 mr-5"
                                    key={`page-${p.id}`}
                                    href={route("page", { page: p.page_slug })}
                                >
                                    {p.page_title}
                                </Link>
                            ))}

                            <Link
                                className="text-gray-600 text-sm dark:text-zinc-300 mr-5"
                                href={route("contact.form")}
                            >
                                {__("Get in Touch")}
                            </Link>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    );
}
