import __ from "@/Functions/Translate";
import PrimaryButton from "@/Components/PrimaryButton";
import SecondaryButton from "@/Components/SecondaryButton";
import DangerButton from "@/Components/DangerButton";
import { Head, Link, useForm, usePage } from "@inertiajs/inertia-react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";
import { Inertia } from "@inertiajs/inertia";
import { AiOutlineEye } from "react-icons/ai";
import "react-tooltip/dist/react-tooltip.css";
import { useState } from "react";
import Modal from "@/Components/Modal";
import { BsTagFill } from "react-icons/bs";
import TextInput from "@/Components/TextInput";
import AccountNavi from "../Channel/Partials/AccountNavi";
import { MdOutlineInsertPhoto } from "react-icons/md";
import SingleGallery from "./SingleGallery";

export default function GalleriesOrdered({ galleries }) {
  const { auth } = usePage().props;

  const [showDeleteConfirmation, setShowDeleteConfirmation] = useState(false);
  const [deleteId, setDeleteId] = useState(0);
  const [searchTerm, setSearchTerm] = useState("");
  const [modal, setModal] = useState(false);
  const [playVideo, setPlayVideo] = useState(false);

  const playModal = (e, video) => {
    e.preventDefault();
    setPlayVideo(video);
    setModal(true);
  };

  const closeModal = () => {
    setModal(false);
  };

  // active tab class
  const activeTabClass =
    "text-xl font-bold mr-2 md:mr-4 text-indigo-800 dark:text-indigo-500 border-b-2 border-indigo-800";
  const inactiveTabClass =
    "text-xl font-bold mr-2 md:mr-4 hover:text-indigo-800 dark:text-white dark:hover:text-indigo-500";

  const searchGalleries = (e) => {
    e.preventDefault();

    console.log(
      `Would visit: ${route("gallery.ordered")}?search_term=${searchTerm}`
    );
    Inertia.visit(`${route("gallery.ordered")}?search_term=${searchTerm}`, {
      method: "GET",
      preserveState: true,
      only: galleries,
    });
  };

  return (
    <AuthenticatedLayout>
      <Head title={__("Purchased Galleries")} />

      <Modal show={modal} onClose={(e) => setModal(false)}>
        {playVideo && (
          <SingleGallery
            gallery={playVideo}
            inModal={true}
            closeModal={closeModal}
          />
        )}
      </Modal>

      <div className="lg:flex lg:space-x-10">
        <AccountNavi active={"my-gallery"} />

        <div className="ml-0 w-full">
          {auth.user.is_streamer == "yes" && (
            <div className="mb-5">
              <Link
                href={route("gallery.manager")}
                className={inactiveTabClass}
              >
                {__("Upload Gallery")}
              </Link>
              <Link href={route("gallery.ordered")} className={activeTabClass}>
                {__("Galleries Ordered")}
              </Link>
            </div>
          )}

          <div className="p-4 sm:p-8 bg-white dark:bg-zinc-900 shadow sm:rounded-lg">
            <header>
              <h2 className="text-lg md:text-xl font-medium text-gray-600 dark:text-gray-100">
                {__("My Purchased Galleries")}
              </h2>

              <p className="mt-1 mb-2 text-sm text-gray-600 dark:text-gray-400">
                {__("Access to galleries you've purchased")}
              </p>

              <form onSubmit={searchGalleries}>
                <div className="flex items-center">
                  <TextInput
                    name="search_term"
                    placeholder={__("Search Gallery")}
                    value={searchTerm}
                    handleChange={(e) => setSearchTerm(e.target.value)}
                  />
                  <PrimaryButton
                    className="ml-2 py-3"
                    onClick={(e) => searchGalleries(e)}
                  >
                    {__("GO")}
                  </PrimaryButton>
                </div>
              </form>
            </header>

            <hr className="my-5" />

            {galleries.total === 0 && (
              <div className="text-gray-600 dark:text-white">
                {__("No galleries to show.")}
              </div>
            )}

            {galleries.total !== 0 && (
              <div className="flex items-center flex-wrap">
                {galleries.data.map((v) => (
                  <div key={`gallery-${v.id}`} className={"mr-5 mb-5 mt-10"}>
                    <div className="flex items-start">
                      <div className="mr-5 flex flex-col items-center flex-shrink-0">
                        <Link
                          href={route("channel", {
                            user: v.user?.username,
                          })}
                        >
                          <img
                            src={v.user?.profile_picture}
                            className="w-14 h-14 rounded-full"
                          />
                        </Link>
                      </div>
                      <div>
                        <h3
                          className="text-lg md:text-2xl font-light text-gray-600 dark:text-white cursor-pointer"
                          onClick={(e) => playModal(e, v)}
                        >
                          {v.gallery_name}
                        </h3>

                        <div className="flex items-center flex-wrap md:space-x-2 mt-1">
                          <Link
                            href={route("channel", {
                              user: v.user?.username,
                            })}
                            className="text-sm text-gray-600 mr-2  dark:text-white"
                          >
                            @{v.user?.username}
                          </Link>

                          <span className="text-gray-600 inline-flex items-center space-x-1 dark:text-zinc-100 text-sm mr-2   ">
                            <MdOutlineInsertPhoto className="w-4 h-4 mr-0.5" />
                            {v.photos_count === 1
                              ? __("1 photo")
                              : __(":photosCount photos", {
                                  photosCount: v.photos_count,
                                })}
                          </span>
                        </div>
                      </div>
                    </div>

                    <div className="mt-2">
                      <img
                        src={v.previewPhotoUrl}
                        alt=""
                        className="rounded-lg cursor-pointer"
                        onClick={(e) => playModal(e, v)}
                      />
                    </div>
                  </div>
                ))}
              </div>
            )}

            {galleries.last_page > 1 && (
              <>
                <hr className="my-5" />

                <div className="flex text-gray-600 my-3 text-sm">
                  {__("Page: :pageNumber of :lastPage", {
                    pageNumber: galleries.current_page,
                    lastPage: galleries.last_page,
                  })}
                </div>

                <SecondaryButton
                  processing={galleries.prev_page_url ? false : true}
                  className="mr-3"
                  onClick={(e) => Inertia.visit(galleries.prev_page_url)}
                >
                  {__("Previous")}
                </SecondaryButton>

                <SecondaryButton
                  processing={galleries.next_page_url ? false : true}
                  onClick={(e) => Inertia.visit(galleries.next_page_url)}
                >
                  {__("Next")}
                </SecondaryButton>
              </>
            )}
          </div>
        </div>
      </div>
    </AuthenticatedLayout>
  );
}
