<!DOCTYPE html>
<html class="dark" lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" type="image/png" href="{{ asset(opt('favicon', 'favicon.png')) }}" sizes="128x128" />

    <title inertia>{{ opt('seo_title') }}</title>

    @if(request()->route() && request()->route()->getName() == 'home')
    <meta name="description" content="{{ opt('seo_desc')  }}" />
    <meta name="keywords" content="{{ opt('seo_keys')  }}" />
    @endif

    <meta property="og:title" content="Mo Streams Gaming Platform" />
    <meta property="og:url" content="https://gaming.mostreams.com/" />
    <meta property="og:image" content="https://gaming.mostreams.com/public/images/Logo_Background.jpg" />


    <!-- Fonts -->
    <link rel="stylesheet" type="text/css" href="{{ asset('fonts/nunito/fonts.css') }}" />

    <script>
        window.PUSHER_KEY = '{{ env('PUSHER_APP_KEY') }}';
        window.PUSHER_CLUSTER = '{{ env('PUSHER_APP_CLUSTER') }}';
    </script>

    <!-- Scripts -->
    @routes
    @viteReactRefresh
    @vite(['resources/js/app.jsx', "resources/js/Pages/{$page['component']}.jsx"])
    @inertiaHead

</head>

<body class="font-sans antialiased ">
    <div class="min-h-screen flex flex-col flex-auto flex-shrink-0">
        <x-Translations />
        @inertia
        <div id="modal-root"></div>
    </div>
</body>

</html>