@extends($activeTemplate . 'layouts.frontend')
@section('content')
    <style>
        .inner-banner-section.banner-section.bg-overlay-black.bg_img {
            display: none !important;
        }
    </style>
    <section class="banner-section bg-overlay-black bg_img" style="position: relative; overflow: hidden; padding-bottom: 150px; !important">
        <!--<video muted autoplay loop src="/assets/videos/sports_hero_sec_video.mp4" style="width: 100%; z-index: -999; position: absolute; transform: translateY(-40%);"></video>-->
        <img src="/assets/images/boxing_background_image.jpg"  style="width: 100%; z-index: -999; position: absolute; transform: translateY(-50%);">
            <div class="container">
        <div class="row justify-content-center align-items-center">
            <div class="col-xl-12 text-center">
                <div class="banner-content">
                    <h1 class="title text-white">Pay Per View</h1>
                    <div class="breadcrumb-area">
                        <nav aria-label="breadcrumb">
                            <ol class="breadcrumb justify-content-center">
                                <li class="breadcrumb-item"><a href="{{ route('home') }}">@lang('Home')</a></li>
                                <li class="breadcrumb-item active" aria-current="page">Pay Per View</li>
                            </ol>
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
        </div>
    </section>
    <section class="current-live-match-section">
        <div class="container">
            <div class="row justify-content-center gy-3">
                @forelse ($tournaments as $tournament)
                    @php
                        $version = $tournament->versionName;
                        if (auth()->check()) {
                            $subscribedTournaments = auth()->user()->subscribedTournamentId() ?? [];
                            $version = in_array($tournament->id, $subscribedTournaments) ? 'Watch' : $version;
                        }
                    @endphp
                    <div class="col-xxl-3 col-lg-4 col-sm-6">
                        <a href="{{ route('tournament.detail', [$tournament->id, slug($tournament->name)]) }}" class="current-live-match">
                            <span class="current-live-match__tag">{{ __($version) }}</span>
                            <img src="{{ getImage(getFilePath('tournament') . '/thumb_' . $tournament->image, getFileThumb('tournament')) }}" alt="">
                        </a>
                    </div>
                @empty
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <img src="{{ asset($activeTemplateTrue . 'images/no-results.png') }}" alt="">
                    </div>
                @endforelse
                {{ paginateLinks($tournaments) }}
            </div>
        </div>
    </section>
@endsection
