

<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card  ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Image'); ?></th>
                                    <th><?php echo app('translator')->get('Category'); ?></th>
                                    <th><?php echo app('translator')->get('Title'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $televisions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $television): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb"><img
                                                        src="<?php echo e(getImage(getFilePath('television') . '/' . $television->image, getFileSize('television'))); ?>"
                                                        alt="<?php echo e(__($television->name)); ?>" class="plugin_bg"></div>
                                            </div>
                                        </td>
                                        <td><?php echo e(__(@$television->category->name)); ?></td>
                                        <td><?php echo e(__($television->title)); ?></td>
                                        <td>
                                            <?php
                                                echo $television->statusBadge;
                                            ?>
                                        </td>
                                        <td>
                                            <div class="btn--group">
                                                <div class="d-flex justify-content-end flex-wrap gap-1">
                                                    <button class="btn btn-outline--info btn-sm dropdown-toggle"
                                                        data-bs-toggle="dropdown">
                                                        <i class="las la-ellipsis-v"></i> <?php echo app('translator')->get('More'); ?>
                                                    </button>
                                                    <ul class="dropdown-menu px-2">
                                                        <li>
                                                            <button
                                                                class="dropdown-item cursor-pointer text--primary editBtn"
                                                                data-television="<?php echo e($television); ?>"
                                                                data-image="<?php echo e(getImage(getFilePath('television') . '/' . $television->image, getFileSize('television'))); ?>"><i
                                                                    class="la la-pencil"></i> <?php echo app('translator')->get('Edit'); ?></button>
                                                        </li>
                                                        <?php if($television->status == Status::ENABLE): ?>
                                                            <li>
                                                                <button
                                                                    class="dropdown-item cursor-pointer text--warning confirmationBtn"
                                                                    data-question="<?php echo app('translator')->get('Are you sure to disbale this television?'); ?>"
                                                                    data-action="<?php echo e(route('admin.television.channel.status', $television->id)); ?>"><i
                                                                        class="la la-eye-slash"></i>
                                                                    <?php echo app('translator')->get('Disable'); ?></button>
                                                            </li>
                                                        <?php else: ?>
                                                            <li>
                                                                <button
                                                                    class="dropdown-item cursor-pointer text--success confirmationBtn"
                                                                    data-question="<?php echo app('translator')->get('Are you sure to enable this television?'); ?>"
                                                                    data-action="<?php echo e(route('admin.television.channel.status', $television->id)); ?>"><i
                                                                        class="la la-eye"></i> <?php echo app('translator')->get('Enable'); ?></button>
                                                            </li>
                                                        <?php endif; ?>
                                                        <li>
                                                            <button
                                                                class="dropdown-item cursor-pointer text--danger confirmationBtn"
                                                                data-question="<?php echo app('translator')->get('Are you sure to delete this television?'); ?>"
                                                                data-action="<?php echo e(route('admin.television.channel.delete', $television->id)); ?>">
                                                                <i class="la la-trash"></i> <?php echo app('translator')->get('Delete'); ?></button>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo e(route('admin.television.channel.live.comment', $television->id)); ?>"
                                                                class="dropdown-item cursor-pointer text--success <?php echo e($television->live_comments_count ? '' : 'disabled'); ?>">
                                                                <i class="lab la-rocketchat"></i> <?php echo app('translator')->get('Live Comment'); ?>
                                                                <span
                                                                    class="live-comment-badge badge badge--success"><?php echo e($television->live_comments_count); ?></span>

                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="<?php echo e(route('admin.television.channel.seo', $television->id)); ?>"
                                                                class="dropdown-item cursor-pointer text--secondary"><i
                                                                    class="la la-cog"></i> <?php echo app('translator')->get('Seo Setting'); ?></a>
                                                        </li>
                                                    </ul>

                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($televisions->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($televisions)); ?>

                    </div>
                <?php endif; ?>
            </div><!-- card end -->
        </div>
    </div>

    <!-- Plan Modal -->
    <div class="modal fade" id="televisionModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true"
        tabindex="-1">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="post" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Thumbnail Image'); ?></label>
                                    <?php if (isset($component)) { $__componentOriginaldbcc027cdd3569f61821c56d10b77c01 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.image-uploader','data' => ['image' => ''.e(getImage('/', getFileSize('television'))).'','class' => 'w-100','type' => 'ads','size' => ''.e(getFileSize('television')).'','required' => false]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('image-uploader'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['image' => ''.e(getImage('/', getFileSize('television'))).'','class' => 'w-100','type' => 'ads','size' => ''.e(getFileSize('television')).'','required' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(false)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $attributes = $__attributesOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__attributesOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01)): ?>
<?php $component = $__componentOriginaldbcc027cdd3569f61821c56d10b77c01; ?>
<?php unset($__componentOriginaldbcc027cdd3569f61821c56d10b77c01); ?>
<?php endif; ?>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Categories'); ?></label>
                                    <select name="channel_category_id" class="form-control select2">
                                        <option value=""><?php echo app('translator')->get('Select One'); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($category->id); ?>"><?php echo e(__($category->name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Title'); ?></label>
                                    <input class="form-control" name="title" type="text" required>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('URL'); ?></label>
                                    <input class="form-control" name="url" type="text" required>
                                </div>
                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Description'); ?></label>
                                    <textarea class="form-control" id="" name="description" rows="5" required></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
    <button class="btn btn--sm btn-outline--primary addBtn"><i class="la la-plus"></i><?php echo app('translator')->get('Add New'); ?></button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .dropdown-item.text--success {
            position: relative;
            padding-right: 40px !important;
        }

        .dropdown-item .live-comment-badge {
            position: absolute;
            right: 10px;
            top: 0px;
            transform: translateY(-50%);
            font-size: 10px !important;
            font-weight: 400;
        }

        .dropdown-item.disabled .live-comment-badge {
            opacity: 0.6;
            border-color: #999;
            background: rgba(153, 153, 153, 0.1);
            color: #666;
        }

        .dropdown-item.active,
        .dropdown-item:active {
            background-color: unset !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"
            var modal = $('#televisionModal');
            var defautlImage = `<?php echo e(getImage(getFilePath('television'), getFileSize('television'))); ?>`;

            $('.addBtn').on('click', function() {
                $('.modal-title').text(`<?php echo app('translator')->get('Add New Television'); ?>`);
                modal.find('form').attr('action', `<?php echo e(route('admin.television.channel.store')); ?>`);
                modal.find('.image-upload-preview').attr('style', `background-image: url(${defautlImage})`);
                modal.find('select[name=channel_category_id]').val('').change();
                modal.find('.statusGroup').hide();
                modal.modal('show');
            });

            $('.editBtn').on('click', function() {
                var television = $(this).data('television');
                $('.modal-title').text(`<?php echo app('translator')->get('Update Television'); ?>`);
                modal.find('input[name=title]').val(television.title);
                modal.find('input[name=url]').val(television.url);
                modal.find('[name=description]').val(television.description);
                modal.find('select[name=channel_category_id]').val(television.channel_category_id).change();
                modal.find('.image-upload-preview').attr('style',
                    `background-image: url(${$(this).data('image')})`);
                modal.find('form').attr('action',
                    `<?php echo e(route('admin.television.channel.store', '')); ?>/${television.id}`);
                modal.find('.statusGroup').show();
                modal.modal('show');
            });

            modal.on('hidden.bs.modal', function() {
                modal.find('form')[0].reset();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasir/public_html/tv.mostreams.com/core/resources/views/admin/television/index.blade.php ENDPATH**/ ?>