<?php if(!blank($reels)): ?>
    <section class="shorts-section ptb-80">
        <div class="container-fluid">
            <div class="seciton-title">
                <div class="seciton-title__left">
                    <h3 class="seciton-title__heading mb-0"><?php echo app('translator')->get('Shorts'); ?></h3>
                    <a href="<?php echo e(route('short.videos')); ?>" class="seciton-title__link">
                        <?php echo app('translator')->get('View All'); ?> <span class="fs-16"> <i class="las la-arrow-right"></i> </span>
                    </a>
                </div>
                <div class="seciton-title__right">
                    <div class="Short-slider-arrow">
                        <div class="slider-prev">
                            <i class="fas fa-angle-left"></i>
                        </div>
                        <div class="slider-next">
                            <i class="fas fa-angle-right"></i>
                        </div>
                    </div>
                </div>
            </div>
            <div class="shorts-slider overflow-hidden">
                <div class="swiper-wrapper">
                    <?php $__currentLoopData = $reels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reel): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <a href="<?php echo e(route('short.videos', $reel->id)); ?>" class="shorts-items">
                                <div class="video-container">
                                    <video class="video-player plyr-video" playsinline controls>
                                        <source src="<?php echo e($reel->reelVideo); ?>" type="video/mp4">
                                    </video>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<?php $__env->startPush('style'); ?>
    <style>
        .plyr__control--overlaid,
        .plyr--video .plyr__control:focus-visible,
        .plyr--video .plyr__control:hover,
        .plyr--video .plyr__control[aria-expanded="true"] {
            background: transparent;
            color: hsl(var(--base));
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/plyr.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/plyr.min.js')); ?>"></script>
    <script src="https://cdn.plyr.io/3.6.8/plyr.polyfilled.js"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        const controls = [
            'play-large',
        ];

        let players = Plyr.setup('.video-player', {
            controls,
            autoplay: false,
            ratio: '9:16'
        });

        if (players.length > 0) {
            players.forEach((player, index) => {
                player.on('mouseenter', () => {
                    players.forEach((p, i) => {
                        if (i !== index) {
                            p.pause();
                        }
                    });
                    player.muted = true;
                    player.play().catch(error => {
                        console.log('Playback prevented by the browser.', error);
                    });
                });

                player.on('mouseleave', () => {
                    player.pause();
                });
            });
        }
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/nasir/public_html/tv.mostreams.com/core/resources/views/templates/basic/partials/short_reels.blade.php ENDPATH**/ ?>