
<?php $__env->startSection('panel'); ?>
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Image | Name'); ?></th>
                                    <th><?php echo app('translator')->get('Short Name'); ?></th>
                                    <th><?php echo app('translator')->get('Season'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Version'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $tournaments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tournament): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="user">
                                                <div class="thumb"><img
                                                        src="<?php echo e(getImage(getFilePath('tournament') . '/' . $tournament->image, getFileSize('tournament'))); ?>"
                                                        alt="<?php echo e(__($tournament->name)); ?>" class="plugin_bg"></div>
                                                <span class="name"><?php echo e(__($tournament->name)); ?></span>
                                            </div>
                                        </td>
                                        <td>
                                            <?php echo e(__($tournament->short_name)); ?>

                                        </td>
                                        <td>
                                            <span><?php echo e($tournament->season); ?></span>
                                        </td>
                                        <td>
                                            <span><?php echo e(showAmount($tournament->price)); ?></span>
                                        </td>
                                        <td>
                                            <?php
                                                echo $tournament->statusBadge;
                                            ?>
                                        </td>
                                        <td>
                                            <?php
                                                echo $tournament->versionBadge;
                                            ?>
                                        </td>
                                        <td>
                                            <div class="btn--group">
                                                <div class="d-flex justify-content-end flex-wrap gap-1">
                                                    <button class="btn btn-outline--info btn-sm dropdown-toggle"
                                                        data-bs-toggle="dropdown">
                                                        <i class="las la-ellipsis-v"></i> <?php echo app('translator')->get('More'); ?>
                                                    </button>
                                                    <ul class="dropdown-menu px-2">
                                                        <li>
                                                            <a href="<?php echo e(route('admin.tournament.add', $tournament->id)); ?>"
                                                                class="dropdown-item text--primary">
                                                                <i class="la la-pen"></i> <?php echo app('translator')->get('Edit'); ?>
                                                            </a>
                                                        </li>
                                                        <?php if($tournament->status == Status::ENABLE): ?>
                                                            <li>
                                                                <button
                                                                    class="dropdown-item cursor-pointer text--warning confirmationBtn"
                                                                    data-question="<?php echo app('translator')->get('Are you sure to disbale this tournament?'); ?>"
                                                                    data-action="<?php echo e(route('admin.tournament.status', $tournament->id)); ?>"><i
                                                                        class="la la-eye-slash"></i>
                                                                    <?php echo app('translator')->get('Disable'); ?></button>
                                                            </li>
                                                        <?php else: ?>
                                                            <li>
                                                                <button
                                                                    class="dropdown-item cursor-pointer text--success confirmationBtn"
                                                                    data-question="<?php echo app('translator')->get('Are you sure to enable this tournament?'); ?>"
                                                                    data-action="<?php echo e(route('admin.tournament.status', $tournament->id)); ?>"><i
                                                                        class="la la-eye"></i> <?php echo app('translator')->get('Enable'); ?></button>
                                                            </li>
                                                        <?php endif; ?>
                                                        <li>
                                                            <a href="<?php echo e(route('admin.tournament.seo', $tournament->id)); ?>"
                                                                class="dropdown-item cursor-pointer text--secondary"><i
                                                                    class="la la-cog"></i> <?php echo app('translator')->get('Seo Setting'); ?></a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($tournaments->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo paginateLinks($tournaments) ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <?php if (isset($component)) { $__componentOriginale48b4598ffc2f41a085f001458a956d1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale48b4598ffc2f41a085f001458a956d1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.search-form','data' => ['placeholder' => 'Search by Name']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('search-form'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['placeholder' => 'Search by Name']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $attributes = $__attributesOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__attributesOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale48b4598ffc2f41a085f001458a956d1)): ?>
<?php $component = $__componentOriginale48b4598ffc2f41a085f001458a956d1; ?>
<?php unset($__componentOriginale48b4598ffc2f41a085f001458a956d1); ?>
<?php endif; ?>
    <a href="<?php echo e(route('admin.tournament.add')); ?>" class="btn btn-outline--primary"><i
            class="las la-plus"></i><?php echo app('translator')->get('Add New'); ?></a>
<?php $__env->stopPush(); ?>


<?php $__env->startPush('style'); ?>
    <style>
        .dropdown-item.active,
        .dropdown-item:active {
            background-color: unset !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasir/public_html/tv.mostreams.com/core/resources/views/admin/tournaments/index.blade.php ENDPATH**/ ?>