<?php $__env->startSection('content'); ?>
    <section class="match-details-banner-section bg_img" data-background="<?php echo e(getImage(getFilePath('tournament') . '/' . $tournament->image, getFileSize('tournament'))); ?>">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="match-details-banner-buttons">
                        <?php if($watchEligible): ?>
                            <a href="<?php echo e(route('tournament.games', [$tournament->id, slug($tournament->name)])); ?>" class="btn btn--base"><i class="far fa-play-circle"></i> <?php echo app('translator')->get('Watch Now'); ?></a>
                        <?php else: ?>
                            <button class="btn btn--base eventPurchaseBtn" type="button"><i class="fas fa-lock"></i> <?php echo app('translator')->get('Subscribe Now'); ?></button>
                        <?php endif; ?>
                        <button type="button" class="btn btn--white shareBtn"><i class="fas fa-share-alt text--dark"></i></button>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="recent-match-section section--bg ">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="event--tab nav nav-pills" id="pills-tab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="pills-details-tab" data-bs-toggle="pill" data-bs-target="#pills-details" type="button" role="tab" aria-controls="pills-details" aria-selected="true"><?php echo app('translator')->get('Details'); ?></button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button class="nav-link" id="pills-match-tab" data-bs-toggle="pill" data-bs-target="#pills-match" type="button" role="tab" aria-controls="pills-match" aria-selected="false"><?php echo app('translator')->get('Matches'); ?></button>
                        </li>
                    </ul>
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="pills-details" role="tabpanel" aria-labelledby="pills-details-tab" tabindex="0">
                            <div class="row">
                                <div class="col-xl-7 col-lg-9">
                                    <div class="match-details-content">
                                        <h2 class="match-details-content__title"><?php echo e(__($tournament->name)); ?></h2>
                                        <p class="match-details-content__desc">
                                            <?php echo e(__($tournament->description)); ?>

                                        </p>
                                        <ul class="match-details-content__list">
                                            <li>
                                                <span class="title"><?php echo app('translator')->get('Season'); ?></span>
                                                <span class="desc"><?php echo e($tournament->season); ?></span>
                                            </li>
                                            <li>
                                                <span class="title"><?php echo app('translator')->get('Price'); ?></span>
                                                <span class="desc"><?php echo e(showAmount($tournament->price)); ?></span>
                                            </li>
                                        </ul>
                                        <?php
                                            $policyPages = getContent('policy_pages.element', false, null, true);
                                        ?>
                                        <span class="match-details-content__desc sm"><?php echo app('translator')->get('By clicking "Watch Now" you acknowledge and accept our terms'); ?>
                                            <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <a href="<?php echo e(route('policy.pages', $policy->slug)); ?>" target="_blank"><?php echo e(__(@$policy->data_values->title)); ?></a>
                                                <?php echo e($loop->last ? '' : ','); ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="pills-match" role="tabpanel" aria-labelledby="pills-match-tab" tabindex="0">
                            <div class="row gy-3">
                                <?php echo $__env->make('Template::partials.games', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="modal alert-modal" id="eventPurchaseModal" >
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form action="<?php echo e(route('user.subscribe.tournament', $tournament->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <span class="alert-icon"><i class="fas fa-question-circle"></i></span>
                        <p class="modal-description"><?php echo app('translator')->get('Confirmation Alert!'); ?></p>
                        <p class="modal--text"><?php echo app('translator')->get('Are you sure to subscribe this tournament?'); ?></p>
                        <p class="modal--text"><?php echo app('translator')->get('The subscription price is '); ?> <?php echo e(showAmount($tournament->price)); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark btn--sm" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('No'); ?></button>
                        <button class="btn btn--base btn--sm" type="submit"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal custom--modal-two" id="shareModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"> <?php echo app('translator')->get('Share'); ?> </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <span class="close-icon"> <i class="las la-times"></i> </span>
                    </button>
                </div>
                <div class="modal-body">
                    <ul class="social-list">
                        <li class="social-list__item"><a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>" class="social-list__link facebook"><i class="fab fa-facebook-f"></i></a> </li>
                        <li class="social-list__item"><a target="_blank" href="https://twitter.com/intent/tweet?text=<?php echo e(__(@$tournament->name)); ?>%0A<?php echo e(url()->current()); ?>" class="social-list__link twitter"> <i class="fab fa-twitter"></i></a></li>
                        <li class="social-list__item"><a target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(urlencode(url()->current())); ?>&amp;title=<?php echo e(__($tournament->title)); ?>&amp;summary=<?php echo e(__($tournament->description)); ?>" class="social-list__link linkedin"> <i class="fab fa-linkedin-in"></i></a></li>
                        <li class="social-list__item"><a target="_blank" href="http://pinterest.com/pin/create/button/?url=<?php echo e(urlencode(url()->current())); ?>&description=<?php echo e(__(@$tournament->name)); ?>&media=<?php echo e(getImage(getFilePath('tournament') . '/' . $tournament->image, getFileSize('tournament'))); ?>" class="social-list__link pinterest"> <i class="fab fa-pinterest-p"></i></a></li>
                    </ul>
                    <div class="bar">
                        <input type="text" class="share-link" value="<?php echo e(route('tournament.detail', [$tournament->id, slug($tournament->name)])); ?>">
                        <button class="btn btn--base btn--sm pill"> <?php echo app('translator')->get('Copy'); ?> </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .recent-match-section {
            padding-bottom: 80px !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.eventPurchaseBtn').on('click', function(e) {
                var modal = $('#eventPurchaseModal');
                modal.modal('show');
            });
            $('.shareBtn').on('click', function(e) {
                var modal = $('#shareModal');
                modal.modal('show');
            });

            $('.pill').on('click', function() {
                var copyText = document.getElementsByClassName("share-link");
                copyText = copyText[0];
                copyText.select();
                copyText.setSelectionRange(0, 99999);
                document.execCommand("copy");
                navigator.clipboard.writeText(copyText.value);
            });
        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mostream/tv.mostreams.com/core/resources/views/templates/basic/tournaments/detail.blade.php ENDPATH**/ ?>