
<?php $__env->startSection('content'); ?>
    <section class="plan-section section--bg ptb-80">
        <div class="container">
            <div class="row justify-content-center gy-4">
                <?php
                    $user = auth()->user();
                ?>
                <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <div class="plan-item">
                            <?php if(auth()->guard()->check()): ?>
                                <?php if($user->exp > now() && $user->plan_id == $plan->id): ?>
                                    <div class="package-expire">
                                        <h6 class="package-expire-title"><?php echo app('translator')->get('Expire this after'); ?></h6>
                                        <span class="package-expire-date"><?php echo e(diffForHumans($user->exp)); ?></span>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                            <div class="plan-content">
                                <span class="sub-title"><?php echo e(__($plan->name)); ?></span>
                                <h2 class="amount"><?php echo e(showAmount($plan->pricing)); ?></h2>

                                <ul class="package-benifits">
                                    <li class="package-benifits-item">
                                        <span class="package-benifits-icon"><i class="las la-check"></i></span><?php echo app('translator')->get('Get ' . $plan->duration . ' days subscription'); ?>
                                    </li>
                                    <li class="package-benifits-item">
                                        <span class="package-benifits-icon"><i class="las la-check"></i></span><?php echo app('translator')->get('Show Ads - '); ?> <?php echo e(__($plan->showAdStatus)); ?>

                                    </li>
                                    <?php if(gs('device_limit')): ?>
                                        <li class="package-benifits-item">
                                            <span class="package-benifits-icon"><i class="las la-check"></i></span> <?php echo app('translator')->get('Connect with ' . $plan->device_limit . ' device'); ?>
                                        </li>
                                    <?php endif; ?>
                                </ul>
                                <?php if(auth()->guard()->check()): ?>
                                    <button class="plan-btn subscriptionBtn" data-action="<?php echo e(route('user.subscribe.plan', $plan->id)); ?>" <?php if($user->exp > now()): echo 'disabled'; endif; ?>><?php echo app('translator')->get('Subscribe Now'); ?></button>
                                <?php else: ?>
                                    <button class="plan-btn subscribeBtn" type="button"><?php echo app('translator')->get('Subscribe Now'); ?></button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <img src="<?php echo e(asset($activeTemplateTrue . 'images/no-results.png')); ?>" alt="">
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <div class="modal alert-modal" id="loginAlertModal" >
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-body">
                    <span class="alert-icon"><i class="fas fa-question-circle"></i></span>
                    <p class="modal-description"><?php echo app('translator')->get('Confirmation Alert!'); ?></p>
                    <p class="modal--text"><?php echo app('translator')->get('You need to login first'); ?></p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn--dark btn--sm" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('Cancel'); ?></button>
                    <a class="btn btn--base btn--sm" href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login Now'); ?></a>
                </div>
            </div>
        </div>
    </div>

    <div class="modal alert-modal" id="subscriptionModal" >
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <form method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <span class="alert-icon"><i class="fas fa-question-circle"></i></span>
                        <p class="modal-description"><?php echo app('translator')->get('Confirmation Alert!'); ?></p>
                        <p class="modal--text"><?php echo app('translator')->get('Are you sure to subscribe this plan?'); ?></p>
                    </div>
                    <div class="modal-footer">
                        <button class="btn btn--dark btn--sm" data-bs-dismiss="modal" type="button"><?php echo app('translator')->get('No'); ?></button>
                        <button class="btn btn--base btn--sm" type="submit"><?php echo app('translator')->get('Yes'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.subscribeBtn').on('click', function(e) {
                let modal = $('#loginAlertModal');
                modal.modal('show');
            });

            $('.subscriptionBtn').on('click', function(e) {
                let modal = $('#subscriptionModal');
                let data = $(this).data();
                modal.find('form').attr('action', `${data.action}`);
                modal.modal('show');
            });

        })(jQuery)
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/mostream/tv.mostreams.com/core/resources/views/templates/basic/subscription.blade.php ENDPATH**/ ?>