
<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card  ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table--light style--two table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('S.N'); ?></th>
                                    <th><?php echo app('translator')->get('Name'); ?></th>
                                    <th><?php echo app('translator')->get('IAP Code'); ?></th>
                                    <th><?php echo app('translator')->get('Price'); ?></th>
                                    <th><?php echo app('translator')->get('Duration'); ?></th>
                                    <th><?php echo app('translator')->get('Ads'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($plans->firstItem() + $loop->index); ?></td>
                                        <td><?php echo e(__($plan->name)); ?></td>
                                        <td><?php echo e($plan->app_code); ?></td>
                                        <td><?php echo e(showAmount($plan->pricing)); ?></td>
                                        <td><?php echo e($plan->duration); ?> <?php echo app('translator')->get('days'); ?></td>
                                        <td>
                                            <span><?php echo e($plan->showAdStatus); ?></span>
                                        </td>
                                        <td>
                                            <?php
                                                echo $plan->statusBadge;
                                            ?>
                                        </td>

                                        <td>
                                            <div class="button--group">
                                                <button class="btn btn--sm btn-outline--primary editBtn" data-plan="<?php echo e($plan); ?>"><i class="la la-pencil"></i><?php echo app('translator')->get('Edit'); ?></button>
                                                <?php if($plan->status == Status::ENABLE): ?>
                                                    <button class="btn btn--sm btn-outline--danger confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure disbale this plan'); ?>?" data-action="<?php echo e(route('admin.plan.status', $plan->id)); ?>"><i class="la la-eye-slash"></i><?php echo app('translator')->get('Disable'); ?></button>
                                                <?php else: ?>
                                                    <button class="btn btn--sm btn-outline--success confirmationBtn" data-question="<?php echo app('translator')->get('Are you sure enable this plan'); ?>?" data-action="<?php echo e(route('admin.plan.status', $plan->id)); ?>"><i class="la la-eye"></i><?php echo app('translator')->get('Enable'); ?></button>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($plans->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($plans)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Plan Modal -->
    <div class="modal fade" id="planModal" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true" tabindex="-1">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"></h5>
                    <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </button>
                </div>
                <form method="post">
                    <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Name'); ?></label>
                            <input class="form-control" name="name" type="text" required>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Price'); ?></label>
                            <div class="input-group">
                                <input class="form-control" name="price" type="number" step="any" required>
                                <span class="input-group-text"><?php echo e(gs('cur_text')); ?></span>
                            </div>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('App Purchase Code'); ?></label><span title="<?php echo app('translator')->get('You need to add this code to the Google Play Store and App Store'); ?>"><i class="la la-info-circle"></i></span>
                            <input class="form-control" name="app_code" type="text" required>
                        </div>
                        <div class="form-group">
                            <label><?php echo app('translator')->get('Duration'); ?></label>
                            <div class="input-group">
                                <input class="form-control" name="duration" type="number" required>
                                <span class="input-group-text"><?php echo app('translator')->get('Days'); ?></span>
                            </div>
                        </div>
                        <?php if(gs('device_limit')): ?>
                            <div class="form-group">
                                <label><?php echo app('translator')->get('Device Limit'); ?></label>
                                <div class="input-group">
                                    <input class="form-control" name="device_limit" type="number" required>
                                    <span class="input-group-text"><?php echo app('translator')->get('Qty'); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        <div class="form-group mt-2">
                            <label for="inputName"><?php echo app('translator')->get('Show Ads'); ?></label>
                            <input name="show_ads" data-width="100%" data-height="40px" data-offstyle="-danger" data-onstyle="-success" data-bs-toggle="toggle" data-on="<?php echo app('translator')->get('YES'); ?>" data-off="<?php echo app('translator')->get('NO'); ?>" type="checkbox">
                        </div>
                        <button class="btn btn--primary w-100 h-45" type="submit"><?php echo app('translator')->get('Submit'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <?php if (isset($component)) { $__componentOriginalbd5922df145d522b37bf664b524be380 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbd5922df145d522b37bf664b524be380 = $attributes; } ?>
<?php $component = App\View\Components\ConfirmationModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('confirmation-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\ConfirmationModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $attributes = $__attributesOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__attributesOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbd5922df145d522b37bf664b524be380)): ?>
<?php $component = $__componentOriginalbd5922df145d522b37bf664b524be380; ?>
<?php unset($__componentOriginalbd5922df145d522b37bf664b524be380); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('breadcrumb-plugins'); ?>
    <button class="btn btn--sm btn-outline--primary addBtn"><i class="la la-plus"></i><?php echo app('translator')->get('Add New'); ?></button>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict"
            let modal = $('#planModal');
            $('.addBtn').on('click', function() {
                $('.modal-title').text(`<?php echo app('translator')->get('Add New Plan'); ?>`);
                modal.find('form').attr('action', `<?php echo e(route('admin.plan.store')); ?>`);
                modal.find('input[name=show_ads]').bootstrapToggle('off');
                modal.modal('show');
            });

            $('.editBtn').on('click', function() {
                $('.modal-title').text(`<?php echo app('translator')->get('Update Plan'); ?>`);
                var plan = $(this).data('plan');
                modal.find('form').attr('action', `<?php echo e(route('admin.plan.store', '')); ?>/${plan.id}`);
                modal.find('[name=name]').val(plan.name);
                modal.find('[name=price]').val(Math.abs(plan.pricing));
                modal.find('[name=duration]').val(plan.duration);
                modal.find('[name=app_code]').val(plan.app_code);
                modal.find('[name=device_limit]').val(plan.device_limit);
                if (plan.show_ads == 1) {
                    modal.find('input[name=show_ads]').bootstrapToggle('on');
                } else {
                    modal.find('input[name=show_ads]').bootstrapToggle('off');
                }
                modal.modal('show');
            });

            modal.on('hidden.bs.modal', function() {
                $('#planModal form')[0].reset();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasir/public_html/tv.mostreams.com/core/resources/views/admin/plan/index.blade.php ENDPATH**/ ?>