
<?php $__env->startSection('content'); ?>
    <section class="ptb-80">
        <div class="container">

            <div class="row gy-4 justify-content-center">
                <div class="col-lg-8 pe-lg-5">
                    <div class="movie-item">
                        <video playsinline class="video-player"
                               poster="<?php echo e(getImage(getFilePath('game') . '/' . $game->image, getFileSize('game'))); ?>">
                            <source src="<?php echo e($game->link); ?>">
                        </video>
                    </div>
                </div>
                <?php if(gs('control_socket')): ?>
                    <div class="col-lg-4">
                        <span class="show--chat d-none"> <?php echo app('translator')->get('Show Chat'); ?></span>
                        <div class="mb-4">
                            <div class="chat">
                                <div class="chat__header">
                                    <h3 class="mb-0"><?php echo app('translator')->get('Live Chat'); ?></h3>
                                    <span class="hide--chat"><i class="las la-times"></i></span>
                                </div>
                                <div class="chat__body">
                                    <div id="live-tv-comments-container" class="comments-container">
                                        <!-- Comments will appear here -->
                                    </div>
                                </div>
                                <div class="chat__footer">
                                    <form id="live-tv-comment-form" class="chat__box">
                                        <div class="chat__box-left">
                                            <input id="live-tv-comment-input" data-emojiable="true" type="text"
                                                   class="chat__box-input" placeholder="<?php echo app('translator')->get('Chat...'); ?>">
                                            <span class="emoji chat__box-icon" id="emoji-button" data-emojiable="true">
                                                <i class="las la-smile"></i>
                                            </span>
                                        </div>
                                        <button id="live-tv-comment-push-btn" type="submit" class="chat__box-btn">
                                            <i class="las la-paper-plane"></i>
                                        </button>
                                    </form>
                                    <small class="note-text-info">
                                        <i class="las la-info-circle"></i>
                                        <?php echo app('translator')->get('All messages you send will appear publicly'); ?>
                                    </small>
                                </div>
                                <div class="connection-overlay">
                                    <div class="connection-status">
                                        <span class="icon">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                 viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"
                                                 stroke-linecap="round" stroke-linejoin="round"
                                                 class="lucide lucide-wifi-off">
                                                <path d="M12 20h.01" />
                                                <path d="M8.5 16.429a5 5 0 0 1 7 0" />
                                                <path d="M5 12.859a10 10 0 0 1 5.17-2.69" />
                                                <path d="M19 12.859a10 10 0 0 0-2.007-1.523" />
                                                <path d="M2 8.82a15 15 0 0 1 4.177-2.643" />
                                                <path d="M22 8.82a15 15 0 0 0-11.288-3.764" />
                                                <path d="m2 2 20 20" />
                                            </svg>
                                        </span>
                                        <span class="text"><?php echo app('translator')->get('Connection lost. Trying to reconnect'); ?>...</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    <section class="recent-match-section section--bg ptb-80">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <ul class="event--tab nav nav-pills" id="pills-tab" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button class="nav-link active" id="pills-details-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-details" type="button" role="tab" aria-controls="pills-details"
                                    aria-selected="true"><?php echo app('translator')->get('Details'); ?></button>
                        </li>
                    </ul>
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="pills-details" role="tabpanel"
                             aria-labelledby="pills-details-tab" tabindex="0">
                            <div class="row">
                                <div class="col-xl-7 col-lg-9">
                                    <div class="match-details-content">
                                        <h2 class="match-details-content__title"><?php echo e(__(@$game->teamOne->name)); ?>

                                            <?php echo app('translator')->get('VS'); ?> <?php echo e(__(@$game->teamTwo->name)); ?></h2>
                                        <p class="match-details-content__desc">
                                            <?php echo e(__($game->details)); ?>

                                        </p>
                                        <ul class="match-details-content__list">
                                            <li>
                                                <span class="title"><?php echo app('translator')->get('Release Date'); ?></span>
                                                <span class="desc"><?php echo e(showDateTime($game->start_time)); ?></span>
                                            </li>
                                            <li>
                                                <span class="title"><?php echo app('translator')->get('Tournament'); ?></span>
                                                <span class="desc"><?php echo e(__(@$game->tournament->name)); ?></span>
                                            </li>
                                            <li>
                                                <span class="title"><?php echo app('translator')->get('Season'); ?></span>
                                                <span class="desc"><?php echo e($game->tournament->season); ?></span>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .plyr__poster {
            background-size: cover;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/plyr.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/plyr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/global/js/hls.min.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/global/js/emoji.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $(document).find('.plyr__controls').addClass('d-none');
            $(document).find('.ad-video').find('.plyr__controls').addClass('d-none');

            // Show/Hide Chat Functionality
            const chatDiv = $('.chat');
            const showChatButton = $('.show--chat');
            const hideChatButton = $('.hide--chat');
            showChatButton.on('click', function() {
                chatDiv.removeClass('d-none');
                hideChatButton.removeClass('d-none');
                showChatButton.addClass('d-none');
            });
            hideChatButton.on('click', function() {
                chatDiv.addClass('d-none');
                showChatButton.removeClass('d-none');
                hideChatButton.addClass('d-none');
            });

            document.addEventListener('DOMContentLoaded', () => {

                const video = document.querySelector('video');
                const source = video.currentSrc;
                const controls = [
                    'play',
                    'play-large',
                ];
                const player = new Plyr(video, {
                    ratio: '16:9',
                    autoPlay: true,
                });

                player.on('play', () => $('.plyr__controls').removeClass('d-none'));

                if (!Hls.isSupported()) {
                    video.src = source;
                } else {
                    const hls = new Hls();
                    hls.loadSource(source);
                    hls.attachMedia(video);
                    window.hls = hls;
                }

                window.player = player;
            });

        })(jQuery)
    </script>

    <?php if(!empty(gs('control_socket'))): ?>
        <script>
            window.liveTvConfig = {
                liveTvId: `<?php echo e(request()->id ?? ''); ?>`,
                commentStoreRoute: `<?php echo e(route('live-game.comments.store')); ?>`,
                commentGetRoute: `<?php echo e(route('live-game.comments.get', ['liveTvId' => request()->id ?? ''])); ?>`,
                csrfToken: `<?php echo e(csrf_token()); ?>`,
                socketUri: `<?php echo e(gs('socket_appuri')); ?>`,
            };
        </script>
        <script src="<?php echo e(asset('assets/global/js/ws.js')); ?>"></script>
    <?php endif; ?>

<?php $__env->stopPush(); ?>



<?php $__env->startPush('style'); ?>
    <style>
        .plyr__poster {
            background-size: cover;
        }

        .user__name {
            color: #fff;
        }

        .message-item__wrapper {
            display: flex;
        }

        .message-item__profile img {
            border-radius: 50%;
            width: 35px;
        }


        .comment-content {
            margin-left: 10px;
            cursor: pointer;
        }

        .show--chat {
            cursor: pointer;
            color: hsl(var(--white));
            border: 1px solid #363a43;
            border-radius: 24px;
            padding: 7px 10px;
            width: 100%;
            text-align: center;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .show--chat:hover {
            background-color: #363a43;
            color: hsl(var(--white));
            display: flex;
            flex-direction: column;
        }

        .chat {
            height: 550px;
            display: flex;
            flex-direction: column;
            gap: 12px;
            border-radius: 8px;
            border: 1px solid rgba(255, 255, 255, 0.15);
            overflow: hidden;
            position: relative;
        }

        .chat__header {
            display: flex;
            align-content: center;
            justify-content: space-between;
            padding: 1rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.15);
        }

        .chat__header .hide--chat {
            font-size: 1.5rem;
            color: hsl(var(--white));
            cursor: pointer;
        }

        .chat__body {
            flex: 1;
            overflow-y: auto;
            padding: 1rem;
            scroll-behavior: smooth;
        }

        .chat__body::-webkit-scrollbar {
            width: 3px;
            height: 3px;
        }

        .chat__body::-webkit-scrollbar-thumb {
            background-color: rgba(255, 255, 255, 0.322);
            border: 0px solid transparent;
            border-radius: 10px;
        }

        .message-item {
            display: flex;
            align-items: center;
            gap: 12px;
        }

        .message-item:not(:last-child) {
            margin-bottom: 12px;
        }

        .message-item__thumb {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            overflow: hidden;
            flex-shrink: 0
        }

        .message-item__thumb img {
            object-fit: cover;
            width: 100%;
            height: 100%;
        }

        .message-item__content {
            flex: 1;
        }

        .chat__footer {
            padding: 1rem;
            border-top: 1px solid rgba(255, 255, 255, 0.15);
        }

        .user__name,
        .message-item__text {
            font-size: 0.875rem;
            color: hsl(var(--white));
            cursor: default;
        }

        .user__name {
            color: hsl(var(--white) / 0.75)
        }

        .chat__box {
            display: flex;
            gap: 12px;
        }

        .chat__box-left {
            flex: 1;
            display: flex;
            gap: 6px;
            background-color: #363a43;
            border-radius: 6px;
        }

        .chat__box-input {
            width: 100%;
            flex: 1;
            background-color: transparent;
            border: 0px;
            outline: none;
            color: hsl(var(--white));
            padding-inline: 12px;
        }

        .chat__box-input::placeholder {
            color: #bfbfbf;
            font-weight: 500;
            font-size: 14px;
        }

        .chat__box-icon {
            flex-shrink: 0;
            color: hsl(var(--white));
            width: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            cursor: pointer;
        }

        .chat__box-btn {
            flex-shrink: 0;
            color: hsl(var(--white));
            background-color: transparent;
            font-size: 1.5rem;
        }

        .note-text-info {
            display: flex;
            align-items: center;
            gap: 4px;
            color: hsl(var(--white) / 0.5);
            font-weight: 400;
            margin-top: 4px;
        }

        /* Emoji */
        .emoji-picker {
            background: #0d0d31 !important;
            border: 1px solid #3E3E60 !important;
        }

        .emoji-picker__search {
            border: 1px solid #3E3E60 !important;
            background: transparent;
            color: #ffffff;
        }

        .emoji-picker__search::placeholder {
            color: #ffffff;
        }

        .emoji-picker__search-icon {
            top: 3px !important;
        }

        .emoji-picker__category-button {
            color: #ffffff !important;
        }

        .emoji-picker__category-button:hover {
            color: hsl(var(--base)) !important;
        }

        .emoji-picker__category-button.active {
            color: hsl(var(--base)) !important;
            border-bottom: 2px solid hsl(var(--base)) !important;
        }

        .emoji-picker__emojis {
            overflow-x: hidden !important;
        }

        .emoji-picker__preview {
            display: none !important;
        }

        .emoji-picker__emoji {
            color: #ffffff;
            font-size: 18px !important;
            line-height: 1 !important;
        }

        .emoji-picker__emoji:focus,
        .emoji-picker__emoji:hover {
            background: #3E3E60 !important;
        }

        .emoji-picker__emojis .emoji-picker__category-name {
            color: #ffffff !important;
            text-transform: capitalize !important;
            font-weight: 500 !important;
        }

        /* Emoji Scrollbar */
        .emoji-picker__emojis::-webkit-scrollbar {
            width: 5px;
        }

        .emoji-picker__emojis::-webkit-scrollbar-thumb {
            background-color: #3E3E60;
            border-radius: 5px;
        }

        .emoji-picker__emojis::-webkit-scrollbar-track {
            background-color: transparent;
        }



        .connection-overlay {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgb(33 32 32 / 20%);
            backdrop-filter: blur(4px);
            display: flex;
            justify-content: center;
            align-items: center;
            opacity: 0;
            visibility: hidden;
        }

        .connection-overlay.active {
            opacity: 1;
            visibility: visible;
        }

        .connection-status {
            text-align: center;
        }

        .connection-status .icon svg {
            color: #958b8b;
            height: 32px;
            width: 32px;
        }

        .connection-status .text {
            margin-top: 10px;
            color: #ddd;
            display: block;
            font-size: 0.875rem;
        }

        .movie-item-wrapper {
            display: flex;
            align-items: center;
            justify-content: center;
            height: 100%;
        }

        .movie-item {
            width: 100%;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/nasir/public_html/tv.mostreams.com/core/resources/views/templates/basic/games/watch.blade.php ENDPATH**/ ?>